<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\TransactionSetting;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class TrxSettingsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = __("Fees & Charges");
        $transaction_charges = TransactionSetting::all();
        return view('admin.sections.trx-settings.index',compact(
            'page_title',
            'transaction_charges'
        ));
    }

    /**
     * Update transaction charges
     * @param Request closer
     * @return back view
     */
    public function trxChargeUpdate(Request $request) {
        $validator = Validator::make($request->all(),[
            'slug'                              => 'required|string',
            $request->slug.'_fixed_charge'      => 'required|numeric',
            $request->slug.'_percent_charge'    => 'required|numeric',
            $request->slug.'_min_limit'         => 'required|numeric',
            $request->slug.'_max_limit'         => 'required|numeric',
            $request->slug.'_daily_limit'       => 'nullable|numeric',
            $request->slug.'_monthly_limit'     => 'nullable|numeric',
        ]);
        $validated = $validator->validate();

        $transaction_setting = TransactionSetting::where('slug',$request->slug)->first();

        if(!$transaction_setting) return back()->with(['error' => [__('Transaction charge not found!')]]);
        $validated = replace_array_key($validated,$request->slug."_");

        try{
            $transaction_setting->update($validated);
        }catch(Exception $e) {
            return back()->with(['error' => [__("Something went wrong! Please try again.")]]);
        }

        return back()->with(['success' => [__('Charge Updated Successfully!')]]);

    }

}
