<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Exception;
use App\Models\Admin\Area;
use App\Models\Admin\Language;
use App\Models\Admin\UsefulLink;
use App\Models\Frontend\Subscribe;
use App\Models\Admin\ParlourList;
use App\Models\Admin\Blog;
use App\Models\Admin\BlogCategory;
use App\Models\Frontend\ContactRequest;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use App\Providers\Admin\BasicSettingsProvider;
use App\Constants\SiteSectionConst;
use App\Models\Admin\SiteSections;
use Illuminate\Support\Str;
use App\Http\Helpers\Api\Helpers as ApiResponse;
use App\Models\Admin\ParlourHasService;
use App\Models\Admin\ParlourListHasSchedule;
use App\Http\Helpers\Response;

class IndexController extends Controller
{

    protected $languages;
    public function __construct()
    {
        $this->languages = Language::get();
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(BasicSettingsProvider $basic_settings)
    {
        try {
            $page_title = $basic_settings->get()?->site_name . " | " . $basic_settings->get()?->site_title;
            $banner = SiteSections::getData(Str::slug(SiteSectionConst::BANNER_SECTION))->first();
            $service = SiteSections::getData(Str::slug(SiteSectionConst::SERVICES_SECTION))->first();
            $languages = $this->languages;
            $lang = request()->lang;
            $default = 'en';

            $bannerData = [];
            $bannerData[] = [
                'image'     => $banner->value->image  ?? '',
                'heading' => $banner->value->language->$lang->heading  ?? '',
                'sub_heading' => $banner->value->language->$lang->sub_heading ?? '',
                'left_button' => $banner->value->language->$lang->left_button ?? '',
                'right_button' => $banner->value->language->$lang->right_button ?? '',
            ];


            $serviceData = [];
            $serviceData[] = [
                'title'     => $service->value->language->$lang->title  ?? '',
                'sub_heading' => $service->value->language->$lang->sub_heading  ?? '',
                'heading' => $service->value->language->$lang->heading ?? '',
            ];

                  foreach ($service->value->items as $value) {
                    $serviceData[] = [
                        'id'    => $value->id,
                        'image'    => $value->image,
                        'title' => $value->language->$lang->title,
                        'description' => $value->language->$lang->description,
                    ];
            }

            $home = [
                'default_image' => files_asset_path_basename("default"),
                "image_path"    => "public/frontend/images/site-section",
                "base_ur"       => url('/'),
                'bannerData' => $bannerData,
                'serviceData' => $serviceData,
            ];

            $message = ['success' => [__('Data fetch Successfully')]];
            return ApiResponse::success($message, $home);
        } catch (Exception $e) {
            $message = ['error' => [__('Something went wrong! Please try again')]];
            return ApiResponse::onlyError($message);
        }
    }


    /**
     * Method for parlour Service and schedule
     */
    public function scheduleService()
    {
        $parlour_has_service   = ParlourHasService::orderBy("id")->get()->map(function ($data) {
            return [
                'id'                => $data->id,
                'parlour_list_id'   => $data->parlour_list_id,
                'service_name'      => $data->service_name,
                'price'             => $data->price,
            ];
        });

        $parlour_has_schedule   = ParlourListHasSchedule::where('status', true)->orderBy("id")->get()->map(function ($data) {
            return [
                'id'                => $data->id,
                'parlour_list_id'   => $data->parlour_list_id,
                'from_time'         => $data->from_time,
                'to_time'           => $data->to_time,
                'max_client'        => $data->max_client,
                'status'            => $data->status
            ];
        });

        return Response::success(['Data Fetch Successfuly.'], [
            'parlour_has_service'       => $parlour_has_service,
            'parlour_has_schedule'      => $parlour_has_schedule,
        ], 200);
    }
}
