<?php

namespace App\Http\Controllers\Api\V1\Manager;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Vendor\Manager;
use Illuminate\Support\Facades\Auth;
use App\Models\Admin\ParlourList;
use App\Models\Admin\PaymentGateway;
use App\Models\ParlourBooking;
use App\Http\Helpers\Api\Helpers as ApiResponse;
use App\Constants\GlobalConst;
use App\Models\Vendor\ParlourHasStuff;
use Illuminate\Support\Carbon;

class DashboardController extends Controller
{
    public function index()
    {
        $vendor_id = auth()->user()->id;


        $salon = ParlourList::where('vendor_id', $vendor_id)->with('services')->get();

        $total_salon = $salon->count();
        $total_service = $salon->pluck('services')->flatten()->count();
        $online_payment = ParlourBooking::auth()->whereNot('payment_method',GlobalConst::CASH_PAYMENT)->with(['parlour','schedule','payment_gateway','user'])->count();

        $complete_data  = [];
        $month_day  = [];

        $start = strtotime(date('Y-m-01'));
        $end = strtotime(date('Y-m-31'));

        while ($start <= $end) {
            $start_date = date('Y-m-d', $start);

            $parlour_id = ParlourList::where('manager_id', auth()->id())->value('id');
            $complete = ParlourBooking::where('status', global_const()::STATUSSUCCESS)
                ->where('vendor_id', $vendor_id)
                ->where('parlour_id', $parlour_id)
                ->whereDate('created_at', $start_date)
                ->count();

            $complete_data[]  = $complete;
            $month_day[] = date('Y-m-d', $start);
            $start = strtotime('+1 day', $start);
        }
        $chart_one_data = [
            'complete_data'  => $complete_data,
        ];
          
              $complete = ParlourBooking::where('vendor_id', $vendor_id)->with('schedule')
            ->where('parlour_id', $parlour_id)
            ->get();

       
         $events = [];
        foreach ($complete as $item) {
            $events[] = [
                'title' => 'Booking',
                'date' => Carbon::parse($item->date)->toDateString(),
                'start_time' => $item->schedule->from_time,
                'end_time' => $item->schedule->to_time,

            ];
        }

         $stuff = ParlourHasStuff::with('parlour', 'parlour_booking')->where('vendor_id', $vendor_id)
            ->where('parlour_list_id', $parlour_id)
            ->get();

        $count_assign_stuff = $stuff->filter(function ($item) {
            return !$item->parlour_booking->isEmpty();
        })->count();

        $data = [
            'total_salon'               => $total_salon,
            'total_service'             => $total_service,
            'count_assign_stuff'        => $count_assign_stuff,
            'online_payment'            => $online_payment,
            'complete_data'             => $chart_one_data,
            'month_day'                 => $month_day,
            'manager_assign_status'     => auth()->user()->assign_status,
            'event'                     => $events,

        ];
        $message =  ['success' => [__('Manager Dashboard')]];
        return ApiResponse::success($message, $data);

    }

     /**
     * Verify user mail
     *
     * @method GET
     * @return \Illuminate\Http\Response
     */

     public function logout(){
        Auth::user()->token()->revoke();
        $message = ['success'=>[__('Logout Successful')]];
        return ApiResponse::onlySuccess($message);
     }
}
