<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;

class BookingTempData extends Model
{
    use HasFactory;
    protected $guarded  = ['id'];
    protected $casts                    = [
        'id'                            => 'integer',
        'data'                          => 'object',
        'identifier'                    => 'integer',
    ];
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }
    public function schedule(){
        return $this->belongsTo(ParlourListHasSchedule::class,'schedule_id');
    }
    public function parlour(){
        return $this->belongsTo(ParlourList::class,'parlour_id');
    }
    public function payment_gateway(){
        return $this->belongsTo(PaymentGatewayCurrency::class,'payment_gateway_currency_id');
    }
}
