<?php

namespace App\Models;

use App\Models\Vendor\Manager;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ManagerPasswordReset extends Model
{
    use HasFactory;
    protected $guarded = [
        'id',
    ];
    protected $casts = [
        'id'        => 'integer',
        'email'     => 'string',
        'code'      => 'integer',
        'token'     => 'string',
        'manager_id' => 'integer',
    ];
    public function manager() {
        return $this->belongsTo(Manager::class)->select('id','email','firstname','lastname');
    }
}
