<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ManagerNotification extends Notification
{
    use Queueable;
    public $data;
    public $password;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($data, $password)
    {
        $this->data         = $data;
        $this->password     = $password;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $data               = $this->data;
        $password           = $this->password;
        return (new MailMessage)
            ->subject("Your account has been created.")
            ->greeting(__("Hello") . " " . $data['firstname'] . ' ' . $data['lastname'] . " !")
            ->line(__("Email") . ": " . $data['email'])
            ->line(__("Password") . ": " . $password)
            ->line(__('Your Account Successfully Created.'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
