<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('parlour_lists', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("area_id");
            $table->unsignedBigInteger("vendor_id")->nullable()->default(null);
            $table->unsignedBigInteger("manager_id")->nullable()->default(null);;
            $table->string('slug');
            $table->string('name');
            $table->string('experience');
            $table->string('speciality')->nullable();
            $table->string('contact');
            $table->string('address')->nullable();
            $table->string('off_days');
            $table->integer('number_of_dates');
            $table->string('image')->nullable();
            $table->string("remarks")->nullable()->default(null);
            $table->boolean("status")->comment('STATUSSUCCESS = 1,STATUSPENDING = 2,STATUSREJECTED = 3');
            $table->boolean("active_status")->comment('STATUSFREEZE = 0,STATUSUNFREEZE = 1')->nullable();
            $table->timestamps();

            $table->foreign("area_id")->references("id")->on("areas")->onDelete("cascade")->onUpdate("cascade");
            $table->foreign("vendor_id")->references("id")->on("vendors")->onDelete("cascade")->onUpdate("cascade");
            $table->foreign("manager_id")->references("id")->on("managers")->onDelete("cascade")->onUpdate("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('parlour_lists');
    }
};
