<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('temp_stuffs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("parlour_booking_id");
            $table->unsignedBigInteger("stuff_id");
            $table->tinyInteger('status')->nullable();
            $table->timestamps();

            $table->foreign("parlour_booking_id")->references("id")->on("parlour_bookings")->onDelete("cascade")->onUpdate("cascade");
            $table->foreign("stuff_id")->references("id")->on("parlour_has_stuffs")->onDelete("cascade")->onUpdate("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('temp_stuffs');
    }
};
