<?php

namespace Database\Seeders\Admin;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Exception;
use App\Models\Admin\BasicSettings;

class FreshBasicSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            'id' => '1',
            'site_name' => 'SalonHub',
            'site_title' => 'Parlour & Salon Booking',
            'base_color' => '#AB00E9',
            'secondary_color' => '#FE59A3',

            'vendor_site_name' => 'Vendor',
            'vendor_site_title' => 'Manage Spa & Salon Business',
            'vendor_base_color' => '#4E0077',
            'vendor_secondary_color' => '#9A31FF',

            'manager_site_name' => 'Manager',
            'manager_site_title' => 'Manage your Salon & Spa',
            'manager_base_color' => '#2A50BA',
            'manager_secondary_color' => '#5477F7',

            'otp_exp_seconds' => '3600',
            'min_stuff' => '2',
            'minimum_charge_count' => '2',
            'timezone' => 'Asia/Dhaka',

            'user_registration' => '1',
            'secure_password' => '1',
            'agree_policy' => '1',
            'force_ssl' => '0',
            'email_verification' => '0',
            'sms_verification' => '0',
            'email_notification' => '0',
            'push_notification' => '1',
            'kyc_verification' => '1',

            'site_logo_dark' => '2a67bfea-7572-4e27-90ba-e16cce9fc557.webp',
            'site_logo' => 'c02ca64f-7ae7-4339-9ccc-81a273c03c29.webp',
            'site_fav_dark' => '9f62bdc9-c332-4966-9854-5ea57ebdd1e2.webp',
            'site_fav' => '51a410be-edce-42f1-858a-4f0730f53108.webp',

            'vendor_site_logo_dark' => '543bb915-7d61-44b8-a1eb-c8b85f2dbca7.webp',
            'vendor_site_logo' => 'beec8c20-a467-4523-958f-52ada197f072.webp',
            'vendor_site_fav_dark' => '9866128f-651c-4867-8863-5cc85c77bf56.webp',
            'vendor_site_fav' => 'c9e12763-a420-43a4-aa6f-13fe5af78dec.webp',

            'manager_site_logo_dark' => '05955bf4-65ba-4aff-9176-37f8da6fb9b9.webp',
            'manager_site_logo' => '9245d10f-65c4-4ef6-a633-f6f6c0e44fe5.webp',
            'manager_site_fav_dark' => '4db80ca4-aa18-414f-ae21-6c5f3d36e19f.webp',
            'manager_site_fav' => '054e128b-a990-4d15-ad7d-38e25f2de4c8.webp',

            'preloader_image' => NULL,

            'mail_config' => [
                'method' => 'smtp',
                'host' => '',
                'port' => '',
                'encryption' => '',
                'username' => '',
                'password' => '',
                'from' => '',
                'app_name' => ''
            ],

            'mail_activity' => NULL,

            'push_notification_config' => [
                'method' => 'pusher',
                'instance_id' => '3488cd8e-e72f-4bb3-9de1-9e8e0511d5b6',
                'primary_key' => '2AC53D6674DCB87FC56834DA05C7F900F54DE998E234B94C4B158B5F2E2B427F'
            ],

            'push_notification_activity' => NULL,

            'broadcast_config' => [
                'method' => 'pusher',
                'app_id' => '',
                'primary_key' => '',
                'secret_key' => '',
                'cluster' => 'ap2'
            ],

            'broadcast_activity' => NULL,

            'sms_config' => NULL,
            'sms_activity' => NULL,

            'web_version' => '2.0.0',
            'admin_version' => '2.5.0',

            'vendor_registration' => '1',
            'vendor_secure_password' => '1',
            'vendor_agree_policy' => '1',
            'vendor_email_verification' => '0',
            'vendor_sms_verification' => '0',
            'vendor_email_notification' => '0',
            'vendor_push_notification' => '1',
            'vendor_kyc_verification' => '1',

            'created_at' => '2025-02-07 17:38:48',
            'updated_at' => '2025-02-07 17:58:59'
        ];

        try {
            $basic_data     = BasicSettings::firstOrCreate($data);
            $env_modify_keys = [
                "MAIL_MAILER"       => $basic_data->mail_config->method,
                "MAIL_HOST"         => $basic_data->mail_config->host,
                "MAIL_PORT"         => $basic_data->mail_config->port,
                "MAIL_USERNAME"     => $basic_data->mail_config->username,
                "MAIL_PASSWORD"     => $basic_data->mail_config->password,
                "MAIL_ENCRYPTION"   => $basic_data->mail_config->encryption,
                "MAIL_FROM_ADDRESS" => $basic_data->mail_config->mail_address ?? '',
                "MAIL_FROM_NAME"    => $basic_data->mail_config->app_name,
                "PUSHER_APP_ID"     => $basic_data->broadcast_config->app_id,
                "PUSHER_APP_KEY"    => $basic_data->broadcast_config->primary_key,
                "PUSHER_APP_SECRET" => $basic_data->broadcast_config->secret_key,
            ];
            modifyEnv($env_modify_keys);

        } catch (Exception $e) {

        }
    }
}
