<?php

namespace Database\Seeders\Admin;

use App\Constants\GlobalConst;
use Illuminate\Database\Seeder;
use App\Models\Admin\UsefulLink;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class UsefulLinkSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $useful_links = array(
            array('id' => '1','type' => 'PRIVACY_POLICY','title' => '{"language":{"en":{"title":"Privacy Policy"},"fr":{"title":"politique de confidentialit\\u00e9"},"es":{"title":"pol\\u00edtica de privacidad"},"ar":{"title":"\\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629"}}}','slug' => 'privacy-policy','url' => 'privacy-policy','content' => '{"language":{"en":{"content":"<p>At SalonHub, your privacy is of utmost importance to us. This Privacy Policy outlines how we collect, use, protect, and disclose your information when you use our website, mobile app, and services. By accessing or using SalonHub, you agree to the terms of this Privacy Policy.<br><strong>1. Information We Collect<\\/strong><br>We may collect the following types of information:<br><strong>a. Personal Information<\\/strong><\\/p><ul style=\\"list-style-type:none;\\"><li>Name<\\/li><li>Email address<\\/li><li>Phone number<\\/li><li>Address<\\/li><li>Payment information (e.g., credit\\/debit card details, digital payment details)<\\/li><\\/ul><p><strong>b. Account Information<\\/strong><\\/p><ul style=\\"list-style-type:none;\\"><li>Username and password for accessing your account.<\\/li><\\/ul><p><strong>c. Business Information (For Vendors)<\\/strong><\\/p><ul style=\\"list-style-type:none;\\"><li>Salon or spa details, including location, images, services offered, and pricing.<\\/li><li>Bank account details for payment purposes.<\\/li><\\/ul><p><strong>d. Usage Data<\\/strong><\\/p><ul style=\\"list-style-type:none;\\"><li>Your interactions with our platform (e.g., pages visited, services viewed).<\\/li><li>IP address, browser type, operating system, and device type.<\\/li><\\/ul><p><strong>e. Cookies and Tracking Technologies<\\/strong><\\/p><ul style=\\"list-style-type:none;\\"><li>Cookies to enhance user experience and gather analytics.<\\/li><li>Web beacons and tracking pixels for improving our services.<\\/li><\\/ul><p><strong>2. How We Use Your Information<\\/strong><br>We use the information we collect for the following purposes:<\\/p><ol style=\\"list-style-type:decimal;\\"><li><strong>Account Management<\\/strong><ul style=\\"list-style-type:none;\\"><li>To create and manage user and vendor accounts.<\\/li><\\/ul><\\/li><li><strong>Service Fulfillment<\\/strong><ul style=\\"list-style-type:none;\\"><li>To process bookings, payments, and service requests.<\\/li><\\/ul><\\/li><li><strong>Communication<\\/strong><ul style=\\"list-style-type:none;\\"><li>To send confirmation emails, invoices, updates, and marketing communications (where permitted).<\\/li><\\/ul><\\/li><li><strong>Customization<\\/strong><ul style=\\"list-style-type:none;\\"><li>To personalize your experience by recommending salons or services based on your preferences.<\\/li><\\/ul><\\/li><li><strong>Analytics and Improvements<\\/strong><ul style=\\"list-style-type:none;\\"><li>To analyze user behavior and improve our platform\\u2019s functionality and features.<\\/li><\\/ul><\\/li><\\/ol><p><strong>3. How We Share Your Information<\\/strong><br>We do not sell your personal information. However, we may share your information in the following circumstances:<br><strong>a. Service Providers<\\/strong><br>We may share information with third-party vendors who help us operate the platform, process payments, or deliver marketing communications.<br><strong>b. Business Partners<\\/strong><br>With salons, spas, or service vendors to fulfill user bookings or service requests.<br><strong>c. Legal Requirements<\\/strong><br>To comply with legal obligations, such as court orders, subpoenas, or regulatory inquiries.<\\/p><ul style=\\"list-style-type:none;\\"><li>Secure Sockets Layer (SSL) encryption for data transmission.<\\/li><li>Regular security audits and vulnerability assessments.<\\/li><li>Role-based access controls to protect sensitive data.<\\/li><\\/ul><p><strong>Please Note:<\\/strong> While we take reasonable steps to protect your information, no method of electronic storage or transmission is 100% secure, and we cannot guarantee absolute security.<strong>5. Your Rights and Choices<\\/strong><br><strong>a. Access and Update Your Information<\\/strong><br>You can access and update your personal information through your SalonHub account settings.<br><strong>b. Opt-Out of Marketing Communications<\\/strong><br>You can opt-out of receiving promotional emails by clicking the \\u201cunsubscribe\\u201d link in the email.<br><strong>c. Cookies Management<\\/strong><br>You can adjust your browser settings to refuse cookies or alert you when cookies are being sent.<br><strong>d. Delete Your Account<\\/strong><br>You can request the deletion of your account and personal information by contacting us at <strong>[<\\/strong><a href=\\"mailto:support@example.com\\"><strong>support@example.com<\\/strong><\\/a><strong>]<\\/strong>.<strong>6. Third-Party Links<\\/strong><br>SalonHub may include links to third-party websites or services. We are not responsible for the privacy practices of these third parties and encourage you to review their privacy policies before engaging with them.<strong>7. Children\'s Privacy<\\/strong><br>SalonHub is not intended for individuals under the age of 18. We do not knowingly collect personal information from children. If we become aware of any such data, it will be deleted promptly.<strong>8. International Data Transfers<\\/strong><br>If you are accessing SalonHub from outside [Insert Country], note that your information may be transferred to, stored, and processed in a country where data protection laws may differ. By using SalonHub, you consent to this transfer.<strong>9. Changes to This Privacy Policy<\\/strong><br>We may update this Privacy Policy periodically to reflect changes in our practices or for legal reasons. The \\u201cEffective Date\\u201d at the top indicates the latest update. We encourage you to review this page regularly for updates.<strong>10. Contact Us<\\/strong><br>If you have any questions or concerns about this Privacy Policy, or if you wish to exercise your rights, please contact us:<\\/p><ul style=\\"list-style-type:none;\\"><li><strong>Email:<\\/strong> <a href=\\"mailto:support@example.com\\">support@example.com<\\/a><\\/li><li><strong>Phone:<\\/strong> +03601 885399<\\/li><li><strong>Address:<\\/strong> 20-22 Wenlock Road, England, N1 7GU<\\/li><\\/ul>"},"fr":{"content":"<h3>Politique de Confidentialit\\u00e9 de SalonHub<\\/h3><p>Chez SalonHub, la confidentialit\\u00e9 de nos utilisateurs est une priorit\\u00e9 absolue. Cette Politique de Confidentialit\\u00e9 d\\u00e9crit comment nous collectons, utilisons, prot\\u00e9geons et divulguons vos informations lorsque vous utilisez notre site web, application mobile et services. En acc\\u00e9dant ou en utilisant SalonHub, vous acceptez les termes de cette Politique de Confidentialit\\u00e9.<\\/p><h4>1. Informations que nous collectons<\\/h4><p>Nous pouvons collecter les types d\'informations suivants :<\\/p><p><strong>a. Informations personnelles :<\\/strong><\\/p><ul><li>Nom<\\/li><li>Adresse e-mail<\\/li><li>Num\\u00e9ro de t\\u00e9l\\u00e9phone<\\/li><li>Adresse<\\/li><li>Informations de paiement (par exemple, d\\u00e9tails des cartes de cr\\u00e9dit\\/d\\u00e9bit, informations sur les paiements num\\u00e9riques)<\\/li><\\/ul><p><strong>b. Informations de compte :<\\/strong><\\/p><ul><li>Nom d\'utilisateur et mot de passe pour acc\\u00e9der \\u00e0 votre compte.<\\/li><\\/ul><p><strong>c. Informations commerciales (pour les fournisseurs) :<\\/strong><\\/p><ul><li>D\\u00e9tails du salon ou spa, y compris l\'emplacement, les images, les services propos\\u00e9s et les tarifs.<\\/li><li>Coordonn\\u00e9es bancaires \\u00e0 des fins de paiement.<\\/li><\\/ul><p><strong>d. Donn\\u00e9es d\'utilisation :<\\/strong><\\/p><ul><li>Vos interactions avec notre plateforme (par exemple, pages visit\\u00e9es, services consult\\u00e9s).<\\/li><li>Adresse IP, type de navigateur, syst\\u00e8me d\'exploitation et type d\'appareil.<\\/li><\\/ul><p><strong>e. Cookies et technologies de suivi :<\\/strong><\\/p><ul><li>Cookies pour am\\u00e9liorer l\'exp\\u00e9rience utilisateur et collecter des analyses.<\\/li><li>Balises web et pixels de suivi pour optimiser nos services.<\\/li><\\/ul><h4>2. Comment nous utilisons vos informations<\\/h4><p>Nous utilisons les informations collect\\u00e9es pour les finalit\\u00e9s suivantes :<\\/p><p><strong>Gestion des comptes :<\\/strong><\\/p><ul><li>Cr\\u00e9er et g\\u00e9rer les comptes des utilisateurs et des fournisseurs.<\\/li><\\/ul><p><strong>Ex\\u00e9cution des services :<\\/strong><\\/p><ul><li>Traiter les r\\u00e9servations, paiements et demandes de services.<\\/li><\\/ul><p><strong>Communication :<\\/strong><\\/p><ul><li>Envoyer des e-mails de confirmation, des factures, des mises \\u00e0 jour et des communications marketing (lorsque cela est autoris\\u00e9).<\\/li><\\/ul><p><strong>Personnalisation :<\\/strong><\\/p><ul><li>Personnaliser votre exp\\u00e9rience en recommandant des salons ou services en fonction de vos pr\\u00e9f\\u00e9rences.<\\/li><\\/ul><p><strong>Analyses et am\\u00e9liorations :<\\/strong><\\/p><ul><li>Analyser le comportement des utilisateurs et am\\u00e9liorer la fonctionnalit\\u00e9 et les caract\\u00e9ristiques de notre plateforme.<\\/li><\\/ul><p><strong>Conformit\\u00e9 l\\u00e9gale :<\\/strong><\\/p><p>&nbsp;<\\/p><h4>3. Comment nous partageons vos informations<\\/h4><p>Nous ne vendons pas vos informations personnelles. Cependant, nous pouvons partager vos informations dans les circonstances suivantes :<\\/p><p><strong>a. Prestataires de services :<\\/strong><\\/p><ul><li>Nous pouvons partager des informations avec des tiers qui nous aident \\u00e0 exploiter la plateforme, traiter les paiements ou diffuser des communications marketing.<\\/li><\\/ul><p><strong>b. Partenaires commerciaux :<\\/strong><\\/p><ul><li>Avec des salons, spas ou fournisseurs de services pour r\\u00e9pondre aux r\\u00e9servations ou demandes de services des utilisateurs.<\\/li><\\/ul><p><strong>c. Obligations l\\u00e9gales :<\\/strong><\\/p><ul><li>Pour respecter des obligations l\\u00e9gales, telles que des ordonnances judiciaires, des citations ou des enqu\\u00eates r\\u00e9glementaires.<\\/li><li>&nbsp;<\\/li><\\/ul><h4>4. Protection et s\\u00e9curit\\u00e9 des donn\\u00e9es<\\/h4><p>Nous mettons en \\u0153uvre des mesures de s\\u00e9curit\\u00e9 standard de l\'industrie pour prot\\u00e9ger vos informations, notamment :<\\/p><ul><li>Chiffrement SSL pour la transmission des donn\\u00e9es.<\\/li><li>Audits de s\\u00e9curit\\u00e9 r\\u00e9guliers et \\u00e9valuations des vuln\\u00e9rabilit\\u00e9s.<\\/li><li>Contr\\u00f4les d\'acc\\u00e8s bas\\u00e9s sur les r\\u00f4les pour prot\\u00e9ger les donn\\u00e9es sensibles.<\\/li><\\/ul><p><strong>Remarque :<\\/strong> Bien que nous prenions des mesures raisonnables pour prot\\u00e9ger vos informations, aucune m\\u00e9thode de stockage ou de transmission \\u00e9lectronique n\'est 100 % s\\u00e9curis\\u00e9e, et nous ne pouvons garantir une s\\u00e9curit\\u00e9 absolue.<\\/p><h4>5. Vos droits et choix<\\/h4><p><strong>a. Acc\\u00e9der et mettre \\u00e0 jour vos informations :<\\/strong><\\/p><ul><li>Vous pouvez acc\\u00e9der et mettre \\u00e0 jour vos informations personnelles via les param\\u00e8tres de votre compte SalonHub.<\\/li><\\/ul><p><strong>b. Se d\\u00e9sinscrire des communications marketing :<\\/strong><\\/p><ul><li>Vous pouvez vous d\\u00e9sinscrire des e-mails promotionnels en cliquant sur le lien \\"se d\\u00e9sinscrire\\" dans l\'e-mail.<\\/li><\\/ul><p><strong>c. Gestion des cookies :<\\/strong><\\/p><ul><li>Vous pouvez ajuster les param\\u00e8tres de votre navigateur pour refuser les cookies ou \\u00eatre alert\\u00e9 lorsque des cookies sont envoy\\u00e9s.<\\/li><\\/ul><p><strong>d. Suppression de votre compte :<\\/strong><\\/p><ul><li>Vous pouvez demander la suppression de votre compte et de vos informations personnelles en nous contactant \\u00e0 [support@example.com].<\\/li><\\/ul><p>&nbsp;<\\/p><h4>6. Liens tiers<\\/h4><p>SalonHub peut inclure des liens vers des sites web ou services tiers. Nous ne sommes pas responsables des pratiques de confidentialit\\u00e9 de ces tiers et vous encourageons \\u00e0 consulter leurs politiques de confidentialit\\u00e9 avant d\'interagir avec eux.<\\/p><h4>7. Confidentialit\\u00e9 des enfants<\\/h4><p>SalonHub n\'est pas destin\\u00e9 aux personnes de moins de 18 ans. Nous ne collectons pas intentionnellement d\'informations personnelles sur les enfants. Si nous d\\u00e9couvrons que de telles donn\\u00e9es ont \\u00e9t\\u00e9 collect\\u00e9es, elles seront supprim\\u00e9es imm\\u00e9diatement.<\\/p><h4>8. Transferts internationaux de donn\\u00e9es<\\/h4><p>Si vous acc\\u00e9dez \\u00e0 SalonHub depuis l\'ext\\u00e9rieur de [Ins\\u00e9rer le pays], veuillez noter que vos informations peuvent \\u00eatre transf\\u00e9r\\u00e9es, stock\\u00e9es et trait\\u00e9es dans un pays o\\u00f9 les lois sur la protection des donn\\u00e9es peuvent diff\\u00e9rer. En utilisant SalonHub, vous consentez \\u00e0 ce transfert.<\\/p><p>&nbsp;<\\/p><p>&nbsp;<\\/p>"},"es":{"content":"<h3>Pol\\u00edtica de Privacidad de SalonHub<\\/h3><p>En SalonHub, la privacidad de nuestros usuarios es de suma importancia. Esta Pol\\u00edtica de Privacidad describe c\\u00f3mo recopilamos, usamos, protegemos y divulgamos su informaci\\u00f3n cuando utiliza nuestro sitio web, aplicaci\\u00f3n m\\u00f3vil y servicios. Al acceder o usar SalonHub, usted acepta los t\\u00e9rminos de esta Pol\\u00edtica de Privacidad.<\\/p><h4>1. Informaci\\u00f3n que recopilamos<\\/h4><p>Podemos recopilar los siguientes tipos de informaci\\u00f3n:<\\/p><p><strong>a. Informaci\\u00f3n personal:<\\/strong><\\/p><ul><li>Nombre<\\/li><li>Direcci\\u00f3n de correo electr\\u00f3nico<\\/li><li>N\\u00famero de tel\\u00e9fono<\\/li><li>Direcci\\u00f3n<\\/li><li>Informaci\\u00f3n de pago (por ejemplo, detalles de tarjetas de cr\\u00e9dito\\/d\\u00e9bito, detalles de pagos digitales)<\\/li><\\/ul><p><strong>b. Informaci\\u00f3n de la cuenta:<\\/strong><\\/p><ul><li>Nombre de usuario y contrase\\u00f1a para acceder a su cuenta.<\\/li><\\/ul><p><strong>c. Informaci\\u00f3n comercial (para proveedores):<\\/strong><\\/p><ul><li>Detalles del sal\\u00f3n o spa, incluyendo ubicaci\\u00f3n, im\\u00e1genes, servicios ofrecidos y precios.<\\/li><li>Detalles de la cuenta bancaria para fines de pago.<\\/li><\\/ul><p><strong>d. Datos de uso:<\\/strong><\\/p><ul><li>Sus interacciones con nuestra plataforma (por ejemplo, p\\u00e1ginas visitadas, servicios visualizados).<\\/li><li>Direcci\\u00f3n IP, tipo de navegador, sistema operativo y tipo de dispositivo.<\\/li><\\/ul><p><strong>e. Cookies y tecnolog\\u00edas de seguimiento:<\\/strong><\\/p><ul><li>Cookies para mejorar la experiencia del usuario y recopilar an\\u00e1lisis.<\\/li><li>Balizas web y p\\u00edxeles de seguimiento para mejorar nuestros servicios.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>2. C\\u00f3mo utilizamos su informaci\\u00f3n<\\/h4><p>Utilizamos la informaci\\u00f3n que recopilamos para los siguientes fines:<\\/p><p><strong>Gesti\\u00f3n de cuentas:<\\/strong><\\/p><ul><li>Para crear y gestionar cuentas de usuarios y proveedores.<\\/li><\\/ul><p><strong>Cumplimiento del servicio:<\\/strong><\\/p><ul><li>Para procesar reservas, pagos y solicitudes de servicios.<\\/li><\\/ul><p><strong>Comunicaci\\u00f3n:<\\/strong><\\/p><ul><li>Para enviar correos de confirmaci\\u00f3n, facturas, actualizaciones y comunicaciones de marketing (cuando est\\u00e9 permitido).<\\/li><\\/ul><p><strong>Personalizaci\\u00f3n:<\\/strong><\\/p><ul><li>Para personalizar su experiencia recomendando salones o servicios basados en sus preferencias.<\\/li><\\/ul><p><strong>An\\u00e1lisis y mejoras:<\\/strong><\\/p><ul><li>Para analizar el comportamiento del usuario y mejorar la funcionalidad y caracter\\u00edsticas de nuestra plataforma.<\\/li><\\/ul><p><strong>Cumplimiento legal:<\\/strong><\\/p><ul><li>Para cumplir con obligaciones legales, como prevenir el fraude y garantizar la seguridad de la plataforma.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>3. C\\u00f3mo compartimos su informaci\\u00f3n<\\/h4><p>No vendemos su informaci\\u00f3n personal. Sin embargo, podemos compartir su informaci\\u00f3n en las siguientes circunstancias:<\\/p><p><strong>a. Proveedores de servicios:<\\/strong><\\/p><ul><li>Podemos compartir informaci\\u00f3n con terceros que nos ayuden a operar la plataforma, procesar pagos o realizar comunicaciones de marketing.<\\/li><\\/ul><p><strong>b. Socios comerciales:<\\/strong><\\/p><ul><li>Con salones, spas o proveedores de servicios para cumplir con reservas de usuarios o solicitudes de servicios.<\\/li><\\/ul><p><strong>c. Requisitos legales:<\\/strong><\\/p><ul><li>Para cumplir con obligaciones legales, como \\u00f3rdenes judiciales, citaciones o consultas regulatorias.<\\/li><\\/ul><p><strong>d. Transferencias comerciales:<\\/strong><\\/p><ul><li>En caso de fusi\\u00f3n, adquisici\\u00f3n o venta de SalonHub, su informaci\\u00f3n puede ser transferida a la nueva entidad.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>4. Protecci\\u00f3n y seguridad de datos<\\/h4><p>Implementamos medidas de seguridad est\\u00e1ndar de la industria para proteger su informaci\\u00f3n, incluyendo:<\\/p><ul><li>Cifrado SSL para la transmisi\\u00f3n de datos.<\\/li><li>Auditor\\u00edas de seguridad regulares y evaluaciones de vulnerabilidades.<\\/li><li>Controles de acceso basados en roles para proteger datos sensibles.<\\/li><\\/ul><p><strong>Nota:<\\/strong> Aunque tomamos medidas razonables para proteger su informaci\\u00f3n, ning\\u00fan m\\u00e9todo de almacenamiento o transmisi\\u00f3n electr\\u00f3nica es 100% seguro y no podemos garantizar seguridad absoluta.<\\/p><p>&nbsp;<\\/p><h4>5. Sus derechos y opciones<\\/h4><p><strong>a. Acceso y actualizaci\\u00f3n de su informaci\\u00f3n:<\\/strong><\\/p><ul><li>Puede acceder y actualizar su informaci\\u00f3n personal a trav\\u00e9s de la configuraci\\u00f3n de su cuenta de SalonHub.<\\/li><\\/ul><p><strong>b. Exclusi\\u00f3n de comunicaciones de marketing:<\\/strong><\\/p><ul><li>Puede optar por no recibir correos electr\\u00f3nicos promocionales haciendo clic en el enlace \\"cancelar suscripci\\u00f3n\\" en el correo.<\\/li><\\/ul><p><strong>c. Gesti\\u00f3n de cookies:<\\/strong><\\/p><ul><li>Puede ajustar la configuraci\\u00f3n de su navegador para rechazar cookies o alertarle cuando se env\\u00eden cookies.<\\/li><\\/ul><p><strong>d. Eliminaci\\u00f3n de su cuenta:<\\/strong><\\/p><ul><li>Puede solicitar la eliminaci\\u00f3n de su cuenta e informaci\\u00f3n personal contact\\u00e1ndonos en [support@example.com].<\\/li><\\/ul><p>&nbsp;<\\/p><h4>6. Enlaces de terceros<\\/h4><p>SalonHub puede incluir enlaces a sitios web o servicios de terceros. No somos responsables de las pr\\u00e1cticas de privacidad de estos terceros y le recomendamos que revise sus pol\\u00edticas de privacidad antes de interactuar con ellos.<\\/p><p>&nbsp;<\\/p><h4>7. Privacidad de los menores<\\/h4><p>SalonHub no est\\u00e1 destinado a personas menores de 18 a\\u00f1os. No recopilamos deliberadamente informaci\\u00f3n personal de ni\\u00f1os. Si nos damos cuenta de que hemos recopilado dichos datos, ser\\u00e1n eliminados de inmediato.<\\/p><p>&nbsp;<\\/p><h4>8. Transferencias internacionales de datos<\\/h4><p>Si accede a SalonHub desde fuera de [Inserte Pa\\u00eds], tenga en cuenta que su informaci\\u00f3n puede ser transferida, almacenada y procesada en un pa\\u00eds donde las leyes de protecci\\u00f3n de datos pueden diferir. Al utilizar SalonHub, usted acepta esta transferencia.<\\/p><p>&nbsp;<\\/p><h4>&nbsp;<\\/h4><p>&nbsp;<\\/p><p>&nbsp;<\\/p>"},"ar":{"content":"<h3>\\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0644\\u0645\\u0646\\u0635\\u0629 SalonHub<\\/h3><p>\\u0641\\u064a SalonHub\\u060c \\u062a\\u0639\\u062f \\u062e\\u0635\\u0648\\u0635\\u064a\\u062a\\u0643 \\u0623\\u0645\\u0631\\u064b\\u0627 \\u0641\\u064a \\u063a\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0623\\u0647\\u0645\\u064a\\u0629 \\u0628\\u0627\\u0644\\u0646\\u0633\\u0628\\u0629 \\u0644\\u0646\\u0627. \\u062a\\u0648\\u0636\\u062d \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0647\\u0630\\u0647 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u062c\\u0645\\u0639 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0643\\u0634\\u0641 \\u0639\\u0646 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643 \\u0639\\u0646\\u062f \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u0648\\u0642\\u0639\\u0646\\u0627 \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a\\u060c \\u062a\\u0637\\u0628\\u064a\\u0642 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644\\u060c \\u0648\\u062e\\u062f\\u0645\\u0627\\u062a\\u0646\\u0627. \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0623\\u0648 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u0646\\u0635\\u0629 SalonHub\\u060c \\u0641\\u0625\\u0646\\u0643 \\u062a\\u0648\\u0627\\u0641\\u0642 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0648\\u0637 \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0647\\u0630\\u0647.<\\/p><h4>1. \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0646\\u062c\\u0645\\u0639\\u0647\\u0627<\\/h4><p>\\u0642\\u062f \\u0646\\u0642\\u0648\\u0645 \\u0628\\u062c\\u0645\\u0639 \\u0627\\u0644\\u0623\\u0646\\u0648\\u0627\\u0639 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a:<\\/p><p><strong>\\u0623. \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629:<\\/strong><\\/p><ul><li>\\u0627\\u0644\\u0627\\u0633\\u0645<\\/li><li>\\u0639\\u0646\\u0648\\u0627\\u0646 \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a<\\/li><li>\\u0631\\u0642\\u0645 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641<\\/li><li>\\u0627\\u0644\\u0639\\u0646\\u0648\\u0627\\u0646<\\/li><li>\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 (\\u0645\\u062b\\u0644 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646\\/\\u0627\\u0644\\u062e\\u0635\\u0645\\u060c \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a)<\\/li><\\/ul><p><strong>\\u0628. \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062d\\u0633\\u0627\\u0628:<\\/strong><\\/p><ul><li>\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0648\\u0643\\u0644\\u0645\\u0629 \\u0627\\u0644\\u0645\\u0631\\u0648\\u0631 \\u0644\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628\\u0643.<\\/li><\\/ul><p><strong>\\u062c. \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0623\\u0639\\u0645\\u0627\\u0644 (\\u0644\\u0644\\u0645\\u0648\\u0631\\u062f\\u064a\\u0646):<\\/strong><\\/p><ul><li>\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0639\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0645\\u0648\\u0642\\u0639\\u060c \\u0627\\u0644\\u0635\\u0648\\u0631\\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0642\\u062f\\u0645\\u0629\\u060c \\u0648\\u0627\\u0644\\u0623\\u0633\\u0639\\u0627\\u0631.<\\/li><li>\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062d\\u0633\\u0627\\u0628 \\u0627\\u0644\\u0645\\u0635\\u0631\\u0641\\u064a \\u0644\\u0623\\u063a\\u0631\\u0627\\u0636 \\u0627\\u0644\\u062f\\u0641\\u0639.<\\/li><\\/ul><p><strong>\\u062f. \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645:<\\/strong><\\/p><ul><li>\\u062a\\u0641\\u0627\\u0639\\u0644\\u0627\\u062a\\u0643 \\u0645\\u0639 \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627 (\\u0645\\u062b\\u0644 \\u0627\\u0644\\u0635\\u0641\\u062d\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645\\u062a \\u0632\\u064a\\u0627\\u0631\\u062a\\u0647\\u0627\\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645 \\u0639\\u0631\\u0636\\u0647\\u0627).<\\/li><li>\\u0639\\u0646\\u0648\\u0627\\u0646 IP\\u060c \\u0646\\u0648\\u0639 \\u0627\\u0644\\u0645\\u062a\\u0635\\u0641\\u062d\\u060c \\u0646\\u0638\\u0627\\u0645 \\u0627\\u0644\\u062a\\u0634\\u063a\\u064a\\u0644\\u060c \\u0648\\u0646\\u0648\\u0639 \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632.<\\/li><\\/ul><p><strong>\\u0647\\u0640. \\u0645\\u0644\\u0641\\u0627\\u062a \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0627\\u0644\\u0627\\u0631\\u062a\\u0628\\u0627\\u0637 \\u0648\\u062a\\u0642\\u0646\\u064a\\u0627\\u062a \\u0627\\u0644\\u062a\\u062a\\u0628\\u0639:<\\/strong><\\/p><ul><li>\\u0645\\u0644\\u0641\\u0627\\u062a \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0627\\u0644\\u0627\\u0631\\u062a\\u0628\\u0627\\u0637 \\u0644\\u062a\\u062d\\u0633\\u064a\\u0646 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0648\\u062c\\u0645\\u0639 \\u0627\\u0644\\u062a\\u062d\\u0644\\u064a\\u0644\\u0627\\u062a.<\\/li><li>\\u0625\\u0634\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0648\\u064a\\u0628 \\u0648\\u062a\\u0642\\u0646\\u064a\\u0627\\u062a \\u0627\\u0644\\u062a\\u062a\\u0628\\u0639 \\u0644\\u062a\\u062d\\u0633\\u064a\\u0646 \\u062e\\u062f\\u0645\\u0627\\u062a\\u0646\\u0627.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>2. \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643<\\/h4><p>\\u0646\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0646\\u062c\\u0645\\u0639\\u0647\\u0627 \\u0644\\u0644\\u0623\\u063a\\u0631\\u0627\\u0636 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629:<\\/p><p><strong>\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u062d\\u0633\\u0627\\u0628:<\\/strong><\\/p><ul><li>\\u0644\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0648\\u0625\\u062f\\u0627\\u0631\\u0629 \\u062d\\u0633\\u0627\\u0628\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0648\\u0631\\u062f\\u064a\\u0646.<\\/li><\\/ul><p><strong>\\u062a\\u0646\\u0641\\u064a\\u0630 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a:<\\/strong><\\/p><ul><li>\\u0644\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u062d\\u062c\\u0648\\u0632\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0648\\u0637\\u0644\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a.<\\/li><\\/ul><p><strong>\\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644:<\\/strong><\\/p><ul><li>\\u0644\\u0625\\u0631\\u0633\\u0627\\u0644 \\u0631\\u0633\\u0627\\u0626\\u0644 \\u062a\\u0623\\u0643\\u064a\\u062f\\u060c \\u0641\\u0648\\u0627\\u062a\\u064a\\u0631\\u060c \\u062a\\u062d\\u062f\\u064a\\u062b\\u0627\\u062a\\u060c \\u0648\\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u062a \\u062a\\u0633\\u0648\\u064a\\u0642\\u064a\\u0629 (\\u062d\\u064a\\u062b\\u0645\\u0627 \\u064a\\u0643\\u0648\\u0646 \\u0630\\u0644\\u0643 \\u0645\\u0633\\u0645\\u0648\\u062d\\u064b\\u0627).<\\/li><\\/ul><p><strong>\\u0627\\u0644\\u062a\\u062e\\u0635\\u064a\\u0635:<\\/strong><\\/p><ul><li>\\u0644\\u062a\\u062e\\u0635\\u064a\\u0635 \\u062a\\u062c\\u0631\\u0628\\u062a\\u0643 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u062a\\u0648\\u0635\\u064a\\u0629 \\u0628\\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646\\u0627\\u062a \\u0623\\u0648 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u062a\\u0641\\u0636\\u064a\\u0644\\u0627\\u062a\\u0643.<\\/li><\\/ul><p><strong>\\u0627\\u0644\\u062a\\u062d\\u0644\\u064a\\u0644\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u062d\\u0633\\u064a\\u0646\\u0627\\u062a:<\\/strong><\\/p><ul><li>\\u0644\\u062a\\u062d\\u0644\\u064a\\u0644 \\u0633\\u0644\\u0648\\u0643 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0648\\u062a\\u062d\\u0633\\u064a\\u0646 \\u0648\\u0638\\u0627\\u0626\\u0641 \\u0648\\u0645\\u0632\\u0627\\u064a\\u0627 \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627.<\\/li><\\/ul><p><strong>\\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a:<\\/strong><\\/p><ul><li>\\u0644\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629\\u060c \\u0645\\u062b\\u0644 \\u0645\\u0646\\u0639 \\u0627\\u0644\\u0627\\u062d\\u062a\\u064a\\u0627\\u0644 \\u0648\\u0636\\u0645\\u0627\\u0646 \\u0623\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>3. \\u0643\\u064a\\u0641\\u064a\\u0629 \\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643<\\/h4><p>\\u0644\\u0627 \\u0646\\u0642\\u0648\\u0645 \\u0628\\u0628\\u064a\\u0639 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u0642\\u062f \\u0646\\u0634\\u0627\\u0631\\u0643 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629:<\\/p><p><strong>\\u0623. \\u0645\\u0632\\u0648\\u062f\\u064a \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a:<\\/strong><\\/p><ul><li>\\u0642\\u062f \\u0646\\u0634\\u0627\\u0631\\u0643 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0645\\u0639 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0627\\u0644\\u062b\\u0627\\u0644\\u062b\\u0629 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u064a\\u0633\\u0627\\u0639\\u062f\\u0648\\u0646\\u0646\\u0627 \\u0641\\u064a \\u062a\\u0634\\u063a\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629 \\u0623\\u0648 \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0623\\u0648 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642\\u064a\\u0629.<\\/li><\\/ul><p><strong>\\u0628. \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u0621 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0648\\u0646:<\\/strong><\\/p><ul><li>\\u0645\\u0639 \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646\\u0627\\u062a \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0639\\u0627\\u062a \\u0623\\u0648 \\u0645\\u0642\\u062f\\u0645\\u064a \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0644\\u062a\\u0644\\u0628\\u064a\\u0629 \\u062d\\u062c\\u0648\\u0632\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0623\\u0648 \\u0637\\u0644\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a.<\\/li><\\/ul><p><strong>\\u062c. \\u0627\\u0644\\u0645\\u062a\\u0637\\u0644\\u0628\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629:<\\/strong><\\/p><ul><li>\\u0644\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629\\u060c \\u0645\\u062b\\u0644 \\u0623\\u0648\\u0627\\u0645\\u0631 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062f\\u0639\\u0627\\u0621\\u0627\\u062a \\u0623\\u0648 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0641\\u0633\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u064a\\u0629.<\\/li><\\/ul><p><strong>\\u062f. \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629:<\\/strong><\\/p><ul><li>\\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0646\\u062f\\u0645\\u0627\\u062c \\u0623\\u0648 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062d\\u0648\\u0627\\u0630 \\u0623\\u0648 \\u0628\\u064a\\u0639 \\u0645\\u0646\\u0635\\u0629 SalonHub\\u060c \\u0642\\u062f \\u064a\\u062a\\u0645 \\u0646\\u0642\\u0644 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0643\\u064a\\u0627\\u0646 \\u0627\\u0644\\u062c\\u062f\\u064a\\u062f.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>4. \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0623\\u0645\\u0627\\u0646<\\/h4><p>\\u0646\\u0637\\u0628\\u0642 \\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0623\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0635\\u0646\\u0627\\u0639\\u0629 \\u0644\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643:<\\/p><ul><li>\\u062a\\u0634\\u0641\\u064a\\u0631 SSL \\u0644\\u0646\\u0642\\u0644 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a.<\\/li><li>\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u062a\\u062f\\u0642\\u064a\\u0642 \\u0623\\u0645\\u0627\\u0646 \\u0645\\u0646\\u062a\\u0638\\u0645\\u0629 \\u0648\\u062a\\u0642\\u064a\\u064a\\u0645 \\u0627\\u0644\\u062b\\u063a\\u0631\\u0627\\u062a.<\\/li><li>\\u0636\\u0648\\u0627\\u0628\\u0637 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0646\\u062f\\u0629 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u0631 \\u0644\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u062d\\u0633\\u0627\\u0633\\u0629.<\\/li><\\/ul><p><strong>\\u064a\\u0631\\u062c\\u0649 \\u0627\\u0644\\u0645\\u0644\\u0627\\u062d\\u0638\\u0629:<\\/strong> \\u0628\\u0627\\u0644\\u0631\\u063a\\u0645 \\u0645\\u0646 \\u0627\\u062a\\u062e\\u0627\\u0630\\u0646\\u0627 \\u062a\\u062f\\u0627\\u0628\\u064a\\u0631 \\u0645\\u0639\\u0642\\u0648\\u0644\\u0629 \\u0644\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643\\u060c \\u0644\\u0627 \\u062a\\u0648\\u062c\\u062f \\u0637\\u0631\\u064a\\u0642\\u0629 \\u062a\\u062e\\u0632\\u064a\\u0646 \\u0623\\u0648 \\u0646\\u0642\\u0644 \\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a\\u0629 \\u0622\\u0645\\u0646\\u0629 \\u0628\\u0646\\u0633\\u0628\\u0629 100%\\u060c \\u0648\\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646\\u0646\\u0627 \\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0645\\u0637\\u0644\\u0642.<\\/p><p>&nbsp;<\\/p><h4>5. \\u062d\\u0642\\u0648\\u0642\\u0643 \\u0648\\u0627\\u062e\\u062a\\u064a\\u0627\\u0631\\u0627\\u062a\\u0643<\\/h4><p><strong>\\u0623. \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0648\\u062a\\u062d\\u062f\\u064a\\u062b \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643:<\\/strong><\\/p><ul><li>\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0648\\u062a\\u062d\\u062f\\u064a\\u062b \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u062d\\u0633\\u0627\\u0628 SalonHub \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0628\\u0643.<\\/li><\\/ul><p><strong>\\u0628. \\u0625\\u0644\\u063a\\u0627\\u0621 \\u0627\\u0644\\u0627\\u0634\\u062a\\u0631\\u0627\\u0643 \\u0645\\u0646 \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u0633\\u0648\\u064a\\u0642\\u064a\\u0629:<\\/strong><\\/p><ul><li>\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0625\\u0644\\u063a\\u0627\\u0621 \\u0627\\u0644\\u0627\\u0634\\u062a\\u0631\\u0627\\u0643 \\u0645\\u0646 \\u0631\\u0633\\u0627\\u0626\\u0644 \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629 \\u0628\\u0627\\u0644\\u0646\\u0642\\u0631 \\u0639\\u0644\\u0649 \\u0631\\u0627\\u0628\\u0637 \\"\\u0625\\u0644\\u063a\\u0627\\u0621 \\u0627\\u0644\\u0627\\u0634\\u062a\\u0631\\u0627\\u0643\\" \\u0641\\u064a \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a.<\\/li><\\/ul><p><strong>\\u062c. \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0645\\u0644\\u0641\\u0627\\u062a \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0627\\u0644\\u0627\\u0631\\u062a\\u0628\\u0627\\u0637:<\\/strong><\\/p><ul><li>\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0636\\u0628\\u0637 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u0645\\u062a\\u0635\\u0641\\u062d\\u0643 \\u0644\\u0631\\u0641\\u0636 \\u0645\\u0644\\u0641\\u0627\\u062a \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0627\\u0644\\u0627\\u0631\\u062a\\u0628\\u0627\\u0637 \\u0623\\u0648 \\u062a\\u0646\\u0628\\u064a\\u0647\\u0643 \\u0639\\u0646\\u062f \\u0625\\u0631\\u0633\\u0627\\u0644\\u0647\\u0627.<\\/li><\\/ul><p><strong>\\u062f. \\u062d\\u0630\\u0641 \\u062d\\u0633\\u0627\\u0628\\u0643:<\\/strong><\\/p><ul><li>\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0637\\u0644\\u0628 \\u062d\\u0630\\u0641 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0648\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644 \\u0628\\u0646\\u0627 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a [support@example.com].<\\/li><\\/ul><p>&nbsp;<\\/p><h4>6. \\u0627\\u0644\\u0631\\u0648\\u0627\\u0628\\u0637 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0627\\u0644\\u062b\\u0627\\u0644\\u062b\\u0629<\\/h4><p>\\u0642\\u062f \\u062a\\u062d\\u062a\\u0648\\u064a \\u0645\\u0646\\u0635\\u0629 SalonHub \\u0639\\u0644\\u0649 \\u0631\\u0648\\u0627\\u0628\\u0637 \\u0625\\u0644\\u0649 \\u0645\\u0648\\u0627\\u0642\\u0639 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0623\\u0637\\u0631\\u0627\\u0641 \\u062b\\u0627\\u0644\\u062b\\u0629. \\u0646\\u062d\\u0646 \\u063a\\u064a\\u0631 \\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0646 \\u0639\\u0646 \\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0644\\u0647\\u0630\\u0647 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0648\\u0646\\u0634\\u062c\\u0639\\u0643 \\u0639\\u0644\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0633\\u064a\\u0627\\u0633\\u0627\\u062a \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0647\\u0645 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0645\\u0639\\u0647\\u0645.<\\/p><p>&nbsp;<\\/p><h4>7. \\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644<\\/h4><p>SalonHub \\u063a\\u064a\\u0631 \\u0645\\u062e\\u0635\\u0635 \\u0644\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0627\\u0644\\u0630\\u064a\\u0646 \\u062a\\u0642\\u0644 \\u0623\\u0639\\u0645\\u0627\\u0631\\u0647\\u0645 \\u0639\\u0646 18 \\u0639\\u0627\\u0645\\u064b\\u0627. \\u0646\\u062d\\u0646 \\u0644\\u0627 \\u0646\\u062c\\u0645\\u0639 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0634\\u062e\\u0635\\u064a\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644 \\u0639\\u0646 \\u0639\\u0644\\u0645. \\u0625\\u0630\\u0627 \\u0639\\u0644\\u0645\\u0646\\u0627 \\u0628\\u0648\\u062c\\u0648\\u062f \\u0645\\u062b\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u060c \\u0641\\u0633\\u064a\\u062a\\u0645 \\u062d\\u0630\\u0641\\u0647\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0648\\u0631.<\\/p><p>&nbsp;<\\/p><h4>8. \\u0646\\u0642\\u0644 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629<\\/h4><p>\\u0625\\u0630\\u0627 \\u0643\\u0646\\u062a \\u062a\\u0635\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u0646\\u0635\\u0629 SalonHub \\u0645\\u0646 \\u062e\\u0627\\u0631\\u062c [\\u0623\\u062f\\u062e\\u0644 \\u0627\\u0633\\u0645 \\u0627\\u0644\\u062f\\u0648\\u0644\\u0629]\\u060c \\u064a\\u064f\\u0631\\u062c\\u0649 \\u0645\\u0644\\u0627\\u062d\\u0638\\u0629 \\u0623\\u0646\\u0647 \\u0642\\u062f \\u064a\\u062a\\u0645 \\u0646\\u0642\\u0644 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643 \\u0625\\u0644\\u0649 \\u062f\\u0648\\u0644\\u0629 \\u0642\\u062f \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0641\\u064a\\u0647\\u0627. \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 SalonHub\\u060c \\u0641\\u0625\\u0646\\u0643 \\u062a\\u0648\\u0627\\u0641\\u0642 \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u0646\\u0642\\u0644.<\\/p><p>&nbsp;<\\/p><h4>9. \\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629<\\/h4><p>\\u0642\\u062f \\u0646\\u0642\\u0648\\u0645 \\u0628\\u062a\\u062d\\u062f\\u064a\\u062b \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0647\\u0630\\u0647 \\u0628\\u0634\\u0643\\u0644 \\u062f\\u0648\\u0631\\u064a \\u0644\\u062a\\u0639\\u0643\\u0633 \\u0627\\u0644\\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0641\\u064a \\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a\\u0646\\u0627 \\u0623\\u0648 \\u0644\\u0623\\u0633\\u0628\\u0627\\u0628 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629. \\u064a\\u0634\\u064a\\u0631 \\"\\u062a\\u0627\\u0631\\u064a\\u062e \\u0627\\u0644\\u0633\\u0631\\u064a\\u0627\\u0646\\" \\u0641\\u064a \\u0627\\u0644\\u0623\\u0639\\u0644\\u0649 \\u0625\\u0644\\u0649 \\u0623\\u062d\\u062f\\u062b \\u062a\\u062d\\u062f\\u064a\\u062b. \\u0646\\u0634\\u062c\\u0639\\u0643 \\u0639\\u0644\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0635\\u0641\\u062d\\u0629 \\u0628\\u0627\\u0646\\u062a\\u0638\\u0627\\u0645 \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u062d\\u062f\\u064a\\u062b\\u0627\\u062a.<\\/p><p>&nbsp;<\\/p><h4>10. \\u0627\\u062a\\u0635\\u0644 \\u0628\\u0646\\u0627<\\/h4><p>\\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0643 \\u0623\\u064a \\u0623\\u0633\\u0626\\u0644\\u0629 \\u0623\\u0648 \\u0645\\u062e\\u0627\\u0648\\u0641 \\u0628\\u0634\\u0623\\u0646 \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0647\\u0630\\u0647\\u060c \\u0623\\u0648 \\u0625\\u0630\\u0627 \\u0643\\u0646\\u062a \\u062a\\u0631\\u063a\\u0628 \\u0641\\u064a \\u0645\\u0645\\u0627\\u0631\\u0633\\u0629 \\u062d\\u0642\\u0648\\u0642\\u0643\\u060c \\u064a\\u064f\\u0631\\u062c\\u0649 \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644 \\u0628\\u0646\\u0627:<\\/p><ul><li>\\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a: support@example.com<\\/li><li>\\u0627\\u0644\\u0647\\u0627\\u062a\\u0641: +03601 885399<\\/li><li>\\u0627\\u0644\\u0639\\u0646\\u0648\\u0627\\u0646: 20-22 Wenlock Road\\u060c \\u0625\\u0646\\u062c\\u0644\\u062a\\u0631\\u0627\\u060c N1 7GU<\\/li><\\/ul><p>&nbsp;<\\/p><p>\\u0647\\u0644 \\u062a\\u0631\\u064a\\u062f \\u0623\\u064a \\u062a\\u0639\\u062f\\u064a\\u0644\\u0627\\u062a \\u0623\\u0648 \\u0625\\u0636\\u0627\\u0641\\u0627\\u062a\\u061f<\\/p>"}}}','status' => '1','editable' => '0','created_at' => '2023-07-31 12:02:44','updated_at' => '2025-01-07 09:54:14'),
            array('id' => '2','type' => 'UNKNOWN','title' => '{"language":{"en":{"title":"Refund Policy"},"fr":{"title":"Politique de remboursement"},"es":{"title":"Politica de reembolso"},"ar":{"title":"\\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644"}}}','slug' => 'refund-policy','url' => 'refund-policy','content' => '{"language":{"en":{"content":"<p style=\\"margin-left:-16px;\\">At SalonHub, we aim to provide the best possible experience for our customers and vendors. However, we understand that there may be circumstances requiring a refund. This Refund Policy outlines the terms and conditions under which refunds are issued and the process to request them. By using our services, you agree to abide by this policy.<strong>1. Eligibility for Refunds<\\/strong><br><strong>a. Services Not Delivered<\\/strong><br>If the booked salon or spa service was not delivered due to a failure by the vendor, you may be eligible for a full refund.<br><strong>b. Cancellation Policies<\\/strong><br>&nbsp;<\\/p><ul><li><strong>Customer-Initiated Cancellations:<\\/strong><ul style=\\"list-style-type:none;\\"><li>Refunds depend on the salon\'s or vendor\\u2019s specific cancellation policy, as outlined during booking.<\\/li><li>Bookings canceled within the permitted timeframe (e.g., 24 hours prior) may qualify for a full or partial refund.<\\/li><li>Cancellations made after the permitted window may not be eligible for refunds.<\\/li><\\/ul><\\/li><li><strong>Vendor-Initiated Cancellations:<\\/strong><ul style=\\"list-style-type:none;\\"><li>If the vendor cancels your appointment, you will receive a full refund.<\\/li><\\/ul><\\/li><\\/ul><p style=\\"margin-left:-16px;\\"><strong>c. Unsatisfactory Services<\\/strong><br>If the delivered service does not meet the described standards or agreement, you may request a partial refund, subject to investigation and approval.<br><strong>d. Technical Issues<\\/strong><br>If payment is processed incorrectly due to a technical error on our platform, refunds will be issued after verification of the issue.<strong>2. Non-Refundable Items<\\/strong><br>Refunds are not available for:<br>&nbsp;<\\/p><ul style=\\"list-style-type:none;\\"><li>Missed appointments due to the customer\'s failure to attend.<\\/li><li>Gift cards, promotional offers, or discounts once they are redeemed or expired.<\\/li><li>Any issues not reported within 48 hours of the service date.<\\/li><\\/ul><p style=\\"margin-left:-16px;\\"><strong>3. Refund Process<\\/strong><br>To request a refund, follow these steps:<br><strong>Step 1: Submit a Refund Request<\\/strong><br>Contact us at <strong>[<\\/strong><a href=\\"mailto:support@example.com\\"><strong>support@example.com<\\/strong><\\/a><strong>]<\\/strong> or via the help section on the platform. Provide the following details:<br>&nbsp;<\\/p><ul style=\\"list-style-type:none;\\"><li>Booking reference number.<\\/li><li>Reason for refund request (e.g., cancellation, unsatisfactory service).<\\/li><li>Any supporting evidence (e.g., photos, screenshots, proof of payment).<\\/li><\\/ul><p style=\\"margin-left:-16px;\\"><strong>Step 2: Review and Verification<\\/strong><br>Our team will review your request and may contact the vendor for clarification. In some cases, we may require additional details to process your request.<br><strong>Step 3: Refund Approval<\\/strong><br>&nbsp;<\\/p><ul style=\\"list-style-type:none;\\"><li>If your refund is approved, the amount will be processed to your original payment method within <strong>7-10 business days<\\/strong>.<\\/li><li>You will receive an email notification confirming the refund status.<\\/li><\\/ul><p style=\\"margin-left:-16px;\\"><strong>4. Vendor-Specific Refund Policies<\\/strong><br>Certain vendors may have their own refund or cancellation policies. These will be clearly outlined during the booking process. SalonHub ensures that vendor-specific policies are communicated transparently and will mediate if disputes arise.<strong>5. Payment Method for Refunds<\\/strong><br>Refunds will be credited back to the original payment method used during the booking. If that method is no longer valid, contact us for alternative arrangements.<strong>6. Disputes and Resolutions<\\/strong><br>If you are dissatisfied with the outcome of a refund request, you may escalate your complaint to <strong>[<\\/strong><a href=\\"mailto:dispute@example.com\\"><strong>dispute@example.com<\\/strong><\\/a><strong>]<\\/strong> for further review. Our customer service team will mediate to ensure a fair resolution for all parties involved.<strong>7. Changes to This Refund Policy<\\/strong><br>We may update this Refund Policy periodically to reflect changes in our procedures or services. The \\u201cEffective Date\\u201d at the top indicates the most recent update.<strong>8. Contact Us<\\/strong><br>If you have any questions or need assistance with a refund, please contact us at:<br>&nbsp;<\\/p><ul style=\\"list-style-type:none;\\"><li><strong>Email:<\\/strong> <a href=\\"mailto:support@example.com\\">support@example.com<\\/a><\\/li><li><strong>Phone:<\\/strong> +03601 885399<\\/li><li><strong>Address:<\\/strong> 20-22 Wenlock Road, England, N1 7GU<\\/li><\\/ul><p style=\\"margin-left:8px;\\"><img class=\\"image_resized\\" style=\\"width:16px;\\" src=\\"https:\\/\\/a.slack-edge.com\\/production-standard-emoji-assets\\/14.0\\/google-small\\/2705.png\\" alt=\\"white_check_mark\\"><img class=\\"image_resized\\" style=\\"width:16px;\\" src=\\"https:\\/\\/a.slack-edge.com\\/production-standard-emoji-assets\\/14.0\\/google-small\\/1f440.png\\" alt=\\"eyes\\"><img class=\\"image_resized\\" style=\\"width:16px;\\" src=\\"https:\\/\\/a.slack-edge.com\\/production-standard-emoji-assets\\/14.0\\/google-small\\/1f64c.png\\" alt=\\"raised_hands\\"><br>&nbsp;<\\/p>"},"fr":{"content":"<h3>Politique de Remboursement<\\/h3><p>Chez SalonHub, nous nous effor\\u00e7ons d\\u2019offrir la meilleure exp\\u00e9rience possible \\u00e0 nos clients et fournisseurs. Cependant, nous comprenons qu\\u2019il peut y avoir des circonstances n\\u00e9cessitant un remboursement. Cette Politique de Remboursement d\\u00e9crit les termes et conditions applicables aux remboursements et le processus pour en faire la demande. En utilisant nos services, vous acceptez de respecter cette politique.<\\/p><h4>1. \\u00c9ligibilit\\u00e9 aux Remboursements<\\/h4><p><strong>a. Services Non Fournis<\\/strong><br>Si le service de salon ou de spa r\\u00e9serv\\u00e9 n\\u2019a pas \\u00e9t\\u00e9 fourni en raison d\\u2019une d\\u00e9faillance du fournisseur, vous pouvez \\u00eatre \\u00e9ligible \\u00e0 un remboursement complet.<\\/p><p><strong>b. Politiques d\\u2019Annulation<\\/strong><br><strong>Annulations Initi\\u00e9es par le Client :<\\/strong><\\/p><ul><li>Les remboursements d\\u00e9pendent de la politique d\'annulation sp\\u00e9cifique du salon ou du fournisseur, telle qu\\u2019indiqu\\u00e9e lors de la r\\u00e9servation.<\\/li><li>Les r\\u00e9servations annul\\u00e9es dans le d\\u00e9lai permis (par exemple, 24 heures avant) peuvent \\u00eatre \\u00e9ligibles \\u00e0 un remboursement complet ou partiel.<\\/li><li>Les annulations effectu\\u00e9es en dehors de ce d\\u00e9lai peuvent ne pas \\u00eatre \\u00e9ligibles \\u00e0 un remboursement.<\\/li><\\/ul><p><strong>Annulations Initi\\u00e9es par le Fournisseur :<\\/strong><\\/p><ul><li>Si le fournisseur annule votre rendez-vous, vous recevrez un remboursement complet.<\\/li><\\/ul><p><strong>c. Services Insatisfaisants<\\/strong><\\/p><ul><li>Si le service fourni ne respecte pas les normes ou l\\u2019accord d\\u00e9crits, vous pouvez demander un remboursement partiel, sous r\\u00e9serve d\\u2019une enqu\\u00eate et d\\u2019une approbation.<\\/li><\\/ul><p><strong>d. Probl\\u00e8mes Techniques<\\/strong><\\/p><ul><li>Si un paiement a \\u00e9t\\u00e9 trait\\u00e9 incorrectement en raison d\\u2019une erreur technique sur notre plateforme, un remboursement sera \\u00e9mis apr\\u00e8s v\\u00e9rification du probl\\u00e8me.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>2. Articles Non Remboursables<\\/h4><p>Les remboursements ne sont pas disponibles pour :<\\/p><ul><li>Les rendez-vous manqu\\u00e9s en raison de l\'absence du client.<\\/li><li>Les cartes-cadeaux, offres promotionnelles ou remises, une fois qu\\u2019elles ont \\u00e9t\\u00e9 utilis\\u00e9es ou expir\\u00e9es.<\\/li><li>Tout probl\\u00e8me non signal\\u00e9 dans les 48 heures suivant la date du service.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>3. Processus de Remboursement<\\/h4><p>Pour demander un remboursement, suivez ces \\u00e9tapes :<\\/p><p><strong>\\u00c9tape 1 : Soumettre une Demande de Remboursement<\\/strong><\\/p><ul><li>Contactez-nous \\u00e0 [support@example.com] ou via la section d\\u2019aide de la plateforme. Fournissez les d\\u00e9tails suivants :<ul><li>Num\\u00e9ro de r\\u00e9f\\u00e9rence de la r\\u00e9servation.<\\/li><li>Motif de la demande de remboursement (par exemple, annulation, service insatisfaisant).<\\/li><li>Toute preuve \\u00e0 l\\u2019appui (photos, captures d\\u2019\\u00e9cran, preuve de paiement).<\\/li><\\/ul><\\/li><\\/ul><p><strong>\\u00c9tape 2 : Revue et V\\u00e9rification<\\/strong><\\/p><ul><li>Notre \\u00e9quipe examinera votre demande et pourra contacter le fournisseur pour des clarifications. Dans certains cas, nous pourrons vous demander des d\\u00e9tails suppl\\u00e9mentaires pour traiter votre demande.<\\/li><\\/ul><p><strong>\\u00c9tape 3 : Approbation du Remboursement<\\/strong><\\/p><ul><li>Si votre remboursement est approuv\\u00e9, le montant sera trait\\u00e9 sur votre mode de paiement initial dans un d\\u00e9lai de 7 \\u00e0 10 jours ouvrables.<\\/li><li>Vous recevrez une notification par e-mail confirmant l\\u2019\\u00e9tat du remboursement.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>4. Politiques de Remboursement des Fournisseurs<\\/h4><p>Certains fournisseurs peuvent avoir leurs propres politiques de remboursement ou d\'annulation. Ces politiques seront clairement indiqu\\u00e9es lors du processus de r\\u00e9servation. SalonHub veille \\u00e0 ce que les politiques sp\\u00e9cifiques des fournisseurs soient communiqu\\u00e9es de mani\\u00e8re transparente et agira comme m\\u00e9diateur en cas de litige.<\\/p><p>&nbsp;<\\/p><h4>5. M\\u00e9thode de Paiement pour les Remboursements<\\/h4><ul><li>Les remboursements seront cr\\u00e9dit\\u00e9s sur le mode de paiement initial utilis\\u00e9 lors de la r\\u00e9servation.<\\/li><li>Si ce mode n\\u2019est plus valide, contactez-nous pour organiser une solution alternative.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>6. Litiges et R\\u00e9solutions<\\/h4><ul><li>Si vous n\\u2019\\u00eates pas satisfait du r\\u00e9sultat d\\u2019une demande de remboursement, vous pouvez escalader votre r\\u00e9clamation \\u00e0 [dispute@example.com] pour un examen suppl\\u00e9mentaire.<\\/li><li>Notre \\u00e9quipe de service client agira comme m\\u00e9diateur pour garantir une r\\u00e9solution \\u00e9quitable pour toutes les parties concern\\u00e9es.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>7. Modifications de cette Politique de Remboursement<\\/h4><p>Nous pouvons mettre \\u00e0 jour cette Politique de Remboursement p\\u00e9riodiquement pour refl\\u00e9ter les changements dans nos proc\\u00e9dures ou services. La \\"Date d\\u2019Effet\\" indiqu\\u00e9e en haut refl\\u00e8te la derni\\u00e8re mise \\u00e0 jour.<\\/p><p>&nbsp;<\\/p><h4>8. Contactez-Nous<\\/h4><p>Si vous avez des questions ou besoin d\\u2019assistance pour un remboursement, contactez-nous :<\\/p><ul><li>Email : support@example.com<\\/li><li>T\\u00e9l\\u00e9phone : +03601 885399<\\/li><li>Adresse : 20-22 Wenlock Road, Angleterre, N1 7GU<\\/li><\\/ul><p>&nbsp;<\\/p><p>Souhaitez-vous ajouter ou modifier quelque chose ? \\ud83d\\ude0a<\\/p><p>&nbsp;<\\/p><p>&nbsp;<\\/p>"},"es":{"content":"<h3>Pol\\u00edtica de Reembolsos<\\/h3><p>En SalonHub, nos esforzamos por brindar la mejor experiencia posible a nuestros clientes y proveedores. Sin embargo, entendemos que pueden surgir circunstancias que requieran un reembolso. Esta Pol\\u00edtica de Reembolsos detalla los t\\u00e9rminos y condiciones bajo los cuales se emiten reembolsos y el proceso para solicitarlos. Al utilizar nuestros servicios, aceptas cumplir con esta pol\\u00edtica.<\\/p><h4>1. Elegibilidad para Reembolsos<\\/h4><p><strong>a. Servicios No Prestados<\\/strong><br>Si el servicio reservado en el sal\\u00f3n o spa no se prest\\u00f3 debido a un fallo del proveedor, podr\\u00edas ser elegible para un reembolso completo.<\\/p><p><strong>b. Pol\\u00edticas de Cancelaci\\u00f3n<\\/strong><br><strong>Cancelaciones Iniciadas por el Cliente:<\\/strong><\\/p><ul><li>Los reembolsos dependen de la pol\\u00edtica de cancelaci\\u00f3n espec\\u00edfica del sal\\u00f3n o proveedor, seg\\u00fan se detalla durante la reserva.<\\/li><li>Las reservas canceladas dentro del per\\u00edodo permitido (por ejemplo, 24 horas antes) podr\\u00edan calificar para un reembolso completo o parcial.<\\/li><li>Las cancelaciones realizadas fuera del per\\u00edodo permitido podr\\u00edan no ser elegibles para reembolsos.<\\/li><\\/ul><p><strong>Cancelaciones Iniciadas por el Proveedor:<\\/strong><\\/p><ul><li>Si el proveedor cancela tu cita, recibir\\u00e1s un reembolso completo.<\\/li><\\/ul><p><strong>c. Servicios Insatisfactorios<\\/strong><\\/p><ul><li>Si el servicio prestado no cumple con los est\\u00e1ndares descritos o con el acuerdo, puedes solicitar un reembolso parcial, sujeto a investigaci\\u00f3n y aprobaci\\u00f3n.<\\/li><\\/ul><p><strong>d. Problemas T\\u00e9cnicos<\\/strong><\\/p><ul><li>Si el pago se proces\\u00f3 incorrectamente debido a un error t\\u00e9cnico en nuestra plataforma, se emitir\\u00e1 un reembolso tras verificar el problema.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>2. Art\\u00edculos No Reembolsables<\\/h4><p>No se emitir\\u00e1n reembolsos en los siguientes casos:<\\/p><ul><li>Citas perdidas debido a que el cliente no asisti\\u00f3.<\\/li><li>Tarjetas de regalo, ofertas promocionales o descuentos, una vez que hayan sido redimidos o hayan caducado.<\\/li><li>Cualquier problema que no se informe dentro de las 48 horas posteriores a la fecha del servicio.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>3. Proceso de Reembolso<\\/h4><p>Para solicitar un reembolso, sigue estos pasos:<\\/p><p><strong>Paso 1: Enviar una Solicitud de Reembolso<\\/strong><\\/p><ul><li>Cont\\u00e1ctanos en [support@example.com] o a trav\\u00e9s de la secci\\u00f3n de ayuda en la plataforma. Proporciona los siguientes detalles:<ul><li>N\\u00famero de referencia de la reserva.<\\/li><li>Raz\\u00f3n de la solicitud de reembolso (por ejemplo, cancelaci\\u00f3n, servicio insatisfactorio).<\\/li><li>Cualquier evidencia de respaldo (por ejemplo, fotos, capturas de pantalla, comprobante de pago).<\\/li><\\/ul><\\/li><\\/ul><p><strong>Paso 2: Revisi\\u00f3n y Verificaci\\u00f3n<\\/strong><\\/p><ul><li>Nuestro equipo revisar\\u00e1 tu solicitud y podr\\u00e1 contactar al proveedor para obtener aclaraciones. En algunos casos, podr\\u00edamos requerir detalles adicionales para procesar tu solicitud.<\\/li><\\/ul><p><strong>Paso 3: Aprobaci\\u00f3n del Reembolso<\\/strong><\\/p><ul><li>Si tu reembolso es aprobado, el monto ser\\u00e1 procesado a tu m\\u00e9todo de pago original dentro de 7-10 d\\u00edas h\\u00e1biles.<\\/li><li>Recibir\\u00e1s una notificaci\\u00f3n por correo electr\\u00f3nico confirmando el estado del reembolso.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>4. Pol\\u00edticas de Reembolso de Proveedores<\\/h4><p>Algunos proveedores pueden tener sus propias pol\\u00edticas de reembolso o cancelaci\\u00f3n. Estas pol\\u00edticas se detallar\\u00e1n claramente durante el proceso de reserva. SalonHub garantiza que las pol\\u00edticas espec\\u00edficas de los proveedores se comuniquen de manera transparente y actuar\\u00e1 como mediador en caso de disputas.<\\/p><p>&nbsp;<\\/p><h4>5. M\\u00e9todo de Pago para Reembolsos<\\/h4><ul><li>Los reembolsos se acreditar\\u00e1n al m\\u00e9todo de pago original utilizado durante la reserva.<\\/li><li>Si ese m\\u00e9todo ya no es v\\u00e1lido, comun\\u00edcate con nosotros para coordinar alternativas.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>6. Disputas y Resoluciones<\\/h4><ul><li>Si no est\\u00e1s satisfecho con el resultado de una solicitud de reembolso, puedes escalar tu queja a [dispute@example.com] para una revisi\\u00f3n adicional.<\\/li><li>Nuestro equipo de servicio al cliente actuar\\u00e1 como mediador para garantizar una resoluci\\u00f3n justa para todas las partes involucradas.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>7. Cambios en esta Pol\\u00edtica de Reembolsos<\\/h4><p>Podemos actualizar esta Pol\\u00edtica de Reembolsos peri\\u00f3dicamente para reflejar cambios en nuestros procedimientos o servicios. La \\u201cFecha de Vigencia\\u201d en la parte superior indica la \\u00faltima actualizaci\\u00f3n.<\\/p><p>&nbsp;<\\/p><h4>8. Cont\\u00e1ctanos<\\/h4><p>Si tienes alguna pregunta o necesitas asistencia con un reembolso, cont\\u00e1ctanos:<\\/p><ul><li>Correo electr\\u00f3nico: support@example.com<\\/li><li>Tel\\u00e9fono: +03601 885399<\\/li><li>Direcci\\u00f3n: 20-22 Wenlock Road, Inglaterra, N1 7GU<\\/li><\\/ul><p>&nbsp;<\\/p><p>\\u00bfQuieres agregar algo m\\u00e1s o realizar modificaciones? \\ud83d\\ude0a<\\/p><p>&nbsp;<\\/p>"},"ar":{"content":"<h3>\\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f<\\/h3><p>\\u0641\\u064a SalonHub\\u060c \\u0646\\u0633\\u0639\\u0649 \\u0644\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0623\\u0641\\u0636\\u0644 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0645\\u0645\\u0643\\u0646\\u0629 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627 \\u0648\\u0627\\u0644\\u0645\\u0648\\u0631\\u062f\\u064a\\u0646. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u0646\\u0641\\u0647\\u0645 \\u0623\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u0638\\u0631\\u0648\\u0641\\u064b\\u0627 \\u0642\\u062f \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0627\\u0644\\u0645\\u0628\\u0627\\u0644\\u063a. \\u062a\\u0648\\u0636\\u062d \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0633\\u0629 \\u0634\\u0631\\u0648\\u0637 \\u0648\\u0623\\u062d\\u0643\\u0627\\u0645 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0648\\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0644\\u0627\\u0632\\u0645\\u0629 \\u0644\\u0637\\u0644\\u0628\\u0647\\u0627. \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u062e\\u062f\\u0645\\u0627\\u062a\\u0646\\u0627\\u060c \\u0641\\u0625\\u0646\\u0643 \\u062a\\u0648\\u0627\\u0641\\u0642 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645 \\u0628\\u0647\\u0630\\u0647 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0633\\u0629.<\\/p><p>&nbsp;<\\/p><h4>1. \\u0634\\u0631\\u0648\\u0637 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f<\\/h4><p><strong>\\u0623. \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u063a\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0642\\u062f\\u0645\\u0629<\\/strong><br>\\u0625\\u0630\\u0627 \\u0644\\u0645 \\u064a\\u062a\\u0645 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629 \\u0627\\u0644\\u0645\\u062d\\u062c\\u0648\\u0632\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0639 \\u0627\\u0644\\u0635\\u062d\\u064a \\u0628\\u0633\\u0628\\u0628 \\u0641\\u0634\\u0644 \\u0645\\u0646 \\u0642\\u0650\\u0628\\u064e\\u0644 \\u0627\\u0644\\u0645\\u0648\\u0631\\u062f\\u060c \\u0641\\u0642\\u062f \\u062a\\u0643\\u0648\\u0646 \\u0645\\u0624\\u0647\\u0644\\u0627\\u064b \\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0643\\u0627\\u0645\\u0644 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a.<\\/p><p><strong>\\u0628. \\u0633\\u064a\\u0627\\u0633\\u0627\\u062a \\u0627\\u0644\\u0625\\u0644\\u063a\\u0627\\u0621<\\/strong><br><strong>\\u0627\\u0644\\u0625\\u0644\\u063a\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u064a\\u0642\\u0648\\u0645 \\u0628\\u0647\\u0627 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644:<\\/strong><\\/p><ul><li>\\u062a\\u0639\\u062a\\u0645\\u062f \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f\\u0627\\u062a \\u0627\\u0644\\u0645\\u0628\\u0627\\u0644\\u063a \\u0639\\u0644\\u0649 \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u0625\\u0644\\u063a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u062d\\u062f\\u062f\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0648\\u0631\\u062f\\u060c \\u0643\\u0645\\u0627 \\u0647\\u0648 \\u0645\\u0648\\u0636\\u062d \\u0623\\u062b\\u0646\\u0627\\u0621 \\u0627\\u0644\\u062d\\u062c\\u0632.<\\/li><li>\\u0627\\u0644\\u0625\\u0644\\u063a\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u062a\\u0645 \\u0636\\u0645\\u0646 \\u0627\\u0644\\u0641\\u062a\\u0631\\u0629 \\u0627\\u0644\\u0632\\u0645\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0633\\u0645\\u0648\\u062d \\u0628\\u0647\\u0627 (\\u0645\\u062b\\u0644 24 \\u0633\\u0627\\u0639\\u0629 \\u0645\\u0633\\u0628\\u0642\\u064b\\u0627) \\u0642\\u062f \\u062a\\u0643\\u0648\\u0646 \\u0645\\u0624\\u0647\\u0644\\u0629 \\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0643\\u0627\\u0645\\u0644 \\u0623\\u0648 \\u062c\\u0632\\u0626\\u064a.<\\/li><li>\\u0627\\u0644\\u0625\\u0644\\u063a\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u062a\\u0645 \\u0628\\u0639\\u062f \\u0627\\u0646\\u062a\\u0647\\u0627\\u0621 \\u0627\\u0644\\u0641\\u062a\\u0631\\u0629 \\u0627\\u0644\\u0632\\u0645\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0633\\u0645\\u0648\\u062d \\u0628\\u0647\\u0627 \\u0642\\u062f \\u0644\\u0627 \\u062a\\u0643\\u0648\\u0646 \\u0645\\u0624\\u0647\\u0644\\u0629 \\u0644\\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f.<\\/li><\\/ul><p><strong>\\u0627\\u0644\\u0625\\u0644\\u063a\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u064a\\u0642\\u0648\\u0645 \\u0628\\u0647\\u0627 \\u0627\\u0644\\u0645\\u0648\\u0631\\u062f:<\\/strong><\\/p><ul><li>\\u0625\\u0630\\u0627 \\u0642\\u0627\\u0645 \\u0627\\u0644\\u0645\\u0648\\u0631\\u062f \\u0628\\u0625\\u0644\\u063a\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0648\\u0639\\u062f\\u060c \\u0641\\u0633\\u062a\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0643\\u0627\\u0645\\u0644 \\u0644\\u0644\\u0645\\u0628\\u0644\\u063a.<\\/li><\\/ul><p><strong>\\u062c. \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u063a\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0631\\u0636\\u064a\\u0629<\\/strong><\\/p><ul><li>\\u0625\\u0630\\u0627 \\u0644\\u0645 \\u062a\\u0644\\u0628\\u064a \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629 \\u0627\\u0644\\u0645\\u0642\\u062f\\u0645\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0648\\u0635\\u0648\\u0641\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0629\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0637\\u0644\\u0628 \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u062c\\u0632\\u0626\\u064a\\u060c \\u0634\\u0631\\u064a\\u0637\\u0629 \\u0627\\u0644\\u062a\\u062d\\u0642\\u064a\\u0642 \\u0648\\u0627\\u0644\\u0645\\u0648\\u0627\\u0641\\u0642\\u0629.<\\/li><\\/ul><p><strong>\\u062f. \\u0627\\u0644\\u0645\\u0634\\u0643\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u0642\\u0646\\u064a\\u0629<\\/strong><\\/p><ul><li>\\u0625\\u0630\\u0627 \\u062a\\u0645\\u062a \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0628\\u0634\\u0643\\u0644 \\u063a\\u064a\\u0631 \\u0635\\u062d\\u064a\\u062d \\u0628\\u0633\\u0628\\u0628 \\u062e\\u0637\\u0623 \\u062a\\u0642\\u0646\\u064a \\u0639\\u0644\\u0649 \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627\\u060c \\u0633\\u064a\\u062a\\u0645 \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0628\\u0639\\u062f \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0634\\u0643\\u0644\\u0629.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>2. \\u0627\\u0644\\u0639\\u0646\\u0627\\u0635\\u0631 \\u063a\\u064a\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0628\\u0644\\u0629 \\u0644\\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f<\\/h4><p>\\u0644\\u0646 \\u064a\\u062a\\u0645 \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0627\\u0644\\u0645\\u0628\\u0627\\u0644\\u063a \\u0644\\u0644\\u0623\\u0633\\u0628\\u0627\\u0628 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629:<\\/p><ul><li>\\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0627\\u0644\\u0641\\u0627\\u0626\\u062a\\u0629 \\u0628\\u0633\\u0628\\u0628 \\u0639\\u062f\\u0645 \\u062d\\u0636\\u0648\\u0631 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644.<\\/li><li>\\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0623\\u0648 \\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0645\\u0627\\u062a \\u0628\\u0645\\u062c\\u0631\\u062f \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f\\u0647\\u0627 \\u0623\\u0648 \\u0627\\u0646\\u062a\\u0647\\u0627\\u0621 \\u0635\\u0644\\u0627\\u062d\\u064a\\u062a\\u0647\\u0627.<\\/li><li>\\u0623\\u064a \\u0645\\u0634\\u0643\\u0644\\u0627\\u062a \\u0644\\u0645 \\u064a\\u062a\\u0645 \\u0627\\u0644\\u0625\\u0628\\u0644\\u0627\\u063a \\u0639\\u0646\\u0647\\u0627 \\u0641\\u064a \\u063a\\u0636\\u0648\\u0646 48 \\u0633\\u0627\\u0639\\u0629 \\u0645\\u0646 \\u062a\\u0627\\u0631\\u064a\\u062e \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>3. \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a<\\/h4><p>\\u0644\\u0637\\u0644\\u0628 \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a\\u060c \\u0627\\u062a\\u0628\\u0639 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629:<\\/p><p><strong>\\u0627\\u0644\\u062e\\u0637\\u0648\\u0629 1: \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0637\\u0644\\u0628 \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f<\\/strong><\\/p><ul><li>\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0645\\u0639\\u0646\\u0627 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a [support@example.com] \\u0623\\u0648 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0642\\u0633\\u0645 \\u0627\\u0644\\u0645\\u0633\\u0627\\u0639\\u062f\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629. \\u0642\\u0645 \\u0628\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629:<ul><li>\\u0631\\u0642\\u0645 \\u0627\\u0644\\u062d\\u062c\\u0632.<\\/li><li>\\u0633\\u0628\\u0628 \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f (\\u0645\\u062b\\u0644 \\u0627\\u0644\\u0625\\u0644\\u063a\\u0627\\u0621\\u060c \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629 \\u063a\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0631\\u0636\\u064a\\u0629).<\\/li><li>\\u0623\\u064a \\u0623\\u062f\\u0644\\u0629 \\u062f\\u0627\\u0639\\u0645\\u0629 (\\u0645\\u062b\\u0644 \\u0627\\u0644\\u0635\\u0648\\u0631\\u060c \\u0644\\u0642\\u0637\\u0627\\u062a \\u0627\\u0644\\u0634\\u0627\\u0634\\u0629\\u060c \\u0625\\u062b\\u0628\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639).<\\/li><\\/ul><\\/li><\\/ul><p><strong>\\u0627\\u0644\\u062e\\u0637\\u0648\\u0629 2: \\u0627\\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0648\\u0627\\u0644\\u062a\\u062d\\u0642\\u0642<\\/strong><\\/p><ul><li>\\u0633\\u064a\\u0642\\u0648\\u0645 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627 \\u0628\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0637\\u0644\\u0628\\u0643 \\u0648\\u0642\\u062f \\u064a\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0645\\u0639 \\u0627\\u0644\\u0645\\u0648\\u0631\\u062f \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u062a\\u0648\\u0636\\u064a\\u062d. \\u0641\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u062d\\u0627\\u0644\\u0627\\u062a\\u060c \\u0642\\u062f \\u0646\\u062d\\u062a\\u0627\\u062c \\u0625\\u0644\\u0649 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0625\\u0636\\u0627\\u0641\\u064a\\u0629 \\u0644\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0637\\u0644\\u0628\\u0643.<\\/li><\\/ul><p><strong>\\u0627\\u0644\\u062e\\u0637\\u0648\\u0629 3: \\u0627\\u0644\\u0645\\u0648\\u0627\\u0641\\u0642\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f<\\/strong><\\/p><ul><li>\\u0625\\u0630\\u0627 \\u062a\\u0645\\u062a \\u0627\\u0644\\u0645\\u0648\\u0627\\u0641\\u0642\\u0629 \\u0639\\u0644\\u0649 \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f\\u060c \\u0633\\u064a\\u062a\\u0645 \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0625\\u0644\\u0649 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0623\\u0635\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643 \\u062e\\u0644\\u0627\\u0644 7-10 \\u0623\\u064a\\u0627\\u0645 \\u0639\\u0645\\u0644.<\\/li><li>\\u0633\\u062a\\u062a\\u0644\\u0642\\u0649 \\u0625\\u0634\\u0639\\u0627\\u0631\\u064b\\u0627 \\u0628\\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a \\u0644\\u062a\\u0623\\u0643\\u064a\\u062f \\u062d\\u0627\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>4. \\u0633\\u064a\\u0627\\u0633\\u0627\\u062a \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0627\\u0644\\u0645\\u0648\\u0631\\u062f\\u064a\\u0646<\\/h4><p>\\u0642\\u062f \\u064a\\u0643\\u0648\\u0646 \\u0644\\u062f\\u0649 \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0645\\u0648\\u0631\\u062f\\u064a\\u0646 \\u0633\\u064a\\u0627\\u0633\\u0627\\u062a \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0623\\u0648 \\u0625\\u0644\\u063a\\u0627\\u0621 \\u062e\\u0627\\u0635\\u0629 \\u0628\\u0647\\u0645. \\u0633\\u064a\\u062a\\u0645 \\u062a\\u0648\\u0636\\u064a\\u062d \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0633\\u0627\\u062a \\u0628\\u0648\\u0636\\u0648\\u062d \\u0623\\u062b\\u0646\\u0627\\u0621 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062d\\u062c\\u0632. \\u064a\\u0636\\u0645\\u0646 SalonHub \\u0623\\u0646 \\u064a\\u062a\\u0645 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0628\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629 \\u0628\\u0634\\u0623\\u0646 \\u0633\\u064a\\u0627\\u0633\\u0627\\u062a \\u0627\\u0644\\u0645\\u0648\\u0631\\u062f\\u064a\\u0646 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0648\\u0633\\u064a\\u0639\\u0645\\u0644 \\u0643\\u0648\\u0633\\u064a\\u0637 \\u0641\\u064a \\u062d\\u0627\\u0644 \\u062d\\u062f\\u0648\\u062b \\u0646\\u0632\\u0627\\u0639\\u0627\\u062a.<\\/p><p>&nbsp;<\\/p><h4>5. \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a<\\/h4><ul><li>\\u0633\\u064a\\u062a\\u0645 \\u0625\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0645\\u0628\\u0627\\u0644\\u063a \\u0627\\u0644\\u0645\\u0633\\u062a\\u0631\\u062f\\u0629 \\u0625\\u0644\\u0649 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0623\\u0635\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0647\\u0627 \\u0623\\u062b\\u0646\\u0627\\u0621 \\u0627\\u0644\\u062d\\u062c\\u0632.<\\/li><li>\\u0625\\u0630\\u0627 \\u0644\\u0645 \\u062a\\u0639\\u062f \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0623\\u0635\\u0644\\u064a\\u0629 \\u0635\\u0627\\u0644\\u062d\\u0629\\u060c \\u064a\\u0631\\u062c\\u0649 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0645\\u0639\\u0646\\u0627 \\u0644\\u062a\\u0631\\u062a\\u064a\\u0628 \\u0628\\u062f\\u0627\\u0626\\u0644.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>6. \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a \\u0648\\u0627\\u0644\\u062d\\u0644\\u0648\\u0644<\\/h4><ul><li>\\u0625\\u0630\\u0627 \\u0643\\u0646\\u062a \\u063a\\u064a\\u0631 \\u0631\\u0627\\u0636\\u064d \\u0639\\u0646 \\u0646\\u062a\\u064a\\u062c\\u0629 \\u0637\\u0644\\u0628 \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u062a\\u0635\\u0639\\u064a\\u062f \\u0634\\u0643\\u0648\\u0627\\u0643 \\u0625\\u0644\\u0649 [dispute@example.com] \\u0644\\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u064a\\u0629.<\\/li><li>\\u0633\\u064a\\u0642\\u0648\\u0645 \\u0641\\u0631\\u064a\\u0642 \\u062e\\u062f\\u0645\\u0629 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0628\\u0627\\u0644\\u062a\\u0648\\u0633\\u0637 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u062d\\u0644 \\u0639\\u0627\\u062f\\u0644 \\u0644\\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0627\\u0644\\u0645\\u0639\\u0646\\u064a\\u0629.<\\/li><\\/ul><p>&nbsp;<\\/p><h4>7. \\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0639\\u0644\\u0649 \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f<\\/h4><p>\\u0642\\u062f \\u0646\\u0642\\u0648\\u0645 \\u0628\\u062a\\u062d\\u062f\\u064a\\u062b \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0647\\u0630\\u0647 \\u0628\\u0634\\u0643\\u0644 \\u062f\\u0648\\u0631\\u064a \\u0644\\u062a\\u0639\\u0643\\u0633 \\u0627\\u0644\\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0641\\u064a \\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a\\u0646\\u0627 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u0627\\u062a\\u0646\\u0627. \\u064a\\u0634\\u064a\\u0631 \\"\\u062a\\u0627\\u0631\\u064a\\u062e \\u0627\\u0644\\u0633\\u0631\\u064a\\u0627\\u0646\\" \\u0641\\u064a \\u0627\\u0644\\u0623\\u0639\\u0644\\u0649 \\u0625\\u0644\\u0649 \\u0623\\u062d\\u062f\\u062b \\u062a\\u062d\\u062f\\u064a\\u062b.<\\/p><p>&nbsp;<\\/p><h4>8. \\u062a\\u0648\\u0627\\u0635\\u0644 \\u0645\\u0639\\u0646\\u0627<\\/h4><p>\\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646\\u062a \\u0644\\u062f\\u064a\\u0643 \\u0623\\u064a \\u0623\\u0633\\u0626\\u0644\\u0629 \\u0623\\u0648 \\u0643\\u0646\\u062a \\u0628\\u062d\\u0627\\u062c\\u0629 \\u0625\\u0644\\u0649 \\u0645\\u0633\\u0627\\u0639\\u062f\\u0629 \\u0628\\u0634\\u0623\\u0646 \\u0627\\u0633\\u062a\\u0631\\u062f\\u0627\\u062f \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a\\u060c \\u064a\\u0631\\u062c\\u0649 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0645\\u0639\\u0646\\u0627:<\\/p><ul><li>\\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a: support@example.com<\\/li><li>\\u0627\\u0644\\u0647\\u0627\\u062a\\u0641: +03601 885399<\\/li><li>\\u0627\\u0644\\u0639\\u0646\\u0648\\u0627\\u0646: 20-22 Wenlock Road, England, N1 7GU<\\/li><\\/ul><p>&nbsp;<\\/p><p>\\u0647\\u0644 \\u062a\\u0631\\u064a\\u062f \\u0625\\u062c\\u0631\\u0627\\u0621 \\u062a\\u0639\\u062f\\u064a\\u0644\\u0627\\u062a \\u0623\\u0648 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0645\\u0646 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0625\\u0644\\u0649 \\u0647\\u0630\\u0627 \\u0627\\u0644\\u0646\\u0635\\u061f<\\/p><p>&nbsp;<\\/p><p>&nbsp;<\\/p>"}}}','status' => '1','editable' => '1','created_at' => '2023-08-10 20:19:01','updated_at' => '2025-01-07 10:01:28')
        );

        UsefulLink::insert($useful_links);
    }
}
