<?php

namespace Database\Seeders;

use App\Models\Admin\Area;
use App\Models\Vendor\Vendor;
use Illuminate\Database\Seeder;
use Database\Seeders\User\UserSeeder;
use Database\Seeders\Admin\RoleSeeder;
use Database\Seeders\Admin\AdminSeeder;
use Database\Seeders\Admin\CurrencySeeder;
use Database\Seeders\Admin\LanguageSeeder;
use Database\Seeders\Admin\SetupKycSeeder;
use Database\Seeders\Admin\SetupSeoSeeder;
use Database\Seeders\Admin\ExtensionSeeder;
use Database\Seeders\Admin\SetupPageSeeder;
use Database\Seeders\Admin\UsefulLinkSeeder;
use Database\Seeders\Admin\AppSettingsSeeder;
use Database\Seeders\Admin\AdminHasRoleSeeder;
use Database\Seeders\Admin\FreshBasicSettingsSeeder;
use Database\Seeders\Admin\SiteSectionsSeeder;
use Database\Seeders\Admin\BasicSettingsSeeder;
use Database\Seeders\Admin\PaymentGatewaySeeder;
use Database\Seeders\Admin\TransactionSettingSeeder;
use Database\Seeders\Admin\AreaSeeder;
use Database\Seeders\Admin\BlogSeeder;
use Database\Seeders\Admin\BlogCategorySeeder;
use Database\Seeders\Admin\SystemMaintenanceSeeder;
use Database\Seeders\Admin\ParlourListSeeder;
use Database\Seeders\Admin\FreshParlourListSeeder;
use Database\Seeders\Admin\OnBoardScreenSeeder;
use Database\Seeders\Admin\SectionHasPageSeeder;
use Database\Seeders\Vendor\VendorSeeder;
use Database\Seeders\ManagerSeeder;
use Database\Seeders\Vendor\VendorWalletSeeder;
use Database\Seeders\ParlourBookingSeeder;


class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        //fresh
        $this->call([
            AdminSeeder::class,
            RoleSeeder::class,
            TransactionSettingSeeder::class,
            CurrencySeeder::class,
            FreshBasicSettingsSeeder::class,
            SetupSeoSeeder::class,
            AppSettingsSeeder::class,
            SiteSectionsSeeder::class,
            BlogCategorySeeder::class,
            BlogSeeder::class,
            SetupPageSeeder::class,
            SetupKycSeeder::class,
            ExtensionSeeder::class,
            AdminHasRoleSeeder::class,
            LanguageSeeder::class,
            UsefulLinkSeeder::class,
            PaymentGatewaySeeder::class,
            AreaSeeder::class,
            FreshParlourListSeeder::class,
            SystemMaintenanceSeeder::class,
          SectionHasPageSeeder::class,
        ]);

        //demo
        // $this->call([
        //     AdminSeeder::class,
        //     RoleSeeder::class,
        //     TransactionSettingSeeder::class,
        //     SystemMaintenanceSeeder::class,
        //     CurrencySeeder::class,
        //     BasicSettingsSeeder::class,
        //     SetupSeoSeeder::class,
        //     AppSettingsSeeder::class,
        //     SiteSectionsSeeder::class,
        //     BlogCategorySeeder::class,
        //     BlogSeeder::class,
        //     SetupPageSeeder::class,
        //     SetupKycSeeder::class,
        //     ExtensionSeeder::class,
        //     AdminHasRoleSeeder::class,
        //     UserSeeder::class,
        //     VendorSeeder::class,
        //     ManagerSeeder::class,
        //     LanguageSeeder::class,
        //     UsefulLinkSeeder::class,
        //     PaymentGatewaySeeder::class,
        //     AreaSeeder::class,
        //     ParlourListSeeder::class,
        //     VendorWalletSeeder::class,
        //     ParlourBookingSeeder::class,
        //     StuffSeeder::class,
        //     OnBoardScreenSeeder::class,
        //     SectionHasPageSeeder::class,
        // ]);
    }
}
