@extends('admin.layouts.master')
@php
    $app_local = get_default_language_code();
    $default_lang_code = language_const()::NOT_REMOVABLE;
    $languages_for_js_use = $languages->toJson();
@endphp
@push('css')
    <style>
        .fileholder {
            min-height: 448px !important;
        }

        .fileholder-files-view-wrp.accept-single-file .fileholder-single-file-view,
        .fileholder-files-view-wrp.fileholder-perview-single .fileholder-single-file-view {
            height: 404px !important;
        }
    </style>
@endpush

@section('page-title')
    @include('admin.components.page-title', ['title' => __($page_title)])
@endsection

@section('breadcrumb')
    @include('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('App Settings'),
    ])
@endsection

@section('content')
    <div class="table-area">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title">{{ __('Onboard Screen') }}</h5>
                <div class="table-btn-area">
                    @include('admin.components.link.add-default', [
                        'href' => '#onboard-screen-add',
                        'class' => 'modal-btn',
                        'text' => __('Add New Screen'),
                        'permission' => 'admin.app.settings.onboard.screen.store',
                    ])
                </div>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th></th>
                            <th>{{ __('Title') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($onboard_screens as $item)
                            <tr data-item="{{ $item->editData }}">
                                <td>
                                    <ul class="user-list">
                                        <li><img src="{{ get_image($item->image, 'app-images') }}" alt="onboard-image"></li>
                                    </ul>
                                </td>
                                <td>{{ $item->title->language->$app_local->title ?? '' }}</td>
                                <td>
                                    @include('admin.components.form.switcher', [
                                        'label' => false,
                                        'name' => 'status',
                                        'value' => old('status', $item->status),
                                        'options' => [__('Enable') => 1, __('Disable') => 0],
                                        'onload' => true,
                                        'data_target' => $item->id,
                                        'permission' => 'admin.app.settings.onboard.screen.status.update',
                                    ])
                                </td>
                                <td>
                                    @include('admin.components.link.edit-default', [
                                        'class' => 'onboard-screen-edit-modal-btn',
                                        'permission' => 'admin.app.settings.onboard.screen.update',
                                    ])

                                    @include('admin.components.link.delete-default', [
                                        'class' => 'onboard-screen-delete-modal-btn',
                                        'permission' => 'admin.app.settings.onboard.screen.delete',
                                    ])
                                </td>
                            </tr>
                        @empty
                            @include('admin.components.alerts.empty', ['colspan' => 5])
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Modal Section --}}
    @include('admin.components.modals.add-onboard-screen')

    {{-- Edit Modal --}}
    @include('admin.components.modals.edit-onboard-screen')
@endsection

@push('script')
    <script>
        $(document).ready(function() {

            switcherAjax("{{ setRoute('admin.app.settings.onboard.screen.status.update') }}");

            $(".onboard-screen-delete-modal-btn").click(function() {
                var oldData = JSON.parse($(this).parents("tr").attr("data-item"));

                var actionRoute = "{{ setRoute('admin.app.settings.onboard.screen.delete') }}";
                var target = oldData.target;
                var message =
                    "{{ __('Are you sure to') }} <strong>{{ __('delete') }}</strong> {{ __('this screen?') }}";

                openDeleteModal(actionRoute, target, message);
            });

        });

        function openDeleteModal(URL, target, message, actionBtnText = "{{ __('Remove') }}", method = "DELETE") {
            if (URL == "" || target == "") {
                return false;
            }

            if (message == "") {
                message = "{{ __('Are you sure to delete ?') }}";
            }
            var method = `<input type="hidden" name="_method" value="${method}">`;
            openModalByContent({
                    content: `<div class="card modal-alert border-0">
                        <div class="card-body">
                            <form method="POST" action="${URL}">
                                <input type="hidden" name="_token" value="${laravelCsrf()}">
                                ${method}
                                <div class="head mb-3">
                                    ${message}
                                    <input type="hidden" name="target" value="${target}">
                                </div>
                                <div class="foot d-flex align-items-center justify-content-between">
                                    <button type="button" class="modal-close btn btn--info">{{ __('Close') }}</button>
                                    <button type="submit" class="alert-submit-btn btn btn--danger btn-loading">${actionBtnText}</button>
                                </div>
                            </form>
                        </div>
                    </div>`,
                },

            );
        }

        function openModalByContent(data = {
            content: "",
            animation: "mfp-move-horizontal",
            size: "medium",
        }) {
            $.magnificPopup.open({
                removalDelay: 500,
                items: {
                    src: `<div class="white-popup mfp-with-anim ${data.size ?? "medium"}">${data.content}</div>`, // can be a HTML string, jQuery object, or CSS selector
                },
                callbacks: {
                    beforeOpen: function() {
                        this.st.mainClass = data.animation ?? "mfp-move-horizontal";
                    },
                    open: function() {
                        var modalCloseBtn = this.contentContainer.find(".modal-close");
                        $(modalCloseBtn).click(function() {
                            $.magnificPopup.close();
                        });
                    },
                },
                midClick: true,
            });
        }

        function laravelCsrf() {
            return $("head meta[name=csrf-token]").attr("content");
        }
    </script>
    <script>
        openModalWhenError("onboard-screen-edit", "#onboard-screen-edit");
        var default_language = "{{ $default_lang_code }}";
        var languages = "{{ $languages_for_js_use }}";
        languages = JSON.parse(languages.replace(/&quot;/g, '"'));
        $(".onboard-screen-edit-modal-btn").click(function() {
            var oldData = JSON.parse($(this).parents("tr").attr("data-item"));
            var editModal = $("#onboard-screen-edit");

            editModal.find("form").first().find("input[name=target]").val(oldData.target);
            editModal.find("input[name=screen_image]").attr("data-preview-name", oldData.image);
            $.each(languages, function(index, item) {
                editModal.find("input[name=" + item.code + "_title]").val((oldData.title.language[item
                    .code] == undefined) ? '' : oldData.title.language[item.code].title);

            });

            fileHolderPreviewReInit("#onboard-screen-edit input[name=screen_image]");
            openModalBySelector("#onboard-screen-edit");

        });
    </script>
@endpush
