@extends('admin.layouts.master')

@push('css')
@endpush

@section('page-title')
    @include('admin.components.page-title', ['title' => __($page_title)])
@endsection

@section('breadcrumb')
    @include('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('Add Money Logs'),
    ])
@endsection

@section('content')
    <div class="table-area">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title">{{ $page_title }}</h5>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th>{{ __('TRX ID') }}</th>
                            <th>{{ __('Full Name') }}</th>
                            <th>{{ __('Email') }}</th>
                            <th>{{ __('Phone') }}</th>
                            <th>{{ __('Amount') }}</th>
                            <th>{{ __('Gateway') }}</th>
                            <th>{{ __('rating') }}</th>
                            <th>{{ __('reviews') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Time') }}</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($transactions  as $key => $item)
                            <tr>
                                <td>{{ $item->trx_id }}</td>
                                <td>{{ $item->user->fullname }}</td>
                                <td>{{ $item->user->email }}</td>
                                <td>{{ $item->user->mobile ?? 'N/A' }}</td>
                                <td>{{ get_amount($item->price) }}</td>
                                <td><span class="text--info">{{ $item->gateway_currency->name ?? $item->type }}</span></td>
                                <td>
                                    @if ($item->review == null)
                                        <p>{{ __('No review given') }}</p>
                                    @else
                                        <div class="star-rating-display">
                                            @for ($i = 1; $i <= 5; $i++)
                                                @if ($i <= $item->review)
                                                    <span class="star-filled">★</span>
                                                @else
                                                    <span class="star-empty">☆</span>
                                                @endif
                                            @endfor
                                            <span class="rating-value">({{ $item->review }}/5)</span>
                                        </div>
                                    @endif
                                </td>
                                <td>
                                    {{ $item->comment ?? 'No comment given'}}
                                </td>
                                <td>
                                    <span
                                        class="{{ $item->stringStatus->class }}">{{ __($item->stringStatus->value) }}</span>
                                </td>
                                <td>{{ $item->created_at->format('d-m-y h:i:s A') }}</td>
                                <td>
                                    @if ($item->status == 2)
                                        <a href="{{ route('admin.booking.log.status.update', ['trxId' => $item->trx_id, 'status' => 1]) }}"
                                            class="btn btn-success">
                                            {{ __('Accept') }}
                                        </a>
                                        <a href="{{ route('admin.booking.log.status.update', ['trxId' => $item->trx_id, 'status' => 3]) }}"
                                            class="btn btn-danger">
                                            {{ __('Reject') }}
                                        </a>
                                    @else
                                        <span
                                            class="{{ $item->stringStatus->class }}">{{ __($item->stringStatus->value) }}</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            @include('admin.components.alerts.empty', ['colspan' => 11])
                        @endforelse
                    </tbody>
                </table>
            </div>
            {{ get_paginate($transactions) }}
        </div>
    </div>
@endsection

@push('script')
@endpush
