@extends('frontend.layouts.master')

@push('css')
@endpush

@section('content')
    <!-- banner-searching -->
    <section class="find-parlour-section">
        @include('frontend.section.banner-search')
    </section>
    <!-- serching data -->
    <section class="parlour-list-area ptb-80">
        <div class="container">

            <div class="row justify-content-center mb-20-none">
                @forelse ($parlour_lists ?? [] as $item)
                    <div class="col-lg-4 col-md-6 col-sm-10 mb-20">
                        <div class="parlor-item">
                            <div class="parlor-img">
                                <img src="{{ get_image($item->image, 'site-section') }}" alt="img">
                            </div>
                            @php

                                $salon_related_booking = App\Models\ParlourBooking::where(
                                    'status',
                                    global_const()::STATUSSUCCESS,
                                )
                                    ->where('parlour_id', $item->id)

                                    ->whereNotNull('review')
                                    // ->with('parlour')
                                    // dd($salon_with_rating);
                                    ->sum('review');

                                $salon_booking_count = App\Models\ParlourBooking::where(
                                    'status',
                                    global_const()::STATUSSUCCESS,
                                )
                                    ->where('parlour_id', $item->id)

                                    ->whereNotNull('review')
                                    ->with('parlour')
                                    ->count();
                                $salon_average_ratings =
                                    $salon_booking_count > 0 ? $salon_related_booking / $salon_booking_count : 0;

                            @endphp

                            @if ($salon_average_ratings == null)
                                <p>{{ __('No review given') }}</p>
                            @else
                                <div class="star-rating-display">
                                    @for ($i = 1; $i <= 5; $i++)
                                        @if ($i <= $salon_average_ratings)
                                            <span class="star-filled">★</span>
                                        @else
                                            <span class="star-empty">☆</span>
                                        @endif
                                    @endfor
                                    <span class="rating-value">({{ $salon_average_ratings }}/5)</span>
                                </div>
                            @endif

                            <div class="parlor-details">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h3 class="title">{{ $item->name ?? '' }}</h3>
                                    @if (auth()->check())
                                        <button class="favorite-btn" data-id="{{ $item->id }}">
                                            @php
                                                $fav_parlour_id = $item->favorites->first()->parlour_id ?? '';
                                            @endphp
                                            <i
                                                class="fas fa-heart {{ $fav_parlour_id == $item->id ? 'text-danger' : 'text-secondary' }}"></i>
                                        </button>
                                    @endif
                                </div>
                                <p>{{ $item->manager_name ?? '' }}</p>
                                <p>{{ $item->experience ?? '' }} {{ __('Year Experience') }}</p>
                                <p>{{ $item->address ?? '' }}</p>
                            </div>
                            <div class="booking-btn pt-2">
                                <a href="{{ setRoute('frontend.get.service.index', $item->slug) }}"
                                    class="btn--base w-100">{{ __('Get Service') }}</a>
                            </div>
                        </div>
                    </div>
                    @empty
                        <div class="col-lg-4 col-md-6 col-sm-10 mb-20">
                            <div class="parlor-item">
                               
                                <div class="parlor-info">
                                    <h3 class="title">{{ __('No Parlour Found !') }}</h3>
                                </div>
                            </div>
                        </div>
                    @endforelse
            </div>
            {{ get_paginate($parlour_lists) }}
        </div>
    </section>
@endsection

@push('script')
    <script>
        var message = '@json($message)';
        throwMessage('error', JSON.parse(message));
    </script>
@endpush
