<!--  how its work -->
@php

    $app_local = get_default_language_code() ?? 'en';
    $default = App\Constants\LanguageConst::NOT_REMOVABLE;

    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::HOW_ITS_WORK_SECTION);
    $how_its_work = App\Models\Admin\SiteSections::getData($slug)->first();

@endphp
<div class="how-its-work-section pt-80">
    <div class="container">
        <div class="row">
            <div class="col-xl-8 col-lg-10">
                <div class="how-its-work-title">
                    <h4 class="titte text--base pb-20">
                        {{ $how_its_work->value->language->$app_local->title ?? ($how_its_work->value->language->$default->title ?? '') }}
                    </h4>
                    <h2 class="titte d-flex align-items-center">
                        {{ $how_its_work->value->language->$app_local->heading ?? ($how_its_work->value->language->$default->heading ?? '') }}
                        <i class="las la-arrow-right"></i></h2>
                    <p>{{ $how_its_work->value->language->$app_local->sub_heading ?? ($how_its_work->value->language->$default->sub_heading ?? '') }}
                    </p>
                </div>
            </div>
        </div>
        <div class="row pt-40 mb-20-none">
            @if (isset($how_its_work->value->items))
                @php
                    $step_key = 0;
                    $how_its_works = $how_its_work->value->items ?? [];
                @endphp
                @foreach ($how_its_works ?? [] as $key => $item)
                    @php
                        $step_key++;
                    @endphp
                    <div class="col-lg-3 col-md-6 col-sm-6 mb-20">
                        <div class="working-step">
                            <div class="step-header">
                                <div class="icon"><i class="{{ $item->icon ?? '' }}"></i></div>
                                <p> {{ __('Step') }} {{ $step_key }}</p>
                            </div>
                            <div class="step-content">
                                <h4 class="title">
                                    {{ $item->language->$app_local->item_title ?? ($item->language->$default->item_title ?? '') }}
                                </h4>
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>
    </div>
</div>
