 
 @php
    $app_local = get_default_language_code();
    $default = App\Constants\LanguageConst::NOT_REMOVABLE;


    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::VENDOR_FEATURES_SECTION);
    $features = App\Models\Admin\SiteSections::getData($slug)->first();


@endphp
 <!-- Vendor Feature -->
    <section class="vendor-feature ptb-80">
        <div class="container">
            <div class="vendor-feature-title pb-30">
                <div class="row">
                    <div class="col-xl-8 col-lg-10">
                        <div class="feature-title">
                            <h4 class="titte text--base pb-20">
                                {{ $features->value->language->$app_local->section_title ?? ($features->value->language->$default->section_title ?? '') }}
                            </h4>
                            <h2 class="title">
                                {{ $features->value->language->$app_local->heading ?? ($features->value->language->$default->heading ?? '') }}
                            </h2>
                            <p>{{ $features->value->language->$app_local->sub_heading ??
                                ($features->value->language->$default->sub_heading ?? '') }}
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            @php
                $items = $features->value->items ?? [];
                $item_data = (array) $items;

                $converted_data =
                    count($item_data) > 0 ? array_chunk($item_data, ceil(count($item_data) / 2)) : [[], []];

                $part1 = $converted_data[0] ?? [];

                $part2 = $converted_data[1] ?? [];

            @endphp
            <div class="row mb-20-none">
                <div class="col-lg-6 mb-20">
                    <div class="feature-content">
                        <div class="feature-listing">
                            <div class="row mb-20-none">
                                @foreach ($part1 ?? [] as $item)
                                    <div class="col-lg-12 mb-20">
                                        <div class="feature">
                                            <h3 class="title">
                                                {{ $item->language->$app_local->title ?? ($item->language->$default->title ?? '') }}
                                            </h3>
                                            <p>{{ $item->language->$app_local->description ?? ($item->language->$default->description ?? '') }}
                                            </p>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 mb-20">
                    <div class="feature-content">
                        <div class="feature-listing">
                            <div class="row mb-20-none">
                                @foreach ($part2 ?? [] as $item)
                                    <div class="col-lg-12 mb-20">
                                        <div class="feature">
                                            <h3 class="title">
                                                {{ $item->language->$app_local->title ?? ($item->language->$default->title ?? '') }}
                                            </h3>
                                            <p>{{ $item->language->$app_local->description ?? ($item->language->$default->description ?? '') }}
                                            </p>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>