@php
    $app_local = get_default_language_code();
    $default = App\Constants\LanguageConst::NOT_REMOVABLE;

    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::VENDOR_REQUIREMENTS_SECTION);
    $requirements = App\Models\Admin\SiteSections::getData($slug)->first();

@endphp

<!-- Vendor Requirements -->
    <section class="vendor-requirements pb-80">
        <div class="container">
            <div class="required-title mb-30">
                <div class="row">
                    <div class="col-xl-8 col-lg-10">
                        <h4 class="title text--base pb-20">
                            {{ $requirements->value->language->$app_local->title ?? ($requirements->value->language->$default->title ?? '') }}
                        </h4>
                        <h2 class="title">
                            {{ $requirements->value->language->$app_local->heading ?? ($requirements->value->language->$default->heading ?? '') }}
                        </h2>
                    </div>
                </div>
            </div>
            <div class="row mb-20-none">
                @foreach ($requirements->value->items ?? [] as $key => $value)
                    <div class="col-xl-4 col-lg-6 mb-20">
                        <div class="required-content">
                            <h3 class="title">
                                <i class="{{ $value->icon ?? '' }}"></i>
                                {{ $value->language->$app_local->title ?? ($value->language->$default->title ?? '') }}
                            </h3>
                            @foreach ($value->detailsItem ?? [] as $key => $value)
                                <ul class="requirements-list">
                                    <li>{{ $value->language->$app_local->details ?? ($value->language->$default->details ?? '') }}
                                    </li>
                                </ul>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>