@php

      $manager_id       = auth()->user()->id;
      $parlour          = App\Models\Admin\ParlourList::where('manager_id',$manager_id)->first();
@endphp

<div class="sidebar">
    <div class="sidebar-inner">
        <div class="sidebar-menu-wrapper">
            <div class="sidebar-logo">
                <a href="{{ setRoute('frontend.index') }}" class="sidebar-main-logo">
                    <img src="{{ get_logo_manager($basic_settings) }}" data-white_img="{{ get_logo_manager($basic_settings, 'dark') }}"
                        data-dark_img="{{ get_logo_manager($basic_settings) }}" alt="logo">
                </a>
                <button class="sidebar-menu-bar">
                    <i class="fas fa-exchange-alt"></i>
                </button>
            </div>
            <ul class="sidebar-menu">
                <li class="sidebar-menu-item">
                    <a href="{{ setRoute('manager.dashboard') }}">
                        <i class="menu-icon las la-tachometer-alt"></i>
                        <span class="menu-title">{{ __('Dashboard') }}</span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="{{ setRoute('manager.booking.request.index') }}">
                        <i class="menu-icon las la-calendar-check"></i>
                        <span class="menu-title">{{ __('Booking Request') }}</span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    @if(isset($parlour->id) && $parlour->id)
                        <a href="{{ route('manager.my.parlour.details', ['id' => $parlour->id]) }}">
                            <i class="menu-icon las la-store"></i>
                            <span class="menu-title">{{ __('My Salon') }}</span>
                        </a>
                    @endif
                </li>
                <li class="sidebar-menu-item">
                    <a href="{{ setRoute('manager.assign.stuff.index') }}">
                        <i class="menu-icon las la-users-cog"></i>
                        <span class="menu-title">{{ __('Staff') }}</span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="javascript:void(0)" class="logout-btn-manager">
                        <i class="menu-icon las la-sign-out-alt"></i>
                        <span class="menu-title">{{ __('Logout') }}</span>
                    </a>
                </li>
            </ul>

        </div>
    </div>
</div>

@push('script')
    <script>
        $(".logout-btn-manager").click(function() {
            var actionRoute = "{{ setRoute('manager.logout') }}";
            var target = 1;
            var message = `{{ __('Are you sure to') }} <strong>{{ __('Logout') }}</strong>?`;

            openAlertModal(actionRoute, target, message, "{{ __('Logout') }}", "POST");
            /**
             * Function for open delete modal with method DELETE
             * @param {string} URL
             * @param {string} target
             * @param {string} message
             * @returns
             */
            function openAlertModal(URL, target, message, actionBtnText = "{{ __('Remove') }}", method =
                "DELETE") {
                if (URL == "" || target == "") {
                    return false;
                }

                if (message == "") {
                    message = "Are you sure to delete ?";
                }
                var method = `<input type="hidden" name="_method" value="${method}">`;
                openModalByContent({
                        content: `<div class="card modal-alert border-0">
              <div class="card-body">
                  <form method="POST" action="${URL}">
                      <input type="hidden" name="_token" value="${laravelCsrf()}">
                      ${method}
                      <div class="head mb-3">
                          ${message}
                          <input type="hidden" name="target" value="${target}">
                      </div>
                      <div class="foot d-flex align-items-center justify-content-between">
                          <button type="button" class="modal-close btn--base btn-for-modal">{{ __('Close') }}</button>
                          <button type="submit" class="alert-submit-btn btn--danger btn-loading btn-for-modal">${actionBtnText}</button>
                      </div>
                  </form>
              </div>
          </div>`,
                    },

                );
            }
        });
    </script>
@endpush
