@extends('user.layouts.master')

@push('css')
@endpush
@section('breadcrumb')
    @include('user.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __($page_title),
                'url' => setRoute('user.profile.index'),
            ],
        ],
    ])
@endsection
@section('content')
    <section class="parlour-list-area ptb-80">
        <div class="container">
            <div class="row justify-content-center mb-20-none">
             
                @forelse ($parlour_lists ?? [] as $list)

                @php
                    $item= $list->parlour;
                @endphp
                    <div class="col-lg-4 col-md-6 col-sm-10 mb-20">
                        <div class="parlor-item">
                            <div class="parlor-img">
                                <img src="{{ get_image($item?->image, 'site-section') }}" alt="img">
                            </div>
                            <div class="parlor-details">
                                <h3 class="title">{{ $item->name ?? '' }}</h3>
                                <p>{{ __('Experience') }} : {{ $item->experience ?? '' }}</p>
                                <p>{{ __('Address') }} : {{ $item->address ?? '' }}</p>

                            </div>
                            <div class="booking-btn pt-2">
                                <a href="{{ setRoute('frontend.get.service.index', $item->slug) }}"
                                    class="btn--base w-100">{{ __('Get Service') }}</a>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="col-xl-8">
                        <div class="alert alert-primary alert-section-bg text-center">
                            {{ __('No Record Found!') }}
                        </div>
                    </div>
                @endforelse
            </div>
            {{ get_paginate($parlour_lists) }}
        </div>
    </section>
@endsection
@push('script')


@endpush
