@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Staff'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
        'active' => __('Staff Assign'),
    ])
@endsection

@section('content')
    <div class="custom-card">
        <div class="card-body">
            <form class="card-form" action="{{ setRoute('vendors.stuff.assign.submit') }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                <div class="row  mb-10-none">
                    <div class="col-xl-12 col-lg-12 form-group">
                        <label>{{ __('Select Salon') }}*</label>
                        <select class="form--control select2-basic" name="parlour_list_id">
                            <option disabled selected>{{ __('Select Salon') }}</option>
                            @foreach ($parlour_list as $item)
                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="custom-inner-card">
                            <div class="card-inner-header">
                                <h6 class="title">{{ __('Staff') }}</h6>
                            </div>
                            <div class="card-inner-body">
                                <div class="stuff-result">
                                    <ul class="permission-list">

                                        @foreach ($parlour_has_stuff ?? [] as $item)
                                            <div class="col-lg-4 col-md-4 col-sm-6 d-flex mb-3">
                                                <div class="box-checkbox" style="flex: 0;">
                                                    <input type="checkbox" name="stuff_name[]" class="stuff-name-checkbox"
                                                        id="stuff-name-list-{{ $item->id }}"
                                                        @if (in_array($item->stuff_name, $selected_names ?? [])) checked @endif
                                                        value="{{ $item->id }}">
                                                </div>
                                                <div class="box-name">
                                                    {{ $item->stuff_name }}
                                                </div>
                                            </div>
                                        @endforeach

                                    </ul>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        @include('admin.components.button.form-btn', [
                            'class' => 'w-100 btn-loading',
                            'text' => 'Submit',
                        ])
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(document).ready(function() {
            var getStuffURL = "{{ setRoute('manager.assign.stuff.get.stuff') }}";
            $('.add-stuff-btn').click(function() {

                $.get(getStuffURL, function(data) {
                    $('.stuff-result').prepend(data);
                    $('.stuff-result').find('.row').first().find("select").select2();
                });
            });
        });
    </script>
@endpush
