@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Manager'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
        'active' => __('Manager Add'),
    ])
@endsection

@section('content')
    <div class="custom-card">
        <div class="card-header">
            <h6 class="title">{{ __($page_title) }}</h6>
        </div>
        <div class="card-body">
            <form id="register" class="" method="POST" action="{{ setRoute('vendors.manager.register.submit') }}" enctype="multipart/form-data">
                @csrf
                <div class="personal-account pt-30 select-account" data-select-target="1">
                    <div class="row">
                        <input type="text"  name="vendor_id" value="{{ $vendor_id }}" hidden>
                        <div class="row justify-content-center">
                            <div class="col-xl-4 col-lg-4 form-group mb-5">
                                @include('admin.components.form.input-file', [
                                    'label' => __('Image'),
                                    'name' => 'image',
                                    'class' => 'file-holder',
                                    'old_files' => old('image'),
                                    'attribute' => 'data-height=130',
                                ])
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 form-group">
                            <label>{{ __('First Name') }}</label>
                            <input type="text" class="form-control form--control" name="firstname"
                                placeholder="{{ __('First Name') }}">
                        </div>
                        <div class="col-lg-6 col-md-6 form-group">
                            <label>{{ __('Last Name') }}</label>
                            <input type="text" class="form-control form--control" name="lastname"
                                placeholder="{{ __('Last Name') }}">
                        </div>
                        <div class="col-lg-12 form-group">
                            <label>{{ __('Email Address') }}</label>
                            <input type="email" class="form-control form--control" name="email"
                                placeholder="{{ __('Email') }}">
                        </div>
                        <div class="col-lg-12 form-group show_hide_password-2">
                            <label>{{ __('Enter Password') }}</label>
                            <div class="manager-password d-flex">
                                <input type="password" class="form-control form--control place_random_password" name="password"
                                placeholder="{{ __('Password') }}">
                                <a href="#0" class="show-pass"><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
                                <button class="input-group-text rand_password_generator" type="button">{{ __("Generate") }}</button>
                            </div>
                        </div>
                        <div class="col-lg-12 form-group text-center">
                            <button type="submit" class="btn--base w-100">{{ __('Add Manager') }}</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('script')
<script>
    function placeRandomPassword(clickedButton,placeInput) {
        $(clickedButton).click(function(){
            var generateRandomPassword = makeRandomString(10);
            $(placeInput).val(generateRandomPassword);
        });
    }
    placeRandomPassword(".rand_password_generator",".place_random_password");
</script>
@endpush
