@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Salon List'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
        'active' => __('Salon List'),
    ])
@endsection

@section('content')
    <div class="custom-card">
        <div class="card-body">
            <form class="card-form" action="{{ setRoute('vendors.parlour.list.update', $parlour_list->slug) }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                @method('PUT')
       
                @php
                    $minImages = 4; // Minimum required Salon Previews
                    $existingImages = $parlour_list->parlourImage;
                    $countExisting = $existingImages->count();
                    $extraNeeded = max(0, $minImages - $countExisting);
                @endphp
                <div class="row justify-content-center">
                    <div class="col-xl-12 col-lg-12 col-12 form-group mb-5">
                        <div class="custom-inner-card input-field-generator" data-source="booking_file_input">
                            <div class="row align-items-end">
                                <div class="row justify-content-center">
                                    <div class="col-xl-4 col-lg-4 form-group mb-5">

                                        @include('admin.components.form.input-file', [
                                            'label' => __('Thumbnail Preview'),
                                            'name' => 'image',
                                            'class' => 'file-holder',
                                            'old_files_path' => files_asset_path('site-section'),
                                            'old_files' => old('old_image', $parlour_list->image),
                                            'attribute' => 'data-height=130',
                                        ])
                                    </div>
                                </div>
                                @foreach ($existingImages as $previewImage)
                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 form-group">
                                        @include('admin.components.form.input-file', [
                                            'label' => __('Salon Preview') . '<span>(optional)</span>',
                                            'name' => 'preview[]',
                                            'class' => 'file-holder',
                                            'old_files_path' => files_asset_path('site-section'),
                                            'old_files' => $previewImage->image_path,
                                            'attribute' => 'data-height=130',
                                        ])
                                    </div>
                                @endforeach

                                {{-- Add empty fields if less than minImages --}}
                                @for ($i = 0; $i < $extraNeeded; $i++)
                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 form-group">
                                        @include('admin.components.form.input-file', [
                                            'label' => __('Salon Preview') . '<span>(optional)</span>',
                                            'name' => 'preview[]',
                                            'class' => 'file-holder',
                                            'attribute' => 'data-height=130',
                                        ])
                                    </div>
                                @endfor

                            </div>
                        </div>
                    </div>

                </div>

                {{-- <div class="row justify-content-center">
                    <!-- Existing images display -->
                    @foreach ($parlour_list->parlourImage as $image)
                        <div class="col-xl-4 col-lg-4 form-group mb-5">
                            <div class="custom-inner-card">
                                <img src="{{ get_image($image->image_path ?? '', 'site-section') ?? '' }}"
                                    alt="Parlour Image" class="img-fluid mb-2" style="max-height: 200px;">
                                <div class="d-flex justify-content-between">
                                    <button type="button" class="btn btn-sm btn-danger delete-image"
                                        data-id="{{ $image->id }}">Delete</button>
                                </div>
                                <input type="hidden" name="existing_images[]" value="{{ $image->id }}">
                            </div>
                        </div>
                    @endforeach

                    <!-- New image uploader -->
                    <div class="col-xl-4 col-lg-4 form-group mb-5">
                        <div class="custom-inner-card input-field-generator" data-source="booking_file_input">
                            <div class="row align-items-end">
                                <div class="col-xl-12 col-lg-12 form-group">
                                    <input class="" type="file" name="image[]" multiple>
                                </div>
                                <div class="form-group">
                                    <button type="button" class="btn--base add-row-btn"><i class="fas fa-plus"></i>
                                        {{ __('Add') }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> --}}
                <div class="row justify-content-center mb-10-none">
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('Select Area') }}*</label>
                        <select class="form--control select2-basic" name="area">
                            <option disabled selected>{{ __('Select Area') }}</option>
                            @foreach ($areas as $item)
                                <option value="{{ $item->id }}"
                                    {{ $item->id == $parlour_list->area_id ? 'selected' : '' }}>{{ $item->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('Select Manager') }}*</label>
                        <select class="form--control select2-basic" name="manager">
                            <option disabled selected>{{ __('Select Manager') }}</option>
                            @foreach ($manager as $item)
                                <option value="{{ $item->id }}"
                                    {{ $item->id == $parlour_list->manager_id ? 'selected' : '' }}>
                                    {{ $item->firstname }} {{ $item->assign_status == 1 ? '(Assigned)' : '' }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Name') . '*',
                            'name' => 'name',
                            'placeholder' => __('Write Name') . '...',
                            'value' => old('name', $parlour_list->name),
                        ])
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Experience') . '*',
                            'name' => 'experience',
                            'placeholder' => __('Write Experience') . '...',
                            'value' => old('experience', $parlour_list->experience),
                        ])
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Speciality'),
                            'name' => 'speciality',
                            'placeholder' => __('Write Speciality') . '...',
                            'value' => old('speciality', $parlour_list->speciality),
                        ])
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Contact') . '*',
                            'name' => 'contact',
                            'placeholder' => __('Write Contact') . '...',
                            'value' => old('contact', $parlour_list->contact),
                        ])
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Address'),
                            'name' => 'address',
                            'placeholder' => __('Write Address') . '...',
                            'value' => old('address', $parlour_list->address),
                        ])
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <h3 class="title">{{ __('Off Days') }}</h3>
                        <div class="card-inner-body">
                            <div class="stuff-result">
                                <div class="row">
                                    @foreach (getWeekDays() as $day)
                                        @php
                                            $oldOffDays = old('off_days', $parlour_list->off_days);
                                            $oldOffDaysArray = is_array($oldOffDays)
                                                ? $oldOffDays
                                                : explode(',', $oldOffDays);
                                            $isChecked = in_array($day['value'], $oldOffDaysArray);
                                        @endphp
                                        <div class="col-lg-4 col-md-4 col-sm-6 d-flex mb-3">
                                            <div class="box-checkbox" style="flex: 0;">
                                                <input type="checkbox" class="form-check-input" name="off_days[]"
                                                    value="{{ $day['value'] }}" id="day-{{ $loop->index }}"
                                                    {{ $isChecked ? 'checked' : '' }}>
                                            </div>
                                            <div class="box-name mt-1">
                                                <label class="form-check-label ms-1" for="day-{{ $loop->index }}">
                                                    {{ $day['day_name'] }}
                                                </label>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Number Of Dates') . '*',
                            'name' => 'number_of_dates',
                            'placeholder' => __('Number Of Dates') . '...',
                            'value' => old('number_of_dates', $parlour_list->number_of_dates),
                        ])
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @php
                            $currentDate = \Carbon\Carbon::now();
                            $schedule_date = $parlour_list->number_of_dates;
                        @endphp
                        <label>{{ __('Selected Days') }}</label>
                        <select class="form--control select2-basic">
                            @for ($i = 0; $i < $schedule_date; $i++)
                                <option>{{ $currentDate->format('d F, Y') }}</option>
                                @php
                                    $currentDate->addDay();
                                @endphp
                            @endfor
                        </select>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="custom-inner-card">
                            <div class="card-inner-header pb-10 d-flex justify-content-between">
                                <h3 class="title">{{ __('Service') }}</h6>
                                    <button type="button" class="btn--base add-service-btn"><i class="fas fa-plus"></i>
                                        {{ __('Add') }}</button>
                            </div>
                            <div class="card-inner-body">
                                <div class="result">
                                    @include(
                                        'admin.components.parlour-list.service-item',
                                        compact('parlour_has_service'))
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="custom-inner-card">
                            <div class="card-inner-header">
                                <h3 class="title">{{ __('Staff') }}</h6>
                            </div>
                            <div class="card-inner-body">
                                <div class="stuff-result">
                                    <div class="row">
                                        @foreach ($parlour_has_stuff ?? [] as $item)
                                            @php
                                                $isChecked = $parlour_list->id === $item->parlour_list_id;
                                            @endphp
                                            <div class="col-lg-4 col-md-4 col-sm-6 d-flex mb-3">
                                                <div class="box-checkbox" style="flex: 0;">
                                                    <input type="checkbox" name="stuff_name[]" class="stuff-name-checkbox"
                                                        id="stuff-name-list-{{ $item->id }}"
                                                        @if ($isChecked) checked @endif
                                                        value="{{ $item->id }}">
                                                </div>
                                                <div class="box-name mt-1">
                                                    {{ $item->stuff_name }}
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="custom-inner-card">
                            <div class="card-inner-header pb-10 d-flex justify-content-between">
                                <h3 class="title">{{ __('Schedule') }}</h6>
                                    <button type="button" class="btn--base add-schedule-btn"><i class="fas fa-plus"></i>
                                        {{ __('Add') }}</button>
                            </div>
                            <div class="card-inner-body">
                                <div class="results">
                                    @include(
                                        'admin.components.parlour-list.schedule-item',
                                        compact('parlour_has_schedule'))
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        @include('admin.components.button.form-btn', [
                            'class' => 'w-100 btn-loading',
                            'text' => 'Submit',
                        ])
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('script')
    <script>
        $(document).ready(function() {
            var getDayURL = "{{ setRoute('vendors.parlour.list.get.days') }}";
            $('.add-schedule-btn').click(function() {
                $.get(getDayURL, function(data) {
                    $('.results').prepend(data);
                    $('.results').find('.row').first().find("select").select2();
                });
            });

            var getServiceURL = "{{ setRoute('vendors.parlour.list.get.service') }}";
            $('.add-service-btn').click(function() {
                $.get(getServiceURL, function(data) {
                    $('.result').prepend(data);
                    $('.result').find('.row').first().find("select").select2();
                });
            });

            var getStuffURL = "{{ setRoute('vendors.parlour.list.get.stuff') }}";
            $('.add-stuff-btn').click(function() {
                $.get(getStuffURL, function(data) {
                    $('.stuff-result').prepend(data);
                    $('.stuff-result').find('.row').first().find("select").select2();
                });
            });
        });
    </script>
   
    <script>
        $(document).ready(function() {
            $(document).on('click', '.delete-image', function() {
                if (confirm('Are you sure you want to delete this image?')) {
                    const imageId = $(this).data('id');
                    const $imageCard = $(this).closest('.custom-inner-card');

                    $.ajax({
                        url: "{{ route('vendors.parlour.list.image.delete') }}",
                        type: 'POST',
                        data: {
                            _token: $('meta[name="csrf-token"]').attr('content'),
                            image_id: imageId
                        },
                        success: function(response) {
                            // Remove the image card from UI on success
                            $imageCard.remove();
                            console.log('Image deleted successfully', response);

                            // Optional: Show success message
                            alert('Image deleted successfully!');
                        },
                        error: function(xhr, status, error) {
                            console.error('Error deleting image:', error);

                            // Optional: Show error message
                            alert('Error deleting image. Please try again.');
                        }
                    });
                }
            });
        });
    </script>
@endpush
