@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Salon List'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
    ])
@endsection


@section('content')
    <div class="selon-add-btn pb-20">
        <a href="{{ setRoute('vendors.parlour.list.create') }}" class="btn--base"><i class="las la-plus"></i>
            {{ __('Add Salon') }}</a>
    </div>
    <div class="my-salon parlour-list-area">
        <div class="row justify-content-center mb-20-none">

            @forelse ($parlour_lists ?? [] as $item)
                {{-- @dd($item->parlourImage) --}}
                @if ($item->status != 3)
                    <div data-item="{{ json_encode($item) }}" class="col-xl-4 col-lg-4 col-md-6 col-sm-12 mb-20">
                        <div class="parlor-item">
                            <div class="parlor-img">

                                <div class="">
                                    <img src="{{ get_image($item->image ?? '', 'site-section') ?? '' }}"
                                        class="img-fluid rounded  object-fit-cover" alt="img" height="500px"
                                        width="500px">
                                </div>


                                <div class="salon-control-btn">
                                    @include('frontend.components.form.switcher', [
                                        'name' => 'status',
                                        'value' => $item->active_status,
                                        'options' => [__('Active') => 1, __('Freeze') => 0],
                                        'onload' => true,
                                        'data_target' => $item->id,
                                    ])
                                </div>
                            </div>
                            <div class="parlor-details">
                                <h3 class="title">{{ $item->name ?? '' }}
                                </h3>
                                <h3>
                                    @php

                                        $salon_related_booking = App\Models\ParlourBooking::where(
                                            'status',
                                            global_const()::STATUSSUCCESS,
                                        )
                                            ->where('parlour_id', $item->id)
                                            ->where('vendor_id', auth()->user()->id)
                                            ->whereNotNull('review')
                                            // ->with('parlour')
                                            // dd($salon_with_rating);
                                            ->sum('review');

                                        
                                        $salon_booking_count = App\Models\ParlourBooking::where(
                                            'status',
                                            global_const()::STATUSSUCCESS,
                                        )
                                            ->where('parlour_id', $item->id)
                                            ->where('vendor_id', auth()->user()->id)
                                              ->whereNotNull('review')
                                            ->with('parlour')
                                            ->count();
                                        $salon_average_ratings =
                                            $salon_booking_count > 0 ? $salon_related_booking / $salon_booking_count : 0;
                               
                                    @endphp

                                    @if ($salon_average_ratings == null)
                                        <p>{{ __('No review given') }}</p>
                                    @else
                                        <div class="star-rating-display">
                                            @for ($i = 1; $i <= 5; $i++)
                                                @if ($i <= $salon_average_ratings)
                                                    <span class="star-filled">★</span>
                                                @else
                                                    <span class="star-empty">☆</span>
                                                @endif
                                            @endfor
                                            <span class="rating-value">({{ $salon_average_ratings }}/5)</span>
                                        </div>
                                    @endif
                                </h3>
                                <p> {{ __('Salon Name') }} : {{ $item->name ?? '' }} </p>
                                <p> {{ __('Manager Name') }} :
                                    {{ ($item->manager->firstname ?? '') . ' ' . ($item->manager->lastname ?? '') ?? 'Not Assigned' }}
                                </p>
                                <p>{{ __('Experience') }} : {{ $item->experience ?? '' }}</p>
                                <p> {{ __('Address') }} : {{ $item->address ?? '' }}</p>
                                {{-- <p> {{ __('Status') }} : <span
                                        class="{{ $item->stringStatus->class }}">{{ __($item->stringStatus->value) }}</span>
                                </p> --}}
                                <div class="control-btn pt-2 mb-10-none d-flex justify-content-between">
                                    <button type="button" class="delate-btn mb-10 delete-btn">{{ __('Delete') }}</button>
                                    <button type="button" class="edit-btn mb-10"
                                        onclick="window.location.href='{{ setRoute('vendors.parlour.list.edit', $item->slug) }}'">
                                        {{ __('Edit') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    <div data-item="{{ json_encode($item) }}" class="col-xl-4 col-lg-4 col-md-6 col-sm-12 mb-20">
                        <div class="parlor-item">
                            <div class="parlor-img">
                                <img src="{{ get_image($item->image ?? '', 'site-section') ?? '' }}" alt="img">
                            </div>
                            <div class="parlor-details">
                                <h3 class="title">{{ __('Rejected By Admin') }}</h3>
                                <p> {{ __('Salon Name') }} : {{ $item->name ?? '' }}</p>
                                <p> {{ __('Status') }} : <span
                                        class="{{ $item->stringStatus->class }}">{{ __($item->stringStatus->value) }}</span>
                                </p>
                                <p> {{ __('Reject Reason') }} : {{ $item->remarks ?? '' }}</p>
                                <div class="control-btn pt-2 mb-10-none justify-content-sm-between">
                                    <button type="button" class="delate-btn mb-10 delete-btn">{{ __('Delete') }}</button>
                                    <button type="button" class="edit-btn mb-10"
                                        onclick="window.location.href='{{ setRoute('vendors.parlour.list.edit', $item->slug) }}'">
                                        {{ __('Edit') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            @empty
                <td colspan="7">
                    <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                        {{ __('No Record Found!') }}
                    </div>
                </td>
            @endforelse

            {{ get_paginate($parlour_lists) }}
        </div>
    </div>
@endsection
@push('script')
    <script>
        $('.delete-btn').click(function() {
            var oldData = JSON.parse($(this).closest('[data-item]').attr('data-item')); // Corrected selector
            var actionRoute = "{{ setRoute('vendors.parlour.list.delete') }}";
            var target = oldData.id;
            var message =
                `{{ __('Are you sure to') }} <strong>{{ __('delete') }}</strong> {{ __('this Salon?') }}`;

            openDeleteModal(actionRoute, target, message);
        });


        function openDeleteModal(URL, target, message, actionBtnText = "{{ __('Remove') }}", method = "DELETE") {
            if (URL == "" || target == "") {
                return false;
            }

            if (message == "") {
                message = "{{ __('Are you sure to delete ?') }}";
            }
            var method = `<input type="hidden" name="_method" value="${method}">`;
            openModalByContent({
                    content: `<div class="card modal-alert border-0">
                        <div class="card-body">
                            <form method="POST" action="${URL}">
                                <input type="hidden" name="_token" value="${laravelCsrf()}">
                                ${method}
                                <div class="head mb-3">
                                    ${message}
                                    <input type="hidden" name="target" value="${target}">
                                </div>
                                <div class="foot d-flex align-items-center justify-content-between">
                                    <button type="button" class="modal-close btn btn--info">{{ __('Close') }}</button>
                                    <button type="submit" class="alert-submit-btn btn btn--danger btn-loading">${actionBtnText}</button>
                                </div>
                            </form>
                        </div>
                    </div>`,
                },

            );
        }

        function openModalByContent(data = {
            content: "",
            animation: "mfp-move-horizontal",
            size: "medium",
        }) {
            $.magnificPopup.open({
                removalDelay: 500,
                items: {
                    src: `<div class="white-popup mfp-with-anim ${data.size ?? "medium"}">${data.content}</div>`, // can be a HTML string, jQuery object, or CSS selector
                },
                callbacks: {
                    beforeOpen: function() {
                        this.st.mainClass = data.animation ?? "mfp-move-horizontal";
                    },
                    open: function() {
                        var modalCloseBtn = this.contentContainer.find(".modal-close");
                        $(modalCloseBtn).click(function() {
                            $.magnificPopup.close();
                        });
                    },
                },
                midClick: true,
            });
        }


        // Switcher
        switcherAjax("{{ route('vendors.parlour.list.status.update') }}");
    </script>
@endpush
