@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Staff'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],

    ])
@endsection

@section('content')
    <div class="table-area mt-10">
        <div class="table-wrapper">
            <div class="d-flex justify-content-between">
                <div class="dashboard-btn-wrapper">
                    <div class="dashboard-btn">
                        <a href="{{ route('vendors.stuff.assign.stuff') }}" class="btn--base"><i
                                class="las la-plus me-1"></i>{{ __('Assign Staff') }}</a>
                    </div>
                </div>
                <div class="selon-add-btn pb-20">
                    <a href="{{ setRoute('vendors.stuff.create') }}" class="btn--base"><i class="las la-plus"></i>
                        {{ __('Add Staff') }}</a>
                </div>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th></th>
                            <th>{{ __('Name') }}</th>
                            <th>{{ __('Address') }}</th>
                            <th>{{ __('Mobile') }}</th>
                            <th>{{ __('Salon') }}</th>
                            <th>{{ __('Action') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($stuff ?? [] as $index => $item)
                            <tr data-item="{{ json_encode($item) }}" class="text-light">
                                <td>
                                    <ul class="user-list">
                                        <li> <img class="avatar" src="{{ get_image($item->image, 'stuff-profile') }}"
                                                alt="client"></li>
                                    </ul>
                                </td>
                                <td>{{ $item->stuff_name }}</td>
                                <td>{{ $item->address }}</td>
                                <td>{{ $item->mobile }}</td>
                                <td>
                                    @if (!empty($item->parlour->name))
                                        <a href="{{ route('vendors.stuff.parlour.details', ['id' => $item->parlour->id]) }}"
                                            class="text-decoration-underline">
                                            {{ $item->parlour->name }}
                                        </a>
                                    @else
                                        {{ __('Not Assign') }}
                                    @endif
                                </td>

                                <td>
                                    <div class="btn-group" role="group">
                                        <button class="btn btn--base edit-modal-button"><i
                                                class="las la-pencil-alt"></i></button>
                                        <button class="btn btn--danger delete-btn"><i
                                                class="las la-trash-alt"></i></button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <td colspan="7">
                                <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                                    {{ __('No Record Found!') }}
                                </div>
                            </td>
                        @endforelse
                        {{ get_paginate($stuff) }}
                    </tbody>
                </table>
            </div>
        </div>
        {{ get_paginate($stuff) }}
    </div>

    {{-- stuff Update --}}
    <div id="stuff-update" class="mfp-hide large">
        <div class="modal-data">
            <div class="modal-header px-0">
                <h5 class="modal-title">{{ __('Update Staff') }}</h5>
            </div>
            <div class="modal-form-data">
                <form class="modal-form" method="POST" action="{{ setRoute('vendors.stuff.update') }}"
                    enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="target" value="{{ old('target') }}">

                    <div class="row mb-10-none mt-3">
                        <div class="row justify-content-center">
                            <div class="col-xl-4 col-lg-4 form-group mb-5">
                                @include('admin.components.form.input-file', [
                                    'label' => __('Image'),
                                    'name' => 'image',
                                    'class' => 'file-holder',
                                    'old_files_path'    => files_asset_path("stuff-profile"),
                                    'old_files' => old('image'),
                                    'attribute' => 'data-height=130',
                                ])
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 form-group">
                            @include('admin.components.form.input', [
                                'label' => __('Name') . '*',
                                'name' => 'stuff_name_edit',
                                'placeholder' => __('Write Name') . '...',
                                'value' => old('name'),
                            ])
                        </div>
                        <div class="col-xl-6 col-lg-6 form-group">
                            @include('admin.components.form.input', [
                                'label' => __('Address') . '*',
                                'name' => 'address_edit',
                                'placeholder' => __('Write Address') . '...',
                                'value' => old('address'),
                            ])
                        </div>
                        <div class="col-xl-6 col-lg-6 form-group">
                            @include('admin.components.form.input', [
                                'label' => __('Mobile') . '*',
                                'name' => 'mobile_edit',
                                'placeholder' => __('Write Mobile') . '...',
                                'value' => old('mobile'),
                            ])
                        </div>


                        <div class="col-xl-6 col-lg-6 form-group" id="show_parlour">
                            <label>{{ __('Select Salon') }}*</label>
                            <select class="form--control select2-basic" name="parlour_list_id">
                                <option disabled selected>{{ __('Select Salon') }}</option>
                                @foreach ($parlour as $item)
                                    <option value="{{ $item->id }}">
                                        {{ $item->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>


                        <div class="col-xl-12 col-lg-12 form-group d-flex align-items-center justify-content-between mt-4">
                            <button type="button" class="btn btn--danger modal-close">{{ __('Cancel') }}</button>
                            <button type="submit" class="btn btn--base">{{ __('Update') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        openModalWhenError("stuff-update", "#stuff-update");
        $(".edit-modal-button").click(function() {
            $('#show_parlour').hide();
            var oldData = JSON.parse($(this).parents("tr").attr("data-item"));
            var editModal = $("#stuff-update");
            editModal.find("form").first().find("input[name=target]").val(oldData.id);
            editModal.find("input[name=stuff_name_edit]").val(oldData.stuff_name);
            editModal.find("input[name=address_edit]").val(oldData.address);
            editModal.find("input[name=mobile_edit]").val(oldData.mobile);
            editModal.find("input[name=image]").attr("data-preview-name",oldData.image);
            fileHolderPreviewReInit("#stuff-update input[name=image]");
            var dropdown = editModal.find("select[name=parlour_list_id]");
            dropdown.val(oldData.parlour_list_id);
            if (oldData.status == 2) {
                $('#show_parlour').show();
            }
            openModalBySelector("#stuff-update");
        });

        $('.delete-btn').click(function() {
            var oldData = JSON.parse($(this).closest('[data-item]').attr('data-item')); // Corrected selector
            var actionRoute = "{{ setRoute('vendors.stuff.delete') }}";
            var target = oldData.id;

            var message =
                `{{ __('Are you sure to') }} <strong>{{ __('delete') }}</strong> {{ __('this Staff?') }}`;

            openDeleteModal(actionRoute, target, message);
        });


        function openDeleteModal(URL, target, message, actionBtnText = "{{ __('Remove') }}", method = "DELETE") {
            if (URL == "" || target == "") {
                return false;
            }

            if (message == "") {
                message = "{{ __('Are you sure to delete ?') }}";
            }
            var method = `<input type="hidden" name="_method" value="${method}">`;
            openModalByContent({
                    content: `<div class="card modal-alert border-0">
                    <div class="card-body">
                        <form method="POST" action="${URL}">
                            <input type="hidden" name="_token" value="${laravelCsrf()}">
                            ${method}
                            <div class="head mb-3">
                                ${message}
                                <input type="hidden" name="target" value="${target}">
                            </div>
                            <div class="foot d-flex align-items-center justify-content-between">
                                <button type="button" class="modal-close btn btn--info">{{ __('Close') }}</button>
                                <button type="submit" class="alert-submit-btn btn btn--danger btn-loading">${actionBtnText}</button>
                            </div>
                        </form>
                    </div>
                </div>`,
                },

            );
        }

        function openModalByContent(data = {
            content: "",
            animation: "mfp-move-horizontal",
            size: "medium",
        }) {
            $.magnificPopup.open({
                removalDelay: 500,
                items: {
                    src: `<div class="white-popup mfp-with-anim ${data.size ?? "medium"}">${data.content}</div>`, // can be a HTML string, jQuery object, or CSS selector
                },
                callbacks: {
                    beforeOpen: function() {
                        this.st.mainClass = data.animation ?? "mfp-move-horizontal";
                    },
                    open: function() {
                        var modalCloseBtn = this.contentContainer.find(".modal-close");
                        $(modalCloseBtn).click(function() {
                            $.magnificPopup.close();
                        });
                    },
                },
                midClick: true,
            });
        }
    </script>
@endpush
