<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\IndexController;
use App\Http\Controllers\Frontend\ParlourBookingController;

Route::name('frontend.')->group(function () {
    Route::controller(IndexController::class)->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('about', 'about')->name('about');
        Route::get('find-parlour', 'findParlour')->name('find.parlour');
        Route::get('services', 'services')->name('services');
        Route::get('contact', 'contact')->name('contact');
        Route::post("contact-request", 'contactRequest')->name("contact.request");
        Route::get('blog', 'blog')->name('blog');
        Route::get('home/vendor', 'vendor')->name('vendor');
        Route::get('blog-details/{slug}', 'blogDetails')->name('blog.details');
        Route::get('blog-category/{slug}', 'blogCategory')->name('blog.category');
        Route::post("subscribe", "subscribe")->name("subscribe");
        Route::post("contact/message/send", "contactMessageSend")->name("contact.message.send");
        Route::get('link/{slug}', 'link')->name('link');
        Route::post('languages/switch', 'languageSwitch')->name('languages.switch');
        Route::get('search/parlour','searchParlour')->name('parlour.search');
        Route::get('change/{lang?}','changeLanguage')->name('lang');
        Route::get("manager", "manager")->name("manager");
    });



    //parlour booking
    Route::controller(ParlourBookingController::class)->name('get.service.')->group(function () {
        Route::get('get-service/{slug}', 'getService')->name('index');
    });

    //Parlour Booking
    Route::controller(ParlourBookingController::class)->name('parlour.booking.')->group(function () {
        Route::post('store', 'store')->name('store');
        Route::get('preview/{slug}', 'preview')->name('preview')->middleware('auth');;
        Route::post('confirm/{slug}', 'confirm')->name('confirm');
        Route::post('get-schedule', 'getSchedule')->name('get.schedule');
        Route::post('/booking/delete', 'deleteBooking')->name('delete');

        Route::get('success/response/{gateway}','success')->name('payment.success');
        Route::get("cancel/response/{gateway}",'cancel')->name('payment.cancel');
        Route::post("callback/response/{gateway}",'callback')->name('payment.callback')->withoutMiddleware(['web','auth','verification.guard','user.google.two.factor']);

        // POST Route For Unauthenticated Request
        Route::post('success/response/{gateway}', 'postSuccess')->name('payment.success')->withoutMiddleware(['auth','verification.guard','user.google.two.factor']);
        Route::post('cancel/response/{gateway}', 'postCancel')->name('payment.cancel')->withoutMiddleware(['auth','verification.guard','user.google.two.factor']);

        // redirect with HTML form route
        Route::get('redirect/form/{gateway}', 'redirectUsingHTMLForm')->name('payment.redirect.form')->withoutMiddleware(['auth','verification.guard','user.google.two.factor']);

        //redirect with Btn Pay
        Route::get('redirect/btn/checkout/{gateway}', 'redirectBtnPay')->name('payment.btn.pay')->withoutMiddleware(['auth','verification.guard','user.google.two.factor']);

        Route::get('paystack/pay/callback',[ParlourBookingController::class,'paystackPayCallBack'])->name('paystack.pay.callback');

        // authorize payment
        Route::get('authorize-card-info/{identifier}','authorizeCardInfo')->name('authorize.card.info');
        Route::post('authorize-payment-submit/{identifier}','authorizePaymentSubmit')->name('authorize.payment.submit');


    });
});
