<?php

use App\Http\Controllers\Manager\AssignStuffController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Manager\DashboardController;
use App\Http\Controllers\Manager\MyParlourController;
use App\Http\Controllers\Manager\ProfileController;
use App\Http\Controllers\Manager\BookingRequestController;


Route::prefix("manager")->name("manager.")->group(function() {

    //dashboard
    Route::controller(DashboardController::class)->group(function(){
        Route::get('dashboard', 'index')->name('dashboard');
        Route::post('logout', 'logout')->name('logout');
    });

     //booking request
     Route::controller(BookingRequestController::class)->name('booking.request.')->group(function(){
        Route::get('booking/request','index')->name('index');
        Route::post('status/update/{trx_id}','statusUpdate')->name('status.update');
        Route::post('remarks/{id}','remarkAdd')->name('remarks');
    });

      //Stuff assign
      Route::controller(AssignStuffController::class)->name('assign.stuff.')->group(function(){
        Route::get('stuff','index')->name('index');
        Route::get('assign/stuff','create')->name('create');
        Route::get('get/stuff','getStuff')->name('get.stuff');
        Route::post('store','store')->name('store.submit');
        Route::put('status/update','statusUpdate')->name('status.update');
        Route::delete('delete', 'delete')->name('delete');
        Route::get('stuff/details/{stuff_id}', 'details')->name('details');
    });

      //booking request
      Route::controller(MyParlourController::class)->name('my.parlour.')->group(function(){
        Route::get('details/{id}','details')->name('details');
    });

    Route::controller(ProfileController::class)->prefix("profile")->name("profile.")->group(function(){
        Route::get('/','index')->name('index');
        Route::put('password/update','passwordUpdate')->name('password.update')->middleware('app.mode');
        Route::put('update','update')->name('update')->middleware('app.mode');
        Route::post('delete-account/{id}','delete')->name('delete')->middleware('app.mode');
    });

});

