<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('Add Money Logs'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="table-area">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title"><?php echo e($page_title); ?></h5>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('TRX ID')); ?></th>
                            <th><?php echo e(__('Full Name')); ?></th>
                            <th><?php echo e(__('Email')); ?></th>
                            <th><?php echo e(__('Phone')); ?></th>
                            <th><?php echo e(__('Amount')); ?></th>
                            <th><?php echo e(__('Gateway')); ?></th>
                            <th><?php echo e(__('rating')); ?></th>
                            <th><?php echo e(__('reviews')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Time')); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($item->trx_id); ?></td>
                                <td><?php echo e($item->user->fullname); ?></td>
                                <td><?php echo e($item->user->email); ?></td>
                                <td><?php echo e($item->user->mobile ?? 'N/A'); ?></td>
                                <td><?php echo e(get_amount($item->price)); ?></td>
                                <td><span class="text--info"><?php echo e($item->gateway_currency->name ?? $item->type); ?></span></td>
                                <td>
                                    <?php if($item->review == null): ?>
                                        <p><?php echo e(__('No review given')); ?></p>
                                    <?php else: ?>
                                        <div class="star-rating-display">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= $item->review): ?>
                                                    <span class="star-filled">★</span>
                                                <?php else: ?>
                                                    <span class="star-empty">☆</span>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                            <span class="rating-value">(<?php echo e($item->review); ?>/5)</span>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo e($item->comment ?? 'No comment given'); ?>

                                </td>
                                <td>
                                    <span
                                        class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                                </td>
                                <td><?php echo e($item->created_at->format('d-m-y h:i:s A')); ?></td>
                                <td>
                                    <?php if($item->status == 2): ?>
                                        <a href="<?php echo e(route('admin.booking.log.status.update', ['trxId' => $item->trx_id, 'status' => 1])); ?>"
                                            class="btn btn-success">
                                            <?php echo e(__('Accept')); ?>

                                        </a>
                                        <a href="<?php echo e(route('admin.booking.log.status.update', ['trxId' => $item->trx_id, 'status' => 3])); ?>"
                                            class="btn btn-danger">
                                            <?php echo e(__('Reject')); ?>

                                        </a>
                                    <?php else: ?>
                                        <span
                                            class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo $__env->make('admin.components.alerts.empty', ['colspan' => 11], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e(get_paginate($transactions)); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_project\salonhub\resources\views/admin/sections/booking-log/index.blade.php ENDPATH**/ ?>