<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('user.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Find Salon'),
                'url' => setRoute('user.profile.index'),
            ],
        ],
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- banner-searching -->
    <section class="find-parlour-section">
        <?php echo $__env->make('frontend.section.banner-search', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </section>
    <!-- serching data -->
    <section class="parlour-list-area ptb-80">
        <div class="container">
            <div class="row justify-content-center mb-20-none">
                <?php $__currentLoopData = $parlour_lists ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-md-6 col-sm-10 mb-20">
                        <div class="parlor-item">
                            <div class="parlor-img">
                                <img src="<?php echo e(get_image($item->image, 'site-section')); ?>" alt="img">
                            </div>
                            <div class="parlor-details">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h3 class="title"><?php echo e($item->name ?? ''); ?></h3>
                                    <?php if(auth()->check()): ?>
                                        <button class="favorite-btn" data-id="<?php echo e($item->id); ?>">
                                            <?php
                                                $fav_parlour_id = $item->favorites->first()->parlour_id ?? '';
                                            ?>
                                            <i
                                                class="fas fa-heart <?php echo e($fav_parlour_id == $item->id ? 'text-danger' : 'text-secondary'); ?>"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                                <p><?php echo e($item->manager_name ?? ''); ?></p>
                                <p><?php echo e($item->experience ?? ''); ?> <?php echo e(__('Year Experience')); ?></p>
                                <p><?php echo e($item->address ?? ''); ?></p>
                            </div>
                            <div class="booking-btn pt-2">
                                <a href="<?php echo e(setRoute('frontend.get.service.index', $item->slug)); ?>"
                                    class="btn--base w-100"><?php echo e(__('Get Service')); ?></a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php echo e(get_paginate($parlour_lists)); ?>

        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_project\salonhub\resources\views/user/sections/find-parlour/index.blade.php ENDPATH**/ ?>