<?php
    $app_local      = get_default_language_code();
    $default        = App\Constants\LanguageConst::NOT_REMOVABLE;
    $slug           = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::BLOG_SECTION);
    $blog           = App\Models\Admin\SiteSections::getData($slug)->first();
?>
<!-- blog section -->


<section class="blog-section ptb-80">
    <div class="container">
        <div class="blog-title">
            <div class="row">
                <div class="col-lg-7">
                    <h4 class="title text--base pb-20"><?php echo e($blog->value->language->$app_local->title ?? $blog->value->language->$default->title ?? ""); ?></h4>
                    <h2 class="title pb-20"><?php echo e($blog->value->language->$app_local->heading ?? $blog->value->language->$default->heading ?? ""); ?></h2>
                    <p><?php echo e($blog->value->language->$app_local->sub_heading ?? $blog->value->language->$default->sub_heading ?? ""); ?></p>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <?php $__currentLoopData = $blogs ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6 pb-20">
                    <a href="<?php echo e(setRoute('frontend.blog.details',$item->slug)); ?>">
                        <div class="blog-area">
                            <div class="blog-img">
                                <img src="<?php echo e(get_image($item->data->image ?? '','site-section')); ?>" alt="img">
                            </div>
                            <div class="blog-content">
                                <h3 class="content-title"><?php echo e(Str::words($item->data->language->$app_local->title ?? $item->data->language->$default->title ?? "","5","...")); ?></h3>
                                <p><?php echo Str::words($item->data->language->$app_local->description ?? $item->data->language->$default->description ?? '','10','...'); ?></p>
                            </div>
                            <div class="blog-btn">
                                <a href="<?php echo e(setRoute('frontend.blog.details',$item->slug)); ?>" class="btn--base w-100"><?php echo e(__("Blog Details")); ?></a>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php echo e(get_paginate($blogs)); ?>

    </div>
</section>



<?php $__env->startPush("script"); ?>

<?php $__env->stopPush(); ?>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/frontend/section/blog.blade.php ENDPATH**/ ?>