<!DOCTYPE html>
<html lang="<?php echo e(get_default_language_code()); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <?php
        $current_url = URL::current();
    ?>
    <?php if($current_url == setRoute('frontend.index')): ?>
        <title><?php echo e(__($basic_settings->vendor_site_name) ?? ''); ?> - <?php echo e(__($basic_settings->vendor_site_title) ?? ''); ?></title>
    <?php else: ?>
        <title><?php echo e(__($basic_settings->vendor_site_name) ?? ''); ?> - <?php echo e(__($page_title) ?? ''); ?></title>
    <?php endif; ?>

    <?php echo $__env->make('partials.header-asset', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldPushContent('css'); ?>
    <?php
        $vendorPrimaryColor = @$basic_settings->vendor_base_color ?? '#7A3DDD';
        $vendorSecondaryColor = @$basic_settings->vendor_secondary_color ?? '#D860EC';
    ?>

    <style>
        :root {
            --primary-color: <?php echo e($vendorPrimaryColor); ?>;
            --secondary-color: <?php echo e($vendorSecondaryColor); ?>;
        }
    </style>
</head>

<body class="<?php echo e(get_default_language_dir()); ?>">

    <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start body overlay
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
         <div id="body-overlay" class="body-overlay"></div>
    <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        End body overlay
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

    <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Dashboard
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
    <div class="page-wrapper bg-overlay-base bg_img"
        data-background="<?php echo e(asset('public/frontend/images/element/banner-bg.jpg')); ?>">

        <?php echo $__env->make('vendor.partials.side-nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="main-wrapper">
            <div class="main-body-wrapper">
                <?php echo $__env->make('vendor.partials.top-nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="body-wrapper">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
    </div>
    <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Dashboard
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->


    <?php echo $__env->make('partials.footer-asset', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php echo $__env->yieldPushContent('script'); ?>


    <?php
        $errorName = '';
    ?>
    <?php if($errors->any()): ?>
        <?php
            $error = (object) $errors;
            $msg = $error->default;
            $messageNames = $msg->keys();
            $errorName = $messageNames[0];
        ?>
    <?php endif; ?>
    <script>
        var error = "<?php echo e($errorName); ?>";
        if (
            error == 'firstname' ||
            error == 'agree' ||
            error == 'register_password' ||
            error == 'register_email' ||
            error == 'lastname'
        ) {
            $('.register-btn').addClass('active');
            $('#login').addClass('d-none');
            $('.login-btn').removeClass('active');
            $('#register').removeClass('d-none');
        }
    </script>

    <script>
        var fileHolderAfterLoad = {};
    </script>

    <script src="https://appdevs.cloud/cdn/fileholder/v1.0/js/fileholder-script.js" type="module"></script>
    <script type="module">
        import {
            fileHolderSettings
        } from "https://appdevs.cloud/cdn/fileholder/v1.0/js/fileholder-settings.js";
        import {
            previewFunctions
        } from "https://appdevs.cloud/cdn/fileholder/v1.0/js/fileholder-script.js";

        var inputFields = document.querySelector(".file-holder");
        fileHolderAfterLoad.previewReInit = function(inputFields) {
            previewFunctions.previewReInit(inputFields)
        };

        fileHolderSettings.urls.uploadUrl = "<?php echo e(setRoute('fileholder.upload')); ?>";
        fileHolderSettings.urls.removeUrl = "<?php echo e(setRoute('fileholder.remove')); ?>";
    </script>

    <script>
        function fileHolderPreviewReInit(selector) {
            var inputField = document.querySelector(selector);
            fileHolderAfterLoad.previewReInit(inputField);
        }
    </script>

</body>

</html>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/vendor/layouts/master.blade.php ENDPATH**/ ?>