<?php
    $app_local = get_default_language_code();
    $default = App\Constants\LanguageConst::NOT_REMOVABLE;

    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::VENDOR_REQUIREMENTS_SECTION);
    $requirements = App\Models\Admin\SiteSections::getData($slug)->first();

?>

<!-- Vendor Requirements -->
    <section class="vendor-requirements pb-80">
        <div class="container">
            <div class="required-title mb-30">
                <div class="row">
                    <div class="col-xl-8 col-lg-10">
                        <h4 class="title text--base pb-20">
                            <?php echo e($requirements->value->language->$app_local->title ?? ($requirements->value->language->$default->title ?? '')); ?>

                        </h4>
                        <h2 class="title">
                            <?php echo e($requirements->value->language->$app_local->heading ?? ($requirements->value->language->$default->heading ?? '')); ?>

                        </h2>
                    </div>
                </div>
            </div>
            <div class="row mb-20-none">
                <?php $__currentLoopData = $requirements->value->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-lg-6 mb-20">
                        <div class="required-content">
                            <h3 class="title">
                                <i class="<?php echo e($value->icon ?? ''); ?>"></i>
                                <?php echo e($value->language->$app_local->title ?? ($value->language->$default->title ?? '')); ?>

                            </h3>
                            <?php $__currentLoopData = $value->detailsItem ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <ul class="requirements-list">
                                    <li><?php echo e($value->language->$app_local->details ?? ($value->language->$default->details ?? '')); ?>

                                    </li>
                                </ul>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/frontend/section/vendor-requirements-section.blade.php ENDPATH**/ ?>