<div class="sidebar">
    <div class="sidebar-inner">
        <div class="sidebar-menu-wrapper">
            <div class="sidebar-logo">
                <a href="<?php echo e(setRoute('frontend.index')); ?>" class="sidebar-main-logo">
                    <img src="<?php echo e(get_logo($basic_settings)); ?>" data-white_img="<?php echo e(get_logo($basic_settings, 'dark')); ?>"
                        data-dark_img="<?php echo e(get_logo($basic_settings)); ?>" alt="logo">
                </a>
                <button class="sidebar-menu-bar">
                    <i class="fas fa-exchange-alt"></i>
                </button>
            </div>
            <ul class="sidebar-menu">
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('user.dashboard')); ?>">
                        <i class="menu-icon las la-home"></i>
                        <span class="menu-title"><?php echo e(__('Dashboard')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('user.find.parlour')); ?>">
                        <i class="menu-icon las la-map-marker-alt"></i>
                        <span class="menu-title"><?php echo e(__('Find Salon')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('user.my.booking.index')); ?>">
                        <i class="menu-icon las la-calendar-check"></i>
                        <span class="menu-title"><?php echo e(__('My Bookings')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('user.favorite.salon.index')); ?>">
                        <i class="menu-icon las la-heart"></i>
                        <span class="menu-title"><?php echo e(__('Favorite Salon')); ?></span>
                    </a>

                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('user.security.google.2fa')); ?>">
                        <i class="menu-icon las la-lock"></i>
                        <span class="menu-title"><?php echo e(__('Google 2FA')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="javascript:void(0)" class="logout-btn">
                        <i class="menu-icon las la-sign-out-alt"></i>
                        <span class="menu-title"><?php echo e(__('Logout')); ?></span>
                    </a>
                </li>

            </ul>
        </div>
        <div class="sidebar-doc-box bg_img"
            data-background="<?php echo e(asset('public/frontend/images/element/sidebar.webp')); ?>">
            <div class="sidebar-doc-icon">
                <i class="las la-headphones-alt"></i>
            </div>
            <div class="sidebar-doc-content">
                <h4 class="title"><?php echo e(__('Need Help')); ?>?</h4>
                <p><?php echo e(__('Please check our docs')); ?></p>
                <div class="sidebar-doc-btn">
                    <a href="<?php echo e(setRoute('user.support.ticket.index')); ?>"
                        class="btn--base w-100"><?php echo e(__('Get Support')); ?></a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        $(".active-deactive-btn").click(function() {
            var actionRoute = "<?php echo e(setRoute('user.security.google.2fa.status.update')); ?>";
            var target = 1;
            var btnText = $(this).text();
            var message =
                `Are you sure to <strong>${btnText}</strong> 2 factor authentication (Powered by google)?`;
            openAlertModal(actionRoute, target, message, btnText, "POST");
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/user/partials/side-nav.blade.php ENDPATH**/ ?>