<table class="custom-table transaction-search-table">
    <thead>
        <tr>
            <th></th>
            <th><?php echo e(__('TRX ID')); ?></th>
            <th><?php echo e(__('Full Name')); ?></th>
            <th><?php echo e(__('Email')); ?></th>
            <th><?php echo e(__('Username')); ?></th>
            <th><?php echo e(__('Amount')); ?></th>
            <th><?php echo e(__('Gateway')); ?></th>
            <th><?php echo e(__('Status')); ?></th>
            <th><?php echo e(__('Time')); ?></th>
            <th></th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $transactions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <?php
                    $currency = App\Models\Admin\Currency::where('code',$item->request_currency)->first();
                    $request_precision = $basic_settings->fiat_precision_value ?? 2;
                    if ($currency && $currency->type == 'CRYPTO') {
                        $request_precision = $basic_settings->crypto_precision_value ?? 8;
                    }
                ?>
                <td>
                    <ul class="user-list">
                        <li><img src="<?php echo e(get_image($item->creator->image ?? '', 'user-profile')); ?>"
                                alt="user"></li>
                    </ul>
                </td>
                <td><?php echo e($item->trx_id ?? 'N/A'); ?></td>
                <td><?php echo e($item->vendor->fullname ?? 'N/A'); ?></td>
                <td><?php echo e($item->vendor->email ?? 'N/A'); ?></td>
                <td><?php echo e($item->vendor->username ?? 'N/A'); ?></td>
                <td><?php echo e(get_amount($item->request_amount ?? 0, $item->request_currency ?? '', $request_precision)); ?>

                </td>
                <td><span class="text--info"><?php echo e($item->gateway_currency->gateway->name ?? 'N/A'); ?></span>
                </td>
                <td>
                    <span
                        class="<?php echo e($item->stringStatus->class ?? ''); ?>"><?php echo e(__($item->stringStatus->value) ?? 'N/A'); ?></span>
                </td>
                <td><?php echo e($item->created_at ? $item->created_at->format('d-m-y h:i:s A') : 'N/A'); ?></td>
                <td>
                    <?php if($item->status == 1): ?>
                        <button type="button" class="btn btn--base bg--success"><i
                                class="las la-check-circle"></i></button>
                    <?php elseif($item->status == 4): ?>
                        <button type="button" class="btn btn--base bg--danger"><i
                                class="las la-times-circle"></i></button>
                    <?php endif; ?>
                    <?php echo $__env->make('admin.components.link.custom', [
                        'href' => setRoute('admin.money.out.details', $item->id ?? ''),
                        'class' => 'btn btn--base modal-btn',
                        'icon' => 'las la-expand',
                        'permission' => 'admin.money.out.details',
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <?php echo $__env->make('admin.components.alerts.empty', ['colspan' => 11], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    </tbody>
</table>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/admin/components/data-table/money-out-table.blade.php ENDPATH**/ ?>