<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Salon List'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="selon-add-btn pb-20">
        <a href="<?php echo e(setRoute('vendors.parlour.list.create')); ?>" class="btn--base"><i class="las la-plus"></i>
            <?php echo e(__('Add Salon')); ?></a>
    </div>
    <div class="my-salon parlour-list-area">
        <div class="row justify-content-center mb-20-none">

            <?php $__empty_1 = true; $__currentLoopData = $parlour_lists ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                
                <?php if($item->status != 3): ?>
                    <div data-item="<?php echo e(json_encode($item)); ?>" class="col-xl-4 col-lg-4 col-md-6 col-sm-12 mb-20">
                        <div class="parlor-item">
                            <div class="parlor-img">

                                <div class="">
                                    <img src="<?php echo e(get_image($item->image ?? '', 'site-section') ?? ''); ?>"
                                        class="img-fluid rounded  object-fit-cover" alt="img" height="500px"
                                        width="500px">
                                </div>


                                <div class="salon-control-btn">
                                    <?php echo $__env->make('frontend.components.form.switcher', [
                                        'name' => 'status',
                                        'value' => $item->active_status,
                                        'options' => [__('Active') => 1, __('Freeze') => 0],
                                        'onload' => true,
                                        'data_target' => $item->id,
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                            <div class="parlor-details">
                                <h3 class="title"><?php echo e($item->name ?? ''); ?>

                                </h3>
                                <h3>
                                    <?php

                                        $salon_related_booking = App\Models\ParlourBooking::where(
                                            'status',
                                            global_const()::STATUSSUCCESS,
                                        )
                                            ->where('parlour_id', $item->id)
                                            ->where('vendor_id', auth()->user()->id)
                                            // ->with('parlour')
                                            // dd($salon_with_rating);
                                            ->sum('review');

                                        
                                        $salon_booking_count = App\Models\ParlourBooking::where(
                                            'status',
                                            global_const()::STATUSSUCCESS,
                                        )
                                            ->where('parlour_id', $item->id)
                                            ->where('vendor_id', auth()->user()->id)
                                            ->with('parlour')
                                            ->count();
                                        $salon_average_ratings =
                                            $salon_booking_count > 0 ? $salon_related_booking / $salon_booking_count : 0;
                               
                                    ?>

                                    <?php if($salon_average_ratings == null): ?>
                                        <p><?php echo e(__('No review given')); ?></p>
                                    <?php else: ?>
                                        <div class="star-rating-display">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= $salon_average_ratings): ?>
                                                    <span class="star-filled">★</span>
                                                <?php else: ?>
                                                    <span class="star-empty">☆</span>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                            <span class="rating-value">(<?php echo e($salon_average_ratings); ?>/5)</span>
                                        </div>
                                    <?php endif; ?>
                                </h3>
                                <p> <?php echo e(__('Salon Name')); ?> : <?php echo e($item->name ?? ''); ?> </p>
                                <p> <?php echo e(__('Manager Name')); ?> :
                                    <?php echo e(($item->manager->firstname ?? '') . ' ' . ($item->manager->lastname ?? '') ?? 'Not Assigned'); ?>

                                </p>
                                <p><?php echo e(__('Experience')); ?> : <?php echo e($item->experience ?? ''); ?></p>
                                <p> <?php echo e(__('Address')); ?> : <?php echo e($item->address ?? ''); ?></p>
                                
                                <div class="control-btn pt-2 mb-10-none d-flex justify-content-between">
                                    <button type="button" class="delate-btn mb-10 delete-btn"><?php echo e(__('Delete')); ?></button>
                                    <button type="button" class="edit-btn mb-10"
                                        onclick="window.location.href='<?php echo e(setRoute('vendors.parlour.list.edit', $item->slug)); ?>'">
                                        <?php echo e(__('Edit')); ?>

                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div data-item="<?php echo e(json_encode($item)); ?>" class="col-xl-4 col-lg-4 col-md-6 col-sm-12 mb-20">
                        <div class="parlor-item">
                            <div class="parlor-img">
                                <img src="<?php echo e(get_image($item->image ?? '', 'site-section') ?? ''); ?>" alt="img">
                            </div>
                            <div class="parlor-details">
                                <h3 class="title"><?php echo e(__('Rejected By Admin')); ?></h3>
                                <p> <?php echo e(__('Salon Name')); ?> : <?php echo e($item->name ?? ''); ?></p>
                                <p> <?php echo e(__('Status')); ?> : <span
                                        class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                                </p>
                                <p> <?php echo e(__('Reject Reason')); ?> : <?php echo e($item->remarks ?? ''); ?></p>
                                <div class="control-btn pt-2 mb-10-none justify-content-sm-between">
                                    <button type="button" class="delate-btn mb-10 delete-btn"><?php echo e(__('Delete')); ?></button>
                                    <button type="button" class="edit-btn mb-10"
                                        onclick="window.location.href='<?php echo e(setRoute('vendors.parlour.list.edit', $item->slug)); ?>'">
                                        <?php echo e(__('Edit')); ?>

                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <td colspan="7">
                    <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                        <?php echo e(__('No Record Found!')); ?>

                    </div>
                </td>
            <?php endif; ?>

            <?php echo e(get_paginate($parlour_lists)); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        $('.delete-btn').click(function() {
            var oldData = JSON.parse($(this).closest('[data-item]').attr('data-item')); // Corrected selector
            var actionRoute = "<?php echo e(setRoute('vendors.parlour.list.delete')); ?>";
            var target = oldData.id;
            var message =
                `<?php echo e(__('Are you sure to')); ?> <strong><?php echo e(__('delete')); ?></strong> <?php echo e(__('this Salon?')); ?>`;

            openDeleteModal(actionRoute, target, message);
        });


        function openDeleteModal(URL, target, message, actionBtnText = "<?php echo e(__('Remove')); ?>", method = "DELETE") {
            if (URL == "" || target == "") {
                return false;
            }

            if (message == "") {
                message = "<?php echo e(__('Are you sure to delete ?')); ?>";
            }
            var method = `<input type="hidden" name="_method" value="${method}">`;
            openModalByContent({
                    content: `<div class="card modal-alert border-0">
                        <div class="card-body">
                            <form method="POST" action="${URL}">
                                <input type="hidden" name="_token" value="${laravelCsrf()}">
                                ${method}
                                <div class="head mb-3">
                                    ${message}
                                    <input type="hidden" name="target" value="${target}">
                                </div>
                                <div class="foot d-flex align-items-center justify-content-between">
                                    <button type="button" class="modal-close btn btn--info"><?php echo e(__('Close')); ?></button>
                                    <button type="submit" class="alert-submit-btn btn btn--danger btn-loading">${actionBtnText}</button>
                                </div>
                            </form>
                        </div>
                    </div>`,
                },

            );
        }

        function openModalByContent(data = {
            content: "",
            animation: "mfp-move-horizontal",
            size: "medium",
        }) {
            $.magnificPopup.open({
                removalDelay: 500,
                items: {
                    src: `<div class="white-popup mfp-with-anim ${data.size ?? "medium"}">${data.content}</div>`, // can be a HTML string, jQuery object, or CSS selector
                },
                callbacks: {
                    beforeOpen: function() {
                        this.st.mainClass = data.animation ?? "mfp-move-horizontal";
                    },
                    open: function() {
                        var modalCloseBtn = this.contentContainer.find(".modal-close");
                        $(modalCloseBtn).click(function() {
                            $.magnificPopup.close();
                        });
                    },
                },
                midClick: true,
            });
        }


        // Switcher
        switcherAjax("<?php echo e(route('vendors.parlour.list.status.update')); ?>");
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('vendor.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/vendor/sections/parlour-list/index.blade.php ENDPATH**/ ?>