<?php
    $default = App\Constants\LanguageConst::NOT_REMOVABLE;
    $app_local = get_default_language_code();

    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::STATISTICS);
    $statistics = App\Models\Admin\SiteSections::getData($slug)->first();
?>
<!-- statistics-section -->
<div class="statistics-section ptb-80">
    <div class="container">
        <div class="row">
            <div class="col-xl-8 col-lg-10">
                <div class="statistics-title">
                    <h4 class="titte text--base pb-20">
                        <?php echo e($statistics->value->language->$app_local->title ?? ($statistics->value->language->$default->title ?? '')); ?>

                    </h4>
                    <h2 class="titte">
                        <?php echo e($statistics->value->language->$app_local->heading ?? ($statistics->value->language->$default->heading ?? '')); ?><i
                            class="las la-arrow-right"></i></h2>
                    <p><?php echo e($statistics->value->language->$app_local->sub_heading ?? ($statistics->value->language->$default->sub_heading ?? '')); ?>

                    </p>
                </div>
            </div>
        </div>
        <div class="row pt-40 mb-20-none">
            <?php $__currentLoopData = $statistics->value->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <div class="col-lg-3 col-md-6 col-sm-6 mb-20">
                    <div class="overview-details-area">
                        <div class="counter">
                            <div class="odo-area d-flex">
                                <?php
                                    $about_statistic = numeric_unit_converter(
                                        $value->language->$app_local->item_counter_value ?? '',
                                    );
                                ?>
                                <h5 class="odo-title odometer"
                                    data-odometer-final="<?php echo e($value->language->$app_local->item_counter_value); ?>">
                                </h5>
                                <h3 class="title"><?php echo e($about_statistic->unit); ?></h3>
                            </div>
                        </div>
                        <div class="overview-details">
                            <h4 class="title">
                                <?php echo e($value->language->$app_local->item_title ?? ($value->language->$default->item_title ?? '')); ?>

                            </h4>
                            <p><?php echo e($value->language->$app_local->item_description ?? ($value->language->$default->item_description ?? '')); ?>

                            </p>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub-web-v2.0.0\resources\views/frontend/section/statistics.blade.php ENDPATH**/ ?>