<!DOCTYPE html>
<html>
<head>
  <style>
    table {
      border-collapse: collapse;
      width: 100%;
      border-radius: 10px;
      box-shadow: rgba(0, 0, 0, 0.15) 0px 3px 7px 0px;
      border: 1px solid #eee;
      overflow: hidden;
      margin-bottom: 10px;
    }

    th, td {
      border: 1px solid #eee;
      padding: 8px;
      text-align: left;
    }

    th {
      background-color: #f2f2f2;
    }
    .mail-body{
      padding: 20px;
    }
  </style>
</head>
<body>


<div class="mail-body">
  <p>Dear <?php echo e($user->fullname); ?>,</p>

<p>We are writing to provide you with comprehensive details regarding your recent booking with the Booking number: <?php echo e($trx_id); ?>. Ensuring transparency and clarity in our communication is paramount, and we are pleased to share the following information with you:</p>

<h5>Salon Summary :</h5>
<table>
  <tr>
    <td>Salon Name</td>
    <td><?php echo e($parlour_data->name); ?></td>
    <td>Experience</td>
    <td><?php echo e($parlour_data->experience); ?></td>
  </tr>
  <tr>
    <td>Contact</td>
    <td><?php echo e($parlour_data->contact); ?></td>
    <td>Address</td>
    <td><?php echo e($parlour_data->address); ?></td>
  </tr>
</table>

<h5 style="padding-top: 20px;">Service & Schedule Information :</h5>

<table>
  <tr>
    <td>Service</td>
    <td><?php echo e(implode(', ',$user_data->service)); ?> </td>
    <td>Date</td>
    <td><?php echo e($user_data->date); ?> </td>
  </tr>
  <tr>
    <td>Time</td>
    <td><?php echo e($schedule_data->from_time); ?> - <?php echo e($schedule_data->to_time); ?></td>
    <td>Serial Number</td>
    <td><?php echo e($user_data->serial_number); ?> </td>
  </tr>
  <tr>
    <td>Status</td>
    <td>
      <?php if($user_data->status == global_const()::STATUSPENDING): ?>
          <span><?php echo e(__("Payment Pending")); ?></span>
      <?php elseif($user_data->status == global_const()::STATUSSUCCESS): ?>
          <span><?php echo e(__("Payment Successful")); ?></span>
      <?php else: ?>
          <span><?php echo e(__("Payment Not Confirm")); ?></span>
      <?php endif; ?>
    </td>
  </tr>
</table>

<h5 style="padding-top: 20px;">Payment Information :</h5>

<table>
  <tr>
    <td>Payment Method</td>
    <td><?php echo e($user_data->payment_method); ?> </td>
    <td>Service Price</td>
    <td><?php echo e(get_default_currency_symbol()); ?><?php echo e(getAmount($user_data->price)); ?> </td>
  </tr>
  <tr>
    <td>Fees & Charges</td>
    <td><?php echo e(get_default_currency_symbol()); ?><?php echo e(getAmount($user_data->total_charge)); ?></td>
    <td>Total Payable Price</td>
    <td><?php echo e(get_default_currency_symbol()); ?><?php echo e(getAmount($user_data->payable_price)); ?> </td>
  </tr>
</table>



<p style="padding-top: 20px;">We believe that providing these detailed breakdowns will give you a clear understanding of the remittance process and the associated particulars. Should you have any questions, require further assistance, or notice any discrepancies, please do not hesitate to reach out to our dedicated support team at <a href="<?php echo e($contact->value->email); ?>"><?php echo e($contact->value->email); ?></a> .</p>

<p>Your satisfaction and trust are of utmost importance to us, and we are committed to ensuring a seamless and secure remittance experience for you. Thank you for choosing us as your trusted partner for your financial needs.</p>
<p>Best Regards</p>
<p><?php echo e($basic_settings->site_name); ?></p>
</div>

</body>
</html>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/frontend/email/confirmation.blade.php ENDPATH**/ ?>