<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('Dashboard'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="dashboard-area">
        <div class="dashboard-item-area">
            <div class="row">
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__('Total Users')); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['total_user_count'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--success"><?php echo e(__('Active')); ?> <?php echo e($data['active_user']); ?></span>
                                    <span class="badge badge--info"><?php echo e(__('Unverified')); ?>

                                        <?php echo e($data['unverified_user']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart6" data-percent="<?php echo e($data['user_percent']); ?>">
                                    <span><?php echo e(round($data['user_percent'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__('Total Salon')); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['total_parlour_count'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__('Active')); ?>

                                        <?php echo e($data['active_parlour']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__('Inactive')); ?>

                                        <?php echo e($data['pending_parlour']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart7" data-percent="<?php echo e($data['parlour_percent']); ?>">
                                    <span><?php echo e(round($data['parlour_percent'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__('Total Bookings')); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['total_booking_count'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__('Confirmed')); ?>

                                        <?php echo e($data['confirm_booking']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__('Pending')); ?>

                                        <?php echo e($data['pending_booking']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart8" data-percent="<?php echo e($data['booking_percent']); ?>">
                                    <span><?php echo e(round($data['booking_percent'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__('Total Blog Category')); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['total_category_count'])); ?>

                                    </h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__('Active')); ?>

                                        <?php echo e($data['active_category']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__('Inactive')); ?>

                                        <?php echo e($data['inactive_category']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart11" data-percent="<?php echo e($data['category_percent']); ?>">
                                    <span><?php echo e(round($data['category_percent'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__('Total Blogs')); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInKNotation($data['total_blog_count'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__('Active')); ?> <?php echo e($data['active_blog']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__('Inactive')); ?>

                                        <?php echo e($data['inactive_blog']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart12" data-percent="<?php echo e($data['booking_percent']); ?>">
                                    <span><?php echo e(round($data['booking_percent'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__('Total Support Ticket')); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(formatNumberInkNotation($data['total_ticket_count'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__('Active')); ?>

                                        <?php echo e(formatNumberInkNotation($data['active_ticket'])); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__('Pending')); ?>

                                        <?php echo e(formatNumberInkNotation($data['pending_ticket'])); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart10" data-percent="<?php echo e($data['percent_ticket']); ?>">
                                    <span><?php echo e(round($data['percent_ticket'])); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__('Total Booking Money')); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count">
                                        <?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount($data['total_money'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__('This Month')); ?>

                                        <?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount($data['this_month_money'])); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__('Last Month')); ?>

                                        <?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount($data['last_month_money'])); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__('Total Profit')); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count">
                                        <?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount($data['total_charges'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__('This Month')); ?>

                                        <?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount($data['this_month_charge'])); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__('Last Month')); ?>

                                        <?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount($data['last_month_charge'])); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="chart-area mt-15">
        <div class="row mb-15-none">
            <div class="col-xxl-6 col-xl-6 col-lg-6 mb-15">
                <div class="chart-wrapper">
                    <div class="chart-area-header">
                        <h5 class="title"><?php echo e(__('Booking Analytics')); ?></h5>
                    </div>
                    <div class="chart-container">
                        <div id="chart1" data-chart_one_data="<?php echo e(json_encode($data['chart_one_data'])); ?>"
                            data-month_day="<?php echo e(json_encode($data['month_day'])); ?>" class="sales-chart"></div>
                    </div>
                </div>
            </div>
            <div class="col-xxxl-6 col-xxl-3 col-xl-6 col-lg-6 mb-15">
                <div class="chart-wrapper">
                    <div class="chart-area-header">
                        <h5 class="title"><?php echo e(__('User Analytics')); ?></h5>
                    </div>
                    <div class="chart-container">
                        <div id="chart4" class="balance-chart"
                            data-user_chart_data="<?php echo e(json_encode($data['user_chart_data'])); ?>"></div>
                    </div>
                    <div class="chart-area-footer">
                        <div class="chart-btn">
                            <a href="<?php echo e(setRoute('admin.users.index')); ?>"
                                class="btn--base w-100"><?php echo e(__('View User')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="table-area mt-15">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title"><?php echo e(__('Latest Bookings')); ?></h5>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Booking ID')); ?></th>
                            <th><?php echo e(__('Salon Name')); ?></th>
                            <th><?php echo e(__('Price')); ?></th>
                            <th><?php echo e(__('P. Method')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $booking_data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($item->trx_id ?? ''); ?></td>
                                <td><?php echo e($item->parlour->name ?? ''); ?></td>
                                <td><?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount($item->price)); ?></td>
                                <td><?php echo e($item->payment_method ?? ''); ?></td>
                                <td>
                                    <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                                </td>
                                <td>
                                    <a href="<?php echo e(setRoute('admin.booking.log.details', $item->trx_id)); ?>"
                                        class="btn btn--base btn--primary"><i class="las la-info-circle"></i></a>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo $__env->make('admin.components.alerts.empty', ['colspan' => 6], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        // apex-chart
        var chart1 = $('#chart1');
        var chart_one_data = chart1.data('chart_one_data');
        var month_day = chart1.data('month_day');
        var options = {
            series: [{
                name: "<?php echo e(__('Pending')); ?>",
                color: "#5A5278",
                data: chart_one_data.pending_data
            }, {
                name: "<?php echo e(__('Completed')); ?>",
                color: "#6F6593",
                data: chart_one_data.complete_data
            }, ],
            chart: {
                type: 'bar',
                height: 350,
                stacked: true,
                toolbar: {
                    show: false
                },
                zoom: {
                    enabled: true
                }
            },
            responsive: [{
                breakpoint: 480,
                options: {
                    legend: {
                        position: 'bottom',
                        offsetX: -10,
                        offsetY: 0
                    }
                }
            }],
            plotOptions: {
                bar: {
                    horizontal: false,
                    borderRadius: 10
                },
            },
            xaxis: {
                type: 'datetime',
                categories: month_day,

            },
            legend: {
                position: 'bottom',
                offsetX: 40
            },
            fill: {
                opacity: 1
            }
        };

        var chart = new ApexCharts(document.querySelector("#chart1"), options);
        chart.render();

        var chart4 = $('#chart4');
        var user_chart_data = chart4.data('user_chart_data');
        var options = {
            series: user_chart_data,
            chart: {
                width: 350,
                type: 'pie'
            },
            colors: ['#5A5278', '#6F6593', '#8075AA', '#A192D9'],
            labels: ['<?php echo e(__('Active')); ?>', '<?php echo e(__('Unverified')); ?>', '<?php echo e(__('Banned')); ?>', '<?php echo e(__('All')); ?>'],
            responsive: [{
                breakpoint: 1480,
                options: {
                    chart: {
                        width: 280
                    },
                    legend: {
                        position: 'bottom'
                    }
                },
                breakpoint: 1199,
                options: {
                    chart: {
                        width: 380
                    },
                    legend: {
                        position: 'bottom'
                    }
                },
                breakpoint: 575,
                options: {
                    chart: {
                        width: 280
                    },
                    legend: {
                        position: 'bottom'
                    }
                }
            }],
            legend: {
                position: 'bottom'
            },
        };

        var chart = new ApexCharts(document.querySelector("#chart4"), options);
        chart.render();
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_project\salonhub\resources\views/admin/sections/dashboard/index.blade.php ENDPATH**/ ?>