<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Staff'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],

    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="table-area mt-10">
        <div class="table-wrapper">
            <div class="d-flex justify-content-between">
                <div class="dashboard-btn-wrapper">
                    <div class="dashboard-btn">
                        <a href="<?php echo e(route('vendors.stuff.assign.stuff')); ?>" class="btn--base"><i
                                class="las la-plus me-1"></i><?php echo e(__('Assign Staff')); ?></a>
                    </div>
                </div>
                <div class="selon-add-btn pb-20">
                    <a href="<?php echo e(setRoute('vendors.stuff.create')); ?>" class="btn--base"><i class="las la-plus"></i>
                        <?php echo e(__('Add Staff')); ?></a>
                </div>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th></th>
                            <th><?php echo e(__('Name')); ?></th>
                            <th><?php echo e(__('Address')); ?></th>
                            <th><?php echo e(__('Mobile')); ?></th>
                            <th><?php echo e(__('Salon')); ?></th>
                            <th><?php echo e(__('Action')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $stuff ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr data-item="<?php echo e(json_encode($item)); ?>" class="text-light">
                                <td>
                                    <ul class="user-list">
                                        <li> <img class="avatar" src="<?php echo e(get_image($item->image, 'stuff-profile')); ?>"
                                                alt="client"></li>
                                    </ul>
                                </td>
                                <td><?php echo e($item->stuff_name); ?></td>
                                <td><?php echo e($item->address); ?></td>
                                <td><?php echo e($item->mobile); ?></td>
                                <td>
                                    <?php if(!empty($item->parlour->name)): ?>
                                        <a href="<?php echo e(route('vendors.stuff.parlour.details', ['id' => $item->parlour->id])); ?>"
                                            class="text-decoration-underline">
                                            <?php echo e($item->parlour->name); ?>

                                        </a>
                                    <?php else: ?>
                                        <?php echo e(__('Not Assign')); ?>

                                    <?php endif; ?>
                                </td>

                                <td>
                                    <div class="btn-group" role="group">
                                        <button class="btn btn--base edit-modal-button"><i
                                                class="las la-pencil-alt"></i></button>
                                        <button class="btn btn--danger delete-btn"><i
                                                class="las la-trash-alt"></i></button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <td colspan="7">
                                <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                                    <?php echo e(__('No Record Found!')); ?>

                                </div>
                            </td>
                        <?php endif; ?>
                        <?php echo e(get_paginate($stuff)); ?>

                    </tbody>
                </table>
            </div>
        </div>
        <?php echo e(get_paginate($stuff)); ?>

    </div>

    
    <div id="stuff-update" class="mfp-hide large">
        <div class="modal-data">
            <div class="modal-header px-0">
                <h5 class="modal-title"><?php echo e(__('Update Staff')); ?></h5>
            </div>
            <div class="modal-form-data">
                <form class="modal-form" method="POST" action="<?php echo e(setRoute('vendors.stuff.update')); ?>"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="target" value="<?php echo e(old('target')); ?>">

                    <div class="row mb-10-none mt-3">
                        <div class="row justify-content-center">
                            <div class="col-xl-4 col-lg-4 form-group mb-5">
                                <?php echo $__env->make('admin.components.form.input-file', [
                                    'label' => __('Image'),
                                    'name' => 'image',
                                    'class' => 'file-holder',
                                    'old_files_path'    => files_asset_path("stuff-profile"),
                                    'old_files' => old('image'),
                                    'attribute' => 'data-height=130',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 form-group">
                            <?php echo $__env->make('admin.components.form.input', [
                                'label' => __('Name') . '*',
                                'name' => 'stuff_name_edit',
                                'placeholder' => __('Write Name') . '...',
                                'value' => old('name'),
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-6 col-lg-6 form-group">
                            <?php echo $__env->make('admin.components.form.input', [
                                'label' => __('Address') . '*',
                                'name' => 'address_edit',
                                'placeholder' => __('Write Address') . '...',
                                'value' => old('address'),
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-6 col-lg-6 form-group">
                            <?php echo $__env->make('admin.components.form.input', [
                                'label' => __('Mobile') . '*',
                                'name' => 'mobile_edit',
                                'placeholder' => __('Write Mobile') . '...',
                                'value' => old('mobile'),
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>


                        <div class="col-xl-6 col-lg-6 form-group" id="show_parlour">
                            <label><?php echo e(__('Select Salon')); ?>*</label>
                            <select class="form--control select2-basic" name="parlour_list_id">
                                <option disabled selected><?php echo e(__('Select Salon')); ?></option>
                                <?php $__currentLoopData = $parlour; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>">
                                        <?php echo e($item->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>


                        <div class="col-xl-12 col-lg-12 form-group d-flex align-items-center justify-content-between mt-4">
                            <button type="button" class="btn btn--danger modal-close"><?php echo e(__('Cancel')); ?></button>
                            <button type="submit" class="btn btn--base"><?php echo e(__('Update')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        openModalWhenError("stuff-update", "#stuff-update");
        $(".edit-modal-button").click(function() {
            $('#show_parlour').hide();
            var oldData = JSON.parse($(this).parents("tr").attr("data-item"));
            var editModal = $("#stuff-update");
            editModal.find("form").first().find("input[name=target]").val(oldData.id);
            editModal.find("input[name=stuff_name_edit]").val(oldData.stuff_name);
            editModal.find("input[name=address_edit]").val(oldData.address);
            editModal.find("input[name=mobile_edit]").val(oldData.mobile);
            editModal.find("input[name=image]").attr("data-preview-name",oldData.image);
            fileHolderPreviewReInit("#stuff-update input[name=image]");
            var dropdown = editModal.find("select[name=parlour_list_id]");
            dropdown.val(oldData.parlour_list_id);
            if (oldData.status == 2) {
                $('#show_parlour').show();
            }
            openModalBySelector("#stuff-update");
        });

        $('.delete-btn').click(function() {
            var oldData = JSON.parse($(this).closest('[data-item]').attr('data-item')); // Corrected selector
            var actionRoute = "<?php echo e(setRoute('vendors.stuff.delete')); ?>";
            var target = oldData.id;

            var message =
                `<?php echo e(__('Are you sure to')); ?> <strong><?php echo e(__('delete')); ?></strong> <?php echo e(__('this Staff?')); ?>`;

            openDeleteModal(actionRoute, target, message);
        });


        function openDeleteModal(URL, target, message, actionBtnText = "<?php echo e(__('Remove')); ?>", method = "DELETE") {
            if (URL == "" || target == "") {
                return false;
            }

            if (message == "") {
                message = "<?php echo e(__('Are you sure to delete ?')); ?>";
            }
            var method = `<input type="hidden" name="_method" value="${method}">`;
            openModalByContent({
                    content: `<div class="card modal-alert border-0">
                    <div class="card-body">
                        <form method="POST" action="${URL}">
                            <input type="hidden" name="_token" value="${laravelCsrf()}">
                            ${method}
                            <div class="head mb-3">
                                ${message}
                                <input type="hidden" name="target" value="${target}">
                            </div>
                            <div class="foot d-flex align-items-center justify-content-between">
                                <button type="button" class="modal-close btn btn--info"><?php echo e(__('Close')); ?></button>
                                <button type="submit" class="alert-submit-btn btn btn--danger btn-loading">${actionBtnText}</button>
                            </div>
                        </form>
                    </div>
                </div>`,
                },

            );
        }

        function openModalByContent(data = {
            content: "",
            animation: "mfp-move-horizontal",
            size: "medium",
        }) {
            $.magnificPopup.open({
                removalDelay: 500,
                items: {
                    src: `<div class="white-popup mfp-with-anim ${data.size ?? "medium"}">${data.content}</div>`, // can be a HTML string, jQuery object, or CSS selector
                },
                callbacks: {
                    beforeOpen: function() {
                        this.st.mainClass = data.animation ?? "mfp-move-horizontal";
                    },
                    open: function() {
                        var modalCloseBtn = this.contentContainer.find(".modal-close");
                        $(modalCloseBtn).click(function() {
                            $.magnificPopup.close();
                        });
                    },
                },
                midClick: true,
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('vendor.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/vendor/sections/stuff-section/index.blade.php ENDPATH**/ ?>