<?php
    $app_local = get_default_language_code();
    $default = App\Constants\LanguageConst::NOT_REMOVABLE;
    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::SERVICES_SECTION);
    $services = App\Models\Admin\SiteSections::getData($slug)->first();
?>

    <!-- service -->
    <section class="service-section ptb-80">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <h4 class="title text--base pb-20"> <?php echo e($services->value->language->$app_local->title ?? ($services->value->language->$default->title ?? '')); ?></h4>
                    <h2 class="title"><?php echo e($services->value->language->$app_local->heading ?? ($services->value->language->$default->heading ?? '')); ?></h2>
                    <p><?php echo e($services->value->language->$app_local->sub_heading ?? ($services->value->language->$default->sub_heading ?? '')); ?></p>
                </div>
            </div>
            <div class="row pt-40 mb-30-none">
                    <?php
                        $service_items= $services->value->items ?? [];
                    ?>
                <?php $__currentLoopData = $service_items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-6 mb-30">
                    <div class="service-area">
                        <div class="service-icon">
                            <img src="<?php echo e(get_image($item->image, 'site-section') ?? ''); ?>" alt="icon">
                        </div>
                        <div class="service-type">
                            <h3 class="title"><?php echo e($item->language->$app_local->title ?? ($services->language->$default->title ?? '')); ?></h3>
                            <p><?php echo e($item->language->$app_local->description ?? ($services->language->$default->description ?? '')); ?></p>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/frontend/section/services-section.blade.php ENDPATH**/ ?>