<?php
    $default_currency_code = get_default_currency_code();
?>

<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <section class="appointment-preview pt-150 pb-60">
        <div class="container">
            <form action="<?php echo e(setRoute('frontend.parlour.booking.confirm', $booking->slug)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row justify-content-center mb-30-none">
                    <div class="col-xl-8 col-lg-8 col-md-12 mb-30">
                        <input type="hidden" name="amount" value="<?php echo e(@$booking->data->payable_price); ?>">
                        <input type="hidden" id="selected_payment_method" name="gateway_currency"
                                                               value="">
                        <div class="booking-area">
                            <div class="content pt-0">
                                <h3 class="title"><i class="fas fa-info-circle text--base mb-20"></i> <?php echo e(__("Appointment Preview")); ?>

                                </h3>
                                <div class="list-wrapper">

                                    <div class="preview-area">
                                        <div class="preview-item">
                                            <p><?php echo e(__('Salon Name')); ?> :</p>
                                        </div>
                                        <div class="preview-details">
                                            <p><?php echo e(@$booking->parlour->name ?? ''); ?></p>
                                        </div>
                                    </div>
                                    <div class="preview-area">
                                        <div class="preview-item">
                                            <p><?php echo e(__('Service Type')); ?> :</p>
                                        </div>
                                        <div class="preview-details">
                                            <p><?php echo e(implode(', ', @$booking->data->service)); ?></p>
                                        </div>
                                    </div>
                                    <div class="preview-area">
                                        <div class="preview-item">
                                            <p><?php echo e(__('Schedule')); ?> :</p>
                                        </div>
                                        <div class="preview-details">
                                            <p><?php echo e(@$booking->date ?? ''); ?> (<?php echo e($booking->schedule->from_time); ?> -
                                                <?php echo e($booking->schedule->to_time); ?>)</p>
                                        </div>
                                    </div>
                                    <div class="preview-area">
                                        <div class="preview-item">
                                            <p><?php echo e(__('Amount')); ?> :</p>
                                        </div>
                                        <div class="preview-details">
                                            <p><?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount(@$booking->data->price) ?? ''); ?>

                                            </p>
                                        </div>
                                    </div>
                                    <div class="preview-area">
                                        <div class="preview-item">
                                            <p><?php echo e(__('Fees & Charges')); ?> :</p>
                                        </div>
                                        <div class="preview-details">
                                            <p><?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount(@$booking->data->total_charge) ?? ''); ?>

                                            </p>
                                        </div>
                                    </div>
                                    <div class="preview-area">
                                        <div class="preview-item">
                                            <p><?php echo e(__('Total Payable Amount')); ?> :</p>
                                        </div>
                                        <div class="preview-details">
                                            <p><?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount(@$booking->data->payable_price) ?? ''); ?>

                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="payment-type pt-4">
                                    <div class="form-group">
                                        <h5 class="title"><?php echo e(__('Select Payment Method')); ?><span>*</span></h5>
                                        <div class="radio-wrapper pt-2" id="pg-view">
                                            <div class="radio-item">
                                                <input type="radio" id="level" class="hide-input"
                                                    value="<?php echo e(global_const()::CASH_PAYMENT); ?>" checked
                                                    name="payment_method">
                                                <label for="level"><img
                                                        src="<?php echo e(asset('public/frontend/images/icon/cashpay.webp')); ?>"
                                                        alt="icon"><?php echo e(__('Cash-Payment')); ?></label>
                                            </div>
                                            <?php $__currentLoopData = $payment_gateway; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="radio-item">
                                                    <input type="radio" id="level_<?php echo e($item->id); ?>" class="hide-input"
                                                        name="payment_method" value="<?php echo e($item->alias); ?>">
                                                    <label for="level_<?php echo e($item->id); ?>"><img
                                                            src="<?php echo e(get_image($item->gateway->image, 'payment-gateways')); ?>"
                                                            alt="icon"><?php echo e($item->gateway->name); ?>

                                                        <?php echo e($item->currency_code); ?></label>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="btn-area mt-30">
                                    <button type="submit" class="btn--base w-100"><?php echo e(__("Confirm Appointment")); ?> <i
                                            class="fas fa-check-circle ms-1"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            let countdownDuration = localStorage.getItem('countdownDuration');
            if (!countdownDuration) {
                countdownDuration = '<?php echo e(global_const()::BOOKING_EXP_SEC); ?>';
            }

            function updateCountdown() {
                countdownDuration--;

                if (countdownDuration >= 0) {
                    setTimeout(updateCountdown, 1000);
                    localStorage.setItem('countdownDuration', countdownDuration);
                } else {
                    deleteBooking();
                    localStorage.removeItem('countdownDuration');
                }
            }

            function deleteBooking() {
                $.ajax({
                    method: 'POST',
                    url: '<?php echo e(route('frontend.parlour.booking.delete')); ?>',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        bookingSlug: '<?php echo e($booking->slug); ?>'
                    },
                    success: function(response) {
                        if (response.success) {
                            window.location.href = '<?php echo e(route('frontend.find.parlour')); ?>';
                        } else {

                        }
                    }
                });
            }

            updateCountdown();
        });
    </script>

<script>
     $(document).ready(function() {
        $('input[name="payment_method"]').on('change', function() {
            // Get the selected radio button value
            var selectedValue = $(this).val();
            // Set the value to the hidden input field
            $('#selected_payment_method').val(selectedValue);
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/frontend/pages/parlour-booking/preview.blade.php ENDPATH**/ ?>