<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("Support Ticket")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.components.support-ticket.counter-card',['support_tickets' => $support_tickets], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="table-area mt-15">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title"><?php echo e(__("All Ticket")); ?></h5>
                <div class="action-btn-wrapper d-none">
                    <button class="btn--base table-header-action-btn outline"><?php echo e(__("Action")); ?> <i class="las la-angle-down"></i></button>
                    <ul class="action-btn-list">
                        <li><button class="btn btn--danger delete-btn"><?php echo e(__("Delete")); ?></button></li>
                    </ul>
                </div>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th>
                                <div class="d-flex align-items-center select-check-input">
                                    <input type="checkbox" name="select_all" id="select-all" >
                                    <label for="select-all" class="form-check-label mb-0"><?php echo e(__("Select All")); ?></label>
                                </div>
                            </th>
                            <th><?php echo e(__("Ticket ID")); ?></th>
                            <th><?php echo e(__("User")); ?> (<?php echo e(__("Username")); ?>)</th>
                            <th><?php echo e(__("Subject")); ?></th>
                            <th><?php echo e(__("Name")); ?></th>
                            <th><?php echo e(__("Email")); ?></th>
                            <th><?php echo e(__("Message")); ?></th>
                            <th><?php echo e(__("Status")); ?></th>
                            <th><?php echo e(__("Last Reply")); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $support_tickets ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr data-item="<?php echo e($item); ?>">
                                <td>
                                    <input type="checkbox" class="w-auto" id="ticket-<?php echo e($item->id); ?>" name="select_ticket[]" value="<?php echo e($item->id); ?>">
                                </td>
                                <td>#<?php echo e($item->token); ?></td>
                                <td>
                                    <?php echo e($item->user->username); ?>

                                </td>
                                <td>
                                    <?php if($item->status == support_ticket_const()::DEFAULT): ?>
                                        <span class="text--warning"><?php echo e($item->subject); ?></span>
                                    <?php elseif($item->status == support_ticket_const()::SOLVED): ?>
                                        <span class="text--success"><?php echo e($item->subject); ?></span>
                                    <?php elseif($item->status == support_ticket_const()::ACTIVE): ?>
                                        <span class="text--primary"><?php echo e($item->subject); ?></span>
                                    <?php elseif($item->status == support_ticket_const()::PENDING): ?>
                                        <span class="text--warning"><?php echo e($item->subject); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($item->name); ?></td>
                                <td><?php echo e($item->email); ?></td>
                                <td><?php echo e(Str::words($item->desc, 10, '...')); ?></td>
                                <td>
                                    <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e($item->stringStatus->value); ?></span>
                                </td>
                                <td>
                                    <?php if(count($item->conversations) > 0): ?>
                                        <?php echo e($item->conversations->last()->created_at->format("Y-m-d H:i A") ?? ""); ?></td>
                                    <?php endif; ?>
                                <td>
                                    <a href="<?php echo e(setRoute('admin.support.ticket.conversation',encrypt($item->id))); ?>" class="btn btn--base"><i class="las la-comment"></i></a>
                                    <?php echo $__env->make('admin.components.link.delete-default',[
                                        'href'          => "javascript:void(0)",
                                        'class'         => "delete-modal-button",
                                        'permission'    => "admin.support.ticket.delete",
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo $__env->make('admin.components.alerts.empty',['colspan' => 10], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    $('#select-all').on('change', function () {
        let isChecked = $(this).is(':checked');
        $('input[name="select_ticket[]"]').prop('checked', isChecked);

        toggleActionBtn();
    });

    $('input[name="select_ticket[]"]').on('change', function () {
        let total = $('input[name="select_ticket[]"]').length;
        let checked = $('input[name="select_ticket[]"]:checked').length;

        $('#select-all').prop('checked', total === checked);

        toggleActionBtn();
    });

    function toggleActionBtn() {
        let selectedCount = $('input[name="select_ticket[]"]:checked').length;
        
        if (selectedCount > 0) {
            console.log(123);
            $('.action-btn-wrapper').removeClass('d-none');
        } else {
            $('.action-btn-wrapper').addClass('d-none');
        }
    }

    $(document).on("click",".delete-btn",function(event) {
        const ids = $('input[name="select_ticket[]"]:checked').map(function () {
            return $(this).val();
        }).get();

        event.preventDefault();
        var actionRoute =  "<?php echo e(setRoute('admin.support.ticket.bulk.delete')); ?>";
        var ticket    = ids;
        var message     = `Are you sure you want to <strong>Delete</strong> all selected tickets?`;
        openDeleteModal(actionRoute,ticket,message,"Enable","POST");
    });

    $(".delete-modal-button").click(function(){
        var oldData = JSON.parse($(this).parents("tr").attr("data-item"));
        var actionRoute =  "<?php echo e(setRoute('admin.support.ticket.delete')); ?>";
        var target      = oldData.id;
        var message     = `Are you sure to delete <strong>Support Ticket</strong>?`;

        openDeleteModal(actionRoute,target,message);
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/admin/sections/support-ticket/index.blade.php ENDPATH**/ ?>