<?php $__env->startPush('css'); ?>
    <style>
        .fileholder {
            min-height: 374px !important;
        }

        .fileholder-files-view-wrp.accept-single-file .fileholder-single-file-view,
        .fileholder-files-view-wrp.fileholder-perview-single .fileholder-single-file-view {
            height: 330px !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('Salon Lists'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="table-area">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title"><?php echo e(__($page_title)); ?></h5>
                <div class="table-btn-area">
                    <?php echo $__env->make('admin.components.link.custom', [
                        'text' => __('Add Salon'),
                        'class' => 'btn btn--base',
                        'href' => setRoute('admin.parlour.list.create'),
                        'permission' => 'admin.parlour.list.create',
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th></th>
                            <th><?php echo e(__('Name')); ?></th>
                            <th><?php echo e(__('Experience')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Added By')); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $parlour_lists ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr data-item="<?php echo e($item); ?>">
                                <td>
                                    <ul class="user-list">
                                        <li><img src="<?php echo e(get_image($item->image ?? '', 'site-section') ?? ''); ?>"
                                                alt="" srcset=""></li>
                                    </ul>
                                </td>
                                <td><?php echo e($item->name ?? ''); ?></td>
                                <td><?php echo e($item->experience ?? ''); ?></td>
                                <td>
                                    <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                                </td>
                                <?php if($item->vendor_id == !null): ?>
                                    <td><?php echo e(__("Vendor")); ?></td>
                                <?php else: ?>
                                    <td><?php echo e(__("Admin")); ?></td>
                                <?php endif; ?>
                                <td>
                                    <a href="<?php echo e(setRoute('admin.parlour.list.details', $item->id)); ?>"
                                        class="btn btn--base btn--primary"><i class="las la-info-circle"></i></a>
                                    <button class="btn btn--base btn--danger delete-modal-button"><i
                                            class="las la-trash-alt"></i></button>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo $__env->make('admin.components.alerts.empty', ['colspan' => 5], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $('.delete-modal-button').click(function() {
            var oldData = JSON.parse($(this).parents("tr").attr("data-item"));
            var actionRoute = "<?php echo e(setRoute('admin.parlour.list.delete')); ?>"
            var target = oldData.id;
            var message =
                `<?php echo e(__('Are you sure to')); ?> <strong><?php echo e(__('delete')); ?></strong> <?php echo e(__('this Parlour?')); ?>`;

            openDeleteModal(actionRoute, target, message);
        });

        $(document).ready(function() {
            switcherAjax("<?php echo e(setRoute('admin.parlour.list.status.update')); ?>");
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/admin/sections/parlour-list/parlour-request.blade.php ENDPATH**/ ?>