<!DOCTYPE html>
<html lang="<?php echo e(get_default_language_code()); ?>">


<?php
    $cookie = App\Models\Admin\SiteSections::siteCookie();
    //cookies results
    $approval_status = request()->cookie('approval_status');
    $c_user_agent = request()->cookie('user_agent');
    $c_ip_address = request()->cookie('ip_address');
    $c_browser = request()->cookie('browser');
    $c_platform = request()->cookie('platform');
    //system informations
    $s_ipAddress = request()->ip();
    $s_location = geoip()->getLocation($s_ipAddress);
    $s_browser = Agent::browser();
    $s_platform = Agent::platform();
    $s_agent = request()->header('User-Agent');
?>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <?php
        $current_url = URL::current();
    ?>

    <?php if($current_url == setRoute('frontend.index')): ?>
        <title><?php echo e(__($basic_settings->site_name) ?? ''); ?> - <?php echo e(__($basic_settings->site_title) ?? ''); ?></title>
    <?php else: ?>
        <title><?php echo e(__($basic_settings->site_name) ?? ''); ?> - <?php echo e(__($page_title) ?? ''); ?></title>
    <?php endif; ?>

    <?php echo $__env->make('partials.header-asset', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldPushContent('css'); ?>
    <?php
        $primaryColor = @$basic_settings->base_color ?? '#7A3DDD';
        $secondaryColor = @$basic_settings->secondary_color ?? '#D860EC';

    ?>

    <style>
        :root {
            --primary-color: <?php echo e($primaryColor); ?>;
            --secondary-color: <?php echo e($secondaryColor); ?>;
        }
    </style>
</head>

<body class="<?php echo e(get_default_language_dir()); ?>">


    <?php echo $__env->make('frontend.partials.scroll-to-top', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('frontend.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start cookie
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
    <div class="cookie-main-wrapper">
        <div class="cookie-content">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                <path
                    d="M21.598 11.064a1.006 1.006 0 0 0-.854-.172A2.938 2.938 0 0 1 20 11c-1.654 0-3-1.346-3.003-2.937c.005-.034.016-.136.017-.17a.998.998 0 0 0-1.254-1.006A2.963 2.963 0 0 1 15 7c-1.654 0-3-1.346-3-3c0-.217.031-.444.099-.716a1 1 0 0 0-1.067-1.236A9.956 9.956 0 0 0 2 12c0 5.514 4.486 10 10 10s10-4.486 10-10c0-.049-.003-.097-.007-.16a1.004 1.004 0 0 0-.395-.776zM12 20c-4.411 0-8-3.589-8-8a7.962 7.962 0 0 1 6.006-7.75A5.006 5.006 0 0 0 15 9l.101-.001a5.007 5.007 0 0 0 4.837 4C19.444 16.941 16.073 20 12 20z" />
                <circle cx="12.5" cy="11.5" r="1.5" />
                <circle cx="8.5" cy="8.5" r="1.5" />
                <circle cx="7.5" cy="12.5" r="1.5" />
                <circle cx="15.5" cy="15.5" r="1.5" />
                <circle cx="10.5" cy="16.5" r="1.5" />
            </svg>

            <p class="text-white"><?php echo e(__(strip_tags($cookie->value->desc ?? ''))); ?> <a
                    href="<?php echo e(url('link/') . '/' . $cookie->value->link ?? ''); ?>"><?php echo e(__('Privacy Policy')); ?></a></p>
        </div>
        <div class="cookie-btn-area">
            <button class="cookie-btn"><?php echo e(__('Allow')); ?></button>
            <button class="cookie-btn-cross"><?php echo e(__('Decline')); ?></button>
        </div>
    </div>
    <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End cookie
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
    <?php echo $__env->make('frontend.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('partials.footer-asset', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('frontend.partials.extensions.tawk-to', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldPushContent('script'); ?>
    <?php
        $errorName = '';
    ?>
    <?php if($errors->any()): ?>
        <?php
            $error = (object) $errors;
            $msg = $error->default;
            $messageNames = $msg->keys();
            $errorName = $messageNames[0];
        ?>
    <?php endif; ?>
    <script>
        var error = "<?php echo e($errorName); ?>";
        if (
            error == 'firstname' ||
            error == 'agree' ||
            error == 'register_password' ||
            error == 'register_email' ||
            error == 'lastname'
        ) {
            $('.register-btn').addClass('active');
            $('#login').addClass('d-none');
            $('.login-btn').removeClass('active');
            $('#register').removeClass('d-none');
        }
    </script>

    <script>
        $(document).ready(function() {
            $('.favorite-btn').on('click', function() {
                const button = $(this);
                const parlour_id = button.data('id');
                const heartIcon = button.find('i');
                const isFavorited = heartIcon.hasClass('text-danger');

                // Determine the appropriate URL and method based on current favorite status
                const url = isFavorited ? '<?php echo e(route('user.favorite.salon.delete')); ?>' :
                    '<?php echo e(route('user.favorite.salon.store')); ?>';
                const method = isFavorited ? 'DELETE' : 'POST';

                $.ajax({
                    url: url,
                    type: method,
                    data: {
                        parlour_id: parlour_id,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function(response) {
                        if (isFavorited) {
                            throwMessage('success', ['Removed from Favorites']);
                            heartIcon.removeClass('text-danger').addClass('text-secondary');
                        } else {
                            throwMessage('success', ['Added to Favorites']);
                            heartIcon.removeClass('text-secondary').addClass('text-danger');
                        }
                    },
                    error: function(xhr) {
                        if (xhr.status === 409) {
                            throwMessage('error', ['Already exists in Watchlist!']);
                        } else {
                            throwMessage('error', ['Something went wrong!']);
                        }
                    }
                });
            });
        });
    </script>

    <script>
        var status = "<?php echo e(@$cookie->status); ?>";
        //cookies results
        var approval_status = "<?php echo e($approval_status); ?>";
        var c_user_agent = "<?php echo e($c_user_agent); ?>";
        var c_ip_address = "<?php echo e($c_ip_address); ?>";
        var c_browser = "<?php echo e($c_browser); ?>";
        var c_platform = "<?php echo e($c_platform); ?>";
        //system informations
        var s_ipAddress = "<?php echo e($s_ipAddress); ?>";
        var s_browser = "<?php echo e($s_browser); ?>";
        var s_platform = "<?php echo e($s_platform); ?>";
        var s_agent = "<?php echo e($s_agent); ?>";
        const pop = document.querySelector('.cookie-main-wrapper')
        if (status == 1) {
            if (approval_status == 'allow' || approval_status == 'decline' || c_user_agent === s_agent || c_ip_address ===
                s_ipAddress || c_browser === s_browser || c_platform === s_platform) {
                pop.style.bottom = "-300px";
            } else {
                window.onload = function() {
                    setTimeout(function() {
                        pop.style.bottom = "20px";
                    }, 2000)
                }
            }
        } else {
            pop.style.bottom = "-300px";
        }
        // })
    </script>
    <script>
        (function($) {
            "use strict";
            //Allow
            $('.cookie-btn').on('click', function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postData = {
                    type: "allow",
                };
                $.post('<?php echo e(route('global.set.cookie')); ?>', postData, function(response) {
                    throwMessage('success', [response]);
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                });
            });
            //Decline
            $('.cookie-btn-cross').on('click', function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postData = {
                    type: "decline",
                };
                $.post('<?php echo e(route('global.set.cookie')); ?>', postData, function(response) {
                    throwMessage('error', [response]);
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                });
            });
        })(jQuery)
    </script>



</body>


</html>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_project\salonhub\resources\views/frontend/layouts/master.blade.php ENDPATH**/ ?>