<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('user.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('user.dashboard'),
            ],
        ],
        'active' => __('Profile'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row mb-20-none">
        <div class="col-xl-6 col-lg-6 mb-20">
            <div class="custom-card mt-10">
                <div class="dashboard-header-wrapper">
                    <h4 class="title"><?php echo e(__('Profile Settings')); ?></h4>
                    <div class="account-delate">
                        <button class="btn--danger btn" data-bs-toggle="modal"
                            data-bs-target="#delateModal"><?php echo e(__('Delete Account')); ?></button>
                    </div>
                </div>
                <div class="card-body profile-body-wrapper">
                    <form class="card-form" method="POST" action="<?php echo e(setRoute('user.profile.update')); ?>"
                        enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="profile-settings-wrapper">
                            <div class="preview-thumb profile-wallpaper">
                                <div class="avatar-preview">
                                    <div class="profilePicPreview bg_img"
                                        data-background="<?php echo e(asset('public/frontend/images/element/profile-thumb.webp')); ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="profile-thumb-content">
                                <div class="preview-thumb profile-thumb">
                                    <div class="avatar-preview">
                                        <div class="profilePicPreview bg_img"
                                            data-background="<?php echo e(auth()->user()->userImage); ?>"></div>
                                    </div>
                                    <div class="avatar-edit">
                                        <input type='file' class="profilePicUpload" name="image" id="profilePicUpload2"
                                            accept=".png, .jpg, .jpeg, .webp, .svg" />
                                        <label for="profilePicUpload2"><i class="las la-upload"></i></label>
                                    </div>
                                </div>
                                <div class="profile-content">
                                    <h6 class="username"><?php echo e(auth()->user()->username); ?></h6>
                                    <ul class="user-info-list mt-md-2">
                                        <li><i class="las la-envelope"></i><?php echo e(auth()->user()->email); ?></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="profile-form-area">
                            <div class="row">
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <?php echo $__env->make('admin.components.form.input', [
                                        'label' => __('First Name') . '<span>*</span>',
                                        'name' => 'firstname',
                                        'placeholder' => 'Enter First Name...',
                                        'value' => old('firstname', auth()->user()->firstname),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <?php echo $__env->make('admin.components.form.input', [
                                        'label' => __('Last Name') . '<span>*</span>',
                                        'name' => 'lastname',
                                        'placeholder' => 'Enter Last Name...',
                                        'value' => old('lastname', auth()->user()->lastname),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__('Country')); ?></label>
                                    <select
                                        class="form--control select2-auto-tokenize  country-picker select2-basic country-select"
                                        data-placeholder="<?php echo e(__('Select Country')); ?>"
                                        data-old="<?php echo e(old('country', auth()->user()->address->country ?? '')); ?>"
                                        name="country"></select>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__('Phone')); ?></label>
                                    <div class="input-group">
                                        <div class="input-group-text phone-code">+<?php echo e(auth()->user()->mobile_code); ?></div>
                                        <input class="phone-code" type="hidden" name="phone_code"
                                            value="<?php echo e(auth()->user()->mobile_code); ?>" />
                                        <input type="text" class="form--control" placeholder="Enter Phone ..."
                                            name="phone" value="<?php echo e(old('phone', auth()->user()->mobile)); ?>">
                                    </div>
                                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <?php
                                        $old_state = old('state', auth()->user()->address->state ?? '');
                                    ?>
                                    <label><?php echo e(__('State')); ?></label>
                                    <select name="state" class="form--control select2-auto-tokenize state-select"
                                        data-placeholder="Select State" data-old="<?php echo e($old_state); ?>">
                                        <?php if($old_state): ?>
                                            <option value="<?php echo e($old_state); ?>" selected><?php echo e($old_state); ?></option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <?php
                                        $old_city = old('city', auth()->user()->address->city ?? '');
                                    ?>
                                    <label><?php echo e(__('City')); ?></label>
                                    <select name="city" class="form--control select2-auto-tokenize city-select"
                                        data-placeholder="Select City" data-old="<?php echo e($old_city); ?>">
                                        <?php if($old_city): ?>
                                            <option value="<?php echo e($old_city); ?>" selected><?php echo e($old_city); ?></option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <?php echo $__env->make('admin.components.form.input', [
                                        'label' => 'Zip Code',
                                        'name' => 'zip_code',
                                        'placeholder' => 'Enter Zip...',
                                        'value' => old('zip_code', auth()->user()->address->zip ?? ''),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <?php echo $__env->make('admin.components.form.input', [
                                        'label' => 'Address',
                                        'name' => 'address',
                                        'placeholder' => 'Enter Address...',
                                        'value' => old('address', auth()->user()->address->address ?? ''),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                            <div class="col-xl-12 col-lg-12">
                                <button type="submit" class="btn--base w-100"><?php echo e(__('Update')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-xl-6 col-lg-6 mb-20">
            <div class="custom-card mt-10">
                <div class="dashboard-header-wrapper">
                    <h4 class="title"><?php echo e(__('Change Password')); ?></h4>
                </div>
                <div class="card-body">
                    <form class="card-form" action="<?php echo e(setRoute('user.profile.password.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="row">
                            <div class="col-xl-12 col-lg-12 form-group">
                                <?php echo $__env->make('admin.components.form.input', [
                                    'label' => __('Current Password') . '<span>*</span>',
                                    'name' => 'current_password',
                                    'type' => 'password',
                                    'placeholder' => 'Enter Password...',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group">
                                <?php echo $__env->make('admin.components.form.input', [
                                    'label' => __('New Password') . '<span>*</span>',
                                    'name' => 'password',
                                    'type' => 'password',
                                    'placeholder' => 'Enter Password...',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group">
                                <?php echo $__env->make('admin.components.form.input', [
                                    'label' => __('Confirm Password') . '<span>*</span>',
                                    'name' => 'password_confirmation',
                                    'type' => 'password',
                                    'placeholder' => 'Enter Password...',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                        <div class="col-xl-12 col-lg-12">
                            <button type="submit" class="btn--base w-100"><?php echo e(__('Change')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('modal'); ?>
    <!-- Modal -->
    <div class="modal fade" id="delateModal" tabindex="-1" aria-labelledby="delateModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body">
                    <h4 class="title"><?php echo e(__('Are you sure to delete your account?')); ?></h4>
                    <p><?php echo e(__('If you do not think you will use')); ?> <span
                            class="text--base"><?php echo e($basic_settings->site_name); ?></span>
                        <?php echo e(__('again and like your account deleted. Keep in mind you will not be able to reactivate your account or retrieve any of the content or information you have added. If you would still like your account deleted, click “Confirm”.?')); ?>

                    </p>

                </div>
                <div class="modal-footer justify-content-between border-0">
                    <button type="button" class="btn--base bg-danger"
                        data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <form action="<?php echo e(setRoute('user.profile.delete', auth()->user()->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn--danger"><?php echo e(__('Confirm')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        getAllCountries("<?php echo e(setRoute('global.countries')); ?>");
        $(document).ready(function() {
            $("select[name=country]").change(function() {
                var phoneCode = $("select[name=country] :selected").attr("data-mobile-code");
                placePhoneCode(phoneCode);
            });

            countrySelect(".country-select", $(".country-select").siblings(".select2"));
            stateSelect(".state-select", $(".state-select").siblings(".select2"));
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/user/sections/profile/index.blade.php ENDPATH**/ ?>