<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('Web Settings'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="custom-card">
        <div class="card-header">
            <h6 class="title"><?php echo e(__('Basic Settings')); ?></h6>
        </div>
        <div class="card-body">
            <form class="card-form" method="POST" action="<?php echo e(setRoute('admin.web.settings.basic.settings.update')); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="row">
                    <div class="col-xl-3 col-lg-3 form-group">
                        <label><?php echo e(__('Site Base Color')); ?>*</label>
                        <div class="picker">
                            <input type="color" value="<?php echo e(old('base_color', $basic_settings->base_color)); ?>"
                                class="color color-picker">
                            <input type="text" autocomplete="off" spellcheck="false" class="color-input"
                                value="<?php echo e(old('base_color', $basic_settings->base_color)); ?>" name="base_color">
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 form-group">
                        <label><?php echo e(__('Site Secondary Color')); ?>*</label>
                        <div class="picker">
                            <input type="color" value="<?php echo e(old('secondary_color', $basic_settings->secondary_color)); ?>"
                                class="color color-picker">
                            <input type="text" autocomplete="off" spellcheck="false" class="color-input"
                                value="<?php echo e(old('secondary_color', $basic_settings->secondary_color)); ?>"
                                name="secondary_color">
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-3 form-group">
                        <label><?php echo e(__('Timezone')); ?>*</label>
                        <select name="timezone" class="form--control select2-auto-tokenize timezone-select"
                            data-old="<?php echo e(old('timezone', $basic_settings->timezone)); ?>">
                            <option selected disabled><?php echo e(__('Select Timezone')); ?></option>
                        </select>
                    </div>
                    <div class="col-xl-3 col-lg-3 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Minimum Staff'),
                            'type' => 'text',
                            'class' => 'form--control',
                            'placeholder' => __('Write Here') . '...',
                            'name' => 'min_stuff',
                            'value' => old('min_stuff', $basic_settings->min_stuff),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="col-xl-3 col-lg-3 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Minimum Charge Count'),
                            'type' => 'text',
                            'class' => 'form--control',
                            'placeholder' => __('Write Here') . '...',
                            'name' => 'minimum_charge_count',
                            'value' => old('minimum_charge_count', $basic_settings->minimum_charge_count),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="col-xl-3 col-lg-3 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Site Name'),
                            'label_after' => '*',
                            'class' => 'form--control',
                            'placeholder' => __('Write Here') . '...',
                            'name' => 'site_name',
                            'value' => old('site_name', $basic_settings->site_name),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-3 col-lg-3 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Site Title'),
                            'label_after' => '*',
                            'type' => 'text',
                            'class' => 'form--control',
                            'placeholder' => __('Write Here') . '...',
                            'name' => 'site_title',
                            'value' => old('site_title', $basic_settings->site_title),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-3 col-lg-3 form-group">
                        <label><?php echo e(__('OTP Expiration')); ?>*</label>
                        <div class="input-group">
                            <input type="number" class="form--control"
                                value="<?php echo e(old('otp_exp_seconds', $basic_settings->otp_exp_seconds)); ?>"
                                name="otp_exp_seconds">
                            <span class="input-group-text"><?php echo e(__('Seconds')); ?></span>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Web Version'),
                            'type' => 'text',
                            'class' => 'form--control',
                            'placeholder' => __('Write Here') . '...',
                            'name' => 'web_version',
                            'value' => old('web_version', $basic_settings->web_version),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
                <div class="col-xl-12 col-lg-12">
                    <?php echo $__env->make('admin.components.button.form-btn', [
                        'class' => 'w-100 btn-loading',
                        'text' => __('Update'),
                        'permission' => 'admin.web.settings.basic.settings.update',
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </form>
        </div>

        <div class="custom-card">
            <div class="card-header">
                <h6 class="title"><?php echo e(__("Basic Settings (Manager)")); ?></h6>
            </div>
            <div class="card-body">
                <form class="card-form" method="POST" action="<?php echo e(setRoute('admin.web.settings.basic.settings.update.manager')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field("PUT"); ?>
                    <div class="row">
                        <div class="col-xl-3 col-lg-3 form-group">
                            <label><?php echo e(__("Site Base Color")); ?>*</label>
                            <div class="picker">
                                <input type="color" value="<?php echo e(old('manager_base_color',$basic_settings->manager_base_color)); ?>" class="color color-picker">
                                <input type="text" autocomplete="off" spellcheck="false" class="color-input" value="<?php echo e(old('manager_base_color',$basic_settings->manager_base_color)); ?>" name="manager_base_color">
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-3 form-group">
                            <label><?php echo e(__("Site Secondary Color")); ?>*</label>
                            <div class="picker">
                                <input type="color" value="<?php echo e(old('manager_secondary_color',$basic_settings->manager_secondary_color)); ?>" class="color color-picker">
                                <input type="text" autocomplete="off" spellcheck="false" class="color-input" value="<?php echo e(old('manager_secondary_color',$basic_settings->manager_secondary_color)); ?>" name="manager_secondary_color">
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-3 form-group">
                            <?php echo $__env->make('admin.components.form.input',[
                                'label'         => __( "Site Name"),
                                'type'          => "text",
                                'class'         => "form--control",
                                'placeholder'   =>  __("Write Here.."),
                                'name'          => "manager_site_name",
                                'value'         => old('vendor_site_name',$basic_settings->manager_site_name),
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-3 col-lg-3 form-group">
                            <?php echo $__env->make('admin.components.form.input',[
                                'label'         => __( "Site Title"),
                                'type'          => "text",
                                'class'         => "form--control",
                                'placeholder'   =>  __("Write Here.."),
                                'name'          => "manager_site_title",
                                'value'         => old('manager_site_title',$basic_settings->manager_site_title),
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                    </div>
                    <div class="col-xl-12 col-lg-12">
                        <?php echo $__env->make('admin.components.button.form-btn',[
                            'class'         => "w-100 btn-loading",
                            'text'          => __("update"),
                            'permission'    => "admin.web.settings.basic.settings.update",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </form>
            </div>
        </div>

        <div class="custom-card">
            <div class="card-header">
                <h6 class="title"><?php echo e(__("Basic Settings (Vendor)")); ?></h6>
            </div>
            <div class="card-body">
                <form class="card-form" method="POST" action="<?php echo e(setRoute('admin.web.settings.basic.settings.update.vendor')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field("PUT"); ?>
                    <div class="row">
                        <div class="col-xl-3 col-lg-3 form-group">
                            <label><?php echo e(__("Site Base Color")); ?>*</label>
                            <div class="picker">
                                <input type="color" value="<?php echo e(old('vendor_base_color',$basic_settings->vendor_base_color)); ?>" class="color color-picker">
                                <input type="text" autocomplete="off" spellcheck="false" class="color-input" value="<?php echo e(old('vendor_base_color',$basic_settings->vendor_base_color)); ?>" name="vendor_base_color">
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-3 form-group">
                            <label><?php echo e(__("Site Secondary Color")); ?>*</label>
                            <div class="picker">
                                <input type="color" value="<?php echo e(old('vendor_secondary_color',$basic_settings->vendor_secondary_color)); ?>" class="color color-picker">
                                <input type="text" autocomplete="off" spellcheck="false" class="color-input" value="<?php echo e(old('vendor_secondary_color',$basic_settings->vendor_secondary_color)); ?>" name="vendor_secondary_color">
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-3 form-group">
                            <?php echo $__env->make('admin.components.form.input',[
                                'label'         => __( "Site Name"),
                                'type'          => "text",
                                'class'         => "form--control",
                                'placeholder'   =>  __("Write Here.."),
                                'name'          => "vendor_site_name",
                                'value'         => old('vendor_site_name',$basic_settings->vendor_site_name),
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-3 col-lg-3 form-group">
                            <?php echo $__env->make('admin.components.form.input',[
                                'label'         => __( "Site Title"),
                                'type'          => "text",
                                'class'         => "form--control",
                                'placeholder'   =>  __("Write Here.."),
                                'name'          => "vendor_site_title",
                                'value'         => old('vendor_site_title',$basic_settings->vendor_site_title),
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                    </div>
                    <div class="col-xl-12 col-lg-12">
                        <?php echo $__env->make('admin.components.button.form-btn',[
                            'class'         => "w-100 btn-loading",
                            'text'          => __("update"),
                            'permission'    => "admin.web.settings.basic.settings.update",
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </form>
            </div>
        </div>

    </div>
    <div class="custom-card mt-15">
        <div class="card-header">
            <h6 class="title"><?php echo e(__('Activation Settings')); ?></h6>
        </div>
        <div class="card-body">
            <div class="custom-inner-card mt-10 mb-10">
                <div class="card-inner-body">
                    <div class="row mb-10-none">
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher', [
                                'label' => __('User Registration'),
                                'name' => 'user_registration',
                                'value' => old('user_registration', $basic_settings->user_registration),
                                'options' => [__('Activated') => 1, __('Deactivated') => 0],
                                'onload' => true,
                                'permission' => 'admin.web.settings.basic.settings.activation.update',
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher', [
                                'label' => __('Secure Password'),
                                'name' => 'secure_password',
                                'value' => old('secure_password', $basic_settings->secure_password),
                                'options' => [__('Activated') => 1, __('Deactivated') => 0],
                                'onload' => true,
                                'permission' => 'admin.web.settings.basic.settings.activation.update',
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher', [
                                'label' => __('Agree Policy'),
                                'name' => 'agree_policy',
                                'value' => old('agree_policy', $basic_settings->agree_policy),
                                'options' => [__('Activated') => 1, __('Deactivated') => 0],
                                'onload' => true,
                                'permission' => 'admin.web.settings.basic.settings.activation.update',
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher', [
                                'label' => __('Force SSL'),
                                'name' => 'force_ssl',
                                'value' => old('force_ssl', $basic_settings->force_ssl),
                                'options' => [__('Activated') => 1, __('Deactivated') => 0],
                                'onload' => true,
                                'permission' => 'admin.web.settings.basic.settings.activation.update',
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher', [
                                'label' => __('Email Verification'),
                                'name' => 'email_verification',
                                'value' => old('email_verification', $basic_settings->email_verification),
                                'options' => [__('Activated') => 1, __('Deactivated') => 0],
                                'onload' => true,
                                'permission' => 'admin.web.settings.basic.settings.activation.update',
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher', [
                                'label' => __('Email Notification'),
                                'name' => 'email_notification',
                                'value' => old('email_notification', $basic_settings->email_notification),
                                'options' => [__('Activated') => 1, __('Deactivated') => 0],
                                'onload' => true,
                                'permission' => 'admin.web.settings.basic.settings.activation.update',
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher', [
                                'label' => __('Push Notification'),
                                'name' => 'push_notification',
                                'value' => old('push_notification', $basic_settings->push_notification),
                                'options' => [__('Activated') => 1, __('Deactivated') => 0],
                                'onload' => true,
                                'permission' => 'admin.web.settings.basic.settings.activation.update',
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="custom-card mt-15">
        <div class="card-header">
            <h6 class="title"><?php echo e(__('Activation Settings (Vendor)')); ?></h6>
        </div>
        <div class="card-body">
            <div class="custom-inner-card mt-10 mb-10">
                <div class="card-inner-body">
                    <div class="row mb-10-none">
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher', [
                                'label' => __('Vendor Registration'),
                                'name' => 'vendor_registration',
                                'value' => old('vendor_registration', $basic_settings->vendor_registration),
                                'options' => [__('Activated') => 1, __('Deactivated') => 0],
                                'onload' => true,
                                'permission' => 'admin.web.settings.basic.settings.activation.update',
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher', [
                                'label' => __('Secure Password'),
                                'name' => 'vendor_secure_password',
                                'value' => old('vendor_secure_password', $basic_settings->vendor_secure_password),
                                'options' => [__('Activated') => 1, __('Deactivated') => 0],
                                'onload' => true,
                                'permission' => 'admin.web.settings.basic.settings.activation.update',
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher', [
                                'label' => __('Agree Policy'),
                                'name' => 'vendor_agree_policy',
                                'value' => old('vendor_agree_policy', $basic_settings->vendor_agree_policy),
                                'options' => [__('Activated') => 1, __('Deactivated') => 0],
                                'onload' => true,
                                'permission' => 'admin.web.settings.basic.settings.activation.update',
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher', [
                                'label' => __('Email Verification'),
                                'name' => 'vendor_email_verification',
                                'value' => old(
                                    'vendor_email_verification',
                                    $basic_settings->vendor_email_verification),
                                'options' => [__('Activated') => 1, __('Deactivated') => 0],
                                'onload' => true,
                                'permission' => 'admin.web.settings.basic.settings.activation.update',
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher', [
                                'label' => __('Email Notification'),
                                'name' => 'vendor_email_notification',
                                'value' => old(
                                    'vendor_email_notification',
                                    $basic_settings->vendor_email_notification),
                                'options' => [__('Activated') => 1, __('Deactivated') => 0],
                                'onload' => true,
                                'permission' => 'admin.web.settings.basic.settings.activation.update',
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher', [
                                'label' => __('Push Notification'),
                                'name' => 'vendor_push_notification',
                                'value' => old(
                                    'vendor_push_notification',
                                    $basic_settings->vendor_push_notification),
                                'options' => [__('Activated') => 1, __('Deactivated') => 0],
                                'onload' => true,
                                'permission' => 'admin.web.settings.basic.settings.activation.update',
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6 form-group">
                            <?php echo $__env->make('admin.components.form.switcher',[
                                'label'         => __('KYC Verification'),
                                'name'          => 'kyc_verification',
                                'value'         => old('kyc_verification',$basic_settings->vendor_kyc_verification),
                                'options'       => [__('Activated') => 1,__('Deactivated') => 0],
                                'onload'        => true,
                                'permission'    => "admin.web.settings.basic.settings.activation.update",
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            $(".color-picker").on("input", function() {
                $(this).siblings("input").val($(this).val());
            });

            // Get Timezone
            getTimeZones("<?php echo e(setRoute('global.timezones')); ?>");

            switcherAjax("<?php echo e(setRoute('admin.web.settings.basic.settings.activation.update')); ?>");
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xamp_8.2\htdocs\salonhub_project\salonhub\resources\views/admin/sections/web-settings/basic-settings.blade.php ENDPATH**/ ?>