<?php

      $manager_id       = auth()->user()->id;
      $parlour          = App\Models\Admin\ParlourList::where('manager_id',$manager_id)->first();
?>

<div class="sidebar">
    <div class="sidebar-inner">
        <div class="sidebar-menu-wrapper">
            <div class="sidebar-logo">
                <a href="<?php echo e(setRoute('frontend.index')); ?>" class="sidebar-main-logo">
                    <img src="<?php echo e(get_logo_manager($basic_settings)); ?>" data-white_img="<?php echo e(get_logo_manager($basic_settings, 'dark')); ?>"
                        data-dark_img="<?php echo e(get_logo_manager($basic_settings)); ?>" alt="logo">
                </a>
                <button class="sidebar-menu-bar">
                    <i class="fas fa-exchange-alt"></i>
                </button>
            </div>
            <ul class="sidebar-menu">
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('manager.dashboard')); ?>">
                        <i class="menu-icon las la-tachometer-alt"></i>
                        <span class="menu-title"><?php echo e(__('Dashboard')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('manager.booking.request.index')); ?>">
                        <i class="menu-icon las la-calendar-check"></i>
                        <span class="menu-title"><?php echo e(__('Booking Request')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <?php if(isset($parlour->id) && $parlour->id): ?>
                        <a href="<?php echo e(route('manager.my.parlour.details', ['id' => $parlour->id])); ?>">
                            <i class="menu-icon las la-store"></i>
                            <span class="menu-title"><?php echo e(__('My Salon')); ?></span>
                        </a>
                    <?php endif; ?>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('manager.assign.stuff.index')); ?>">
                        <i class="menu-icon las la-users-cog"></i>
                        <span class="menu-title"><?php echo e(__('Staff')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="javascript:void(0)" class="logout-btn-manager">
                        <i class="menu-icon las la-sign-out-alt"></i>
                        <span class="menu-title"><?php echo e(__('Logout')); ?></span>
                    </a>
                </li>
            </ul>

        </div>
    </div>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        $(".logout-btn-manager").click(function() {
            var actionRoute = "<?php echo e(setRoute('manager.logout')); ?>";
            var target = 1;
            var message = `<?php echo e(__('Are you sure to')); ?> <strong><?php echo e(__('Logout')); ?></strong>?`;

            openAlertModal(actionRoute, target, message, "<?php echo e(__('Logout')); ?>", "POST");
            /**
             * Function for open delete modal with method DELETE
             * @param {string} URL
             * @param {string} target
             * @param {string} message
             * @returns
             */
            function openAlertModal(URL, target, message, actionBtnText = "<?php echo e(__('Remove')); ?>", method =
                "DELETE") {
                if (URL == "" || target == "") {
                    return false;
                }

                if (message == "") {
                    message = "Are you sure to delete ?";
                }
                var method = `<input type="hidden" name="_method" value="${method}">`;
                openModalByContent({
                        content: `<div class="card modal-alert border-0">
              <div class="card-body">
                  <form method="POST" action="${URL}">
                      <input type="hidden" name="_token" value="${laravelCsrf()}">
                      ${method}
                      <div class="head mb-3">
                          ${message}
                          <input type="hidden" name="target" value="${target}">
                      </div>
                      <div class="foot d-flex align-items-center justify-content-between">
                          <button type="button" class="modal-close btn--base btn-for-modal"><?php echo e(__('Close')); ?></button>
                          <button type="submit" class="alert-submit-btn btn--danger btn-loading btn-for-modal">${actionBtnText}</button>
                      </div>
                  </form>
              </div>
          </div>`,
                    },

                );
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/manager/partials/side-nav.blade.php ENDPATH**/ ?>