<!-- serching data -->

<section class="parlour-list-area pt-80">
    <div class="container">
        <div class="row justify-content-center mb-20-none">
            <?php $__currentLoopData = $parlour_lists ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6 col-sm-10 mb-20">
                    <div class="parlor-item">
                        <div class="parlor-img">
                            <img src="<?php echo e(get_image($item->image, 'site-section')); ?>" alt="img">
                        </div>
                                                    <?php

                                $salon_related_booking = App\Models\ParlourBooking::where(
                                    'status',
                                    global_const()::STATUSSUCCESS,
                                )
                                    ->where('parlour_id', $item->id)

                                    ->whereNotNull('review')
                                    // ->with('parlour')
                                    // dd($salon_with_rating);
                                    ->sum('review');

                                $salon_booking_count = App\Models\ParlourBooking::where(
                                    'status',
                                    global_const()::STATUSSUCCESS,
                                )
                                    ->where('parlour_id', $item->id)

                                    ->whereNotNull('review')
                                    ->with('parlour')
                                    ->count();
                                $salon_average_ratings =
                                    $salon_booking_count > 0 ? $salon_related_booking / $salon_booking_count : 0;

                            ?>

                            <?php if($salon_average_ratings == null): ?>
                                <p><?php echo e(__('No review given')); ?></p>
                            <?php else: ?>
                                <div class="star-rating-display">
                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                        <?php if($i <= $salon_average_ratings): ?>
                                            <span class="star-filled">★</span>
                                        <?php else: ?>
                                            <span class="star-empty">☆</span>
                                        <?php endif; ?>
                                    <?php endfor; ?>
                                    <span class="rating-value">(<?php echo e($salon_average_ratings); ?>/5)</span>
                                </div>
                            <?php endif; ?>
                        <div class="parlor-details">
                            <div class="d-flex justify-content-between align-items-center">
                                <h3 class="title"><?php echo e($item->name ?? ''); ?></h3>
                                <?php if(auth()->check()): ?>
                                    <button class="favorite-btn" data-id="<?php echo e($item->id); ?>">
                                        <?php
                                            $fav_parlour_id = $item->favorites->first()->parlour_id ?? '';
                                        ?>
                                        <i
                                            class="fas fa-heart <?php echo e($fav_parlour_id == $item->id ? 'text-danger' : 'text-secondary'); ?>"></i>
                                    </button>
                                <?php endif; ?>
                            </div>
                            <p><?php echo e($item->manager_name ?? ''); ?></p>
                            <p><?php echo e($item->experience ?? ''); ?> <?php echo e(__('Year Experience')); ?></p>
                            <p><?php echo e($item->address ?? ''); ?></p>
                        </div>
                        <div class="booking-btn pt-2">
                            <a href="<?php echo e(setRoute('frontend.get.service.index', $item->slug)); ?>"
                                class="btn--base w-100"><?php echo e(__('Get Service')); ?></a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub-web-v2.0.0\resources\views/frontend/section/search-result.blade.php ENDPATH**/ ?>