 
 <?php
    $app_local = get_default_language_code();
    $default = App\Constants\LanguageConst::NOT_REMOVABLE;


    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::VENDOR_FEATURES_SECTION);
    $features = App\Models\Admin\SiteSections::getData($slug)->first();


?>
 <!-- Vendor Feature -->
    <section class="vendor-feature ptb-80">
        <div class="container">
            <div class="vendor-feature-title pb-30">
                <div class="row">
                    <div class="col-xl-8 col-lg-10">
                        <div class="feature-title">
                            <h4 class="titte text--base pb-20">
                                <?php echo e($features->value->language->$app_local->section_title ?? ($features->value->language->$default->section_title ?? '')); ?>

                            </h4>
                            <h2 class="title">
                                <?php echo e($features->value->language->$app_local->heading ?? ($features->value->language->$default->heading ?? '')); ?>

                            </h2>
                            <p><?php echo e($features->value->language->$app_local->sub_heading ??
                                ($features->value->language->$default->sub_heading ?? '')); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <?php
                $items = $features->value->items ?? [];
                $item_data = (array) $items;

                $converted_data =
                    count($item_data) > 0 ? array_chunk($item_data, ceil(count($item_data) / 2)) : [[], []];

                $part1 = $converted_data[0] ?? [];

                $part2 = $converted_data[1] ?? [];

            ?>
            <div class="row mb-20-none">
                <div class="col-lg-6 mb-20">
                    <div class="feature-content">
                        <div class="feature-listing">
                            <div class="row mb-20-none">
                                <?php $__currentLoopData = $part1 ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-lg-12 mb-20">
                                        <div class="feature">
                                            <h3 class="title">
                                                <?php echo e($item->language->$app_local->title ?? ($item->language->$default->title ?? '')); ?>

                                            </h3>
                                            <p><?php echo e($item->language->$app_local->description ?? ($item->language->$default->description ?? '')); ?>

                                            </p>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 mb-20">
                    <div class="feature-content">
                        <div class="feature-listing">
                            <div class="row mb-20-none">
                                <?php $__currentLoopData = $part2 ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-lg-12 mb-20">
                                        <div class="feature">
                                            <h3 class="title">
                                                <?php echo e($item->language->$app_local->title ?? ($item->language->$default->title ?? '')); ?>

                                            </h3>
                                            <p><?php echo e($item->language->$app_local->description ?? ($item->language->$default->description ?? '')); ?>

                                            </p>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/frontend/section/vendor-features.blade.php ENDPATH**/ ?>