<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Staff'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
        'active' => __('Staff Assign'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="custom-card">
        <div class="card-body">
            <form class="card-form" action="<?php echo e(setRoute('vendors.stuff.assign.submit')); ?>" method="POST"
                enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="row  mb-10-none">
                    <div class="col-xl-12 col-lg-12 form-group">
                        <label><?php echo e(__('Select Salon')); ?>*</label>
                        <select class="form--control select2-basic" name="parlour_list_id">
                            <option disabled selected><?php echo e(__('Select Salon')); ?></option>
                            <?php $__currentLoopData = $parlour_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="custom-inner-card">
                            <div class="card-inner-header">
                                <h6 class="title"><?php echo e(__('Staff')); ?></h6>
                            </div>
                            <div class="card-inner-body">
                                <div class="stuff-result">
                                    <ul class="permission-list">

                                        <?php $__currentLoopData = $parlour_has_stuff ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-lg-4 col-md-4 col-sm-6 d-flex mb-3">
                                                <div class="box-checkbox" style="flex: 0;">
                                                    <input type="checkbox" name="stuff_name[]" class="stuff-name-checkbox"
                                                        id="stuff-name-list-<?php echo e($item->id); ?>"
                                                        <?php if(in_array($item->stuff_name, $selected_names ?? [])): ?> checked <?php endif; ?>
                                                        value="<?php echo e($item->id); ?>">
                                                </div>
                                                <div class="box-name">
                                                    <?php echo e($item->stuff_name); ?>

                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </ul>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <?php echo $__env->make('admin.components.button.form-btn', [
                            'class' => 'w-100 btn-loading',
                            'text' => 'Submit',
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            var getStuffURL = "<?php echo e(setRoute('manager.assign.stuff.get.stuff')); ?>";
            $('.add-stuff-btn').click(function() {

                $.get(getStuffURL, function(data) {
                    $('.stuff-result').prepend(data);
                    $('.stuff-result').find('.row').first().find("select").select2();
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('vendor.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/vendor/sections/assign-stuff/create.blade.php ENDPATH**/ ?>