<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('vendor.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("user.dashboard"),
        ]
    ], 'active' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

                <div class="tow-fa-security">
                    <div class="row mb-20-none">
                        <div class="col-xl-6 col-lg-6 mb-20">
                            <div class="two-authentic mt-10">
                                <div class="dashboard-header-wrapper">
                                    <h4 class="title"><?php echo e(__('Two Factor Authenticator')); ?></h4>
                                </div>
                                <div class="card-body">
                                    <form class="card-form" method="post" action="<?php echo e(setRoute('user.security.google.2fa.status.update')); ?>">
                                        <div class="row">
                                            <div class="col-xl-12 col-lg-12 form-group">
                                                <label><?php echo e(__('Two Factor Authenticator')); ?><span>*</span></label>
                                                <div class="input-group">
                                                    <input type="text" class="form--control" id="referralURL" value="<?php echo e(auth()->user()->two_factor_secret); ?>" readonly>
                                                    <div class="input-group-text copytext" id="copyBoard"><i class="las la-copy"></i></div>
                                                </div>
                                            </div>
                                            <div class="col-xl-12 col-lg-12 form-group">
                                                <div class="qr-code-thumb text-center">
                                                    <img class="mx-auto" src="<?php echo e($qr_code); ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-12 col-lg-12">
                                            <?php if(auth()->user()->two_factor_status): ?>
                                                <button type="button" class="btn--base bg--warning w-100 active-deactive-btn active"><?php echo e(__("Disable")); ?></button>
                                                <br>
                                                <div class="text--danger mt-3"><?php echo e(__("Don't forget to add this application in your google authentication app. Otherwise you can't login in your account.")); ?></div>
                                            <?php else: ?>
                                                <button type="button" class="btn--base w-100 active-deactive-btn"><?php echo e(__("Enable")); ?></button>
                                            <?php endif; ?>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 mb-20">
                            <div class="two-authentic mt-10">
                                <div class="dashboard-header-wrapper">
                                    <h4 class="title"><?php echo e(__('Google Authenticator')); ?></h4>
                                </div>
                                <div class="card-body">
                                    <h4 class="mb-3"><?php echo e(__('Download Google Authenticator App')); ?></h4>
                                    <p><?php echo e(__('Google Authenticator is a product based authenticator by Google that executes two-venture
                                        confirmation administrations for verifying clients of any programming applications')); ?> <a
                                            href="https://support.google.com/accounts/answer/1066447?hl=en&co=GENIE.Platform=Android"
                                            class="text--base" target="_blanck"><?php echo e(__('How to setup')); ?>?</a> </p>
                                    <div class="play-store-thumb text-center mb-20">
                                        <img class="mx-auto" src="<?php echo e(asset('public/frontend/images/element/authenticator.png')); ?>" alt="img">
                                    </div>
                                    <div class="2fa-btn pt-3">
                                        <a href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2"
                                            class="btn--base mt-10 w-100" target="_blanck"><i class="fab fa-google-play ms-1"></i>
                                            <?php echo e(__('Download For Android')); ?></a>
                                        <a href="https://apps.apple.com/us/app/google-authenticator/id388497605"
                                            class="btn--base mt-10 w-100" target="_blanck"><i class="fab fa-apple ms-1"></i>
                                             <?php echo e(__('Download For IOS')); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

<?php $__env->stopSection(); ?>



<?php $__env->startPush('script'); ?>
    <script>
        $(".active-deactive-btn").click(function(){
            var actionRoute =  "<?php echo e(setRoute('user.security.google.2fa.status.update')); ?>";
            var target      = 1;
            var btnText = $(this).text();
            var message     = `Are you sure to <strong>${btnText}</strong> 2 factor authentication (Powered by google)?`;
            openAlertModal(actionRoute,target,message,btnText,"POST");
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_project\salonhub\resources\views/user/sections/security/google-2fa.blade.php ENDPATH**/ ?>